/*
 * menu.h - Menu definition for the Xaw-based user interface.
 *
 * Written by
 *  Ettore Perazzoli (ettore@comm2000.it)
 *  Teemu Rantanen (tvr@cs.hut.fi)
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

typedef struct _MenuEntry {
    char *string;
    UiMenuCallback callback;
    UiCallbackDataPtr callback_data;
    struct _MenuEntry *sub_menu;
} MenuEntry;

MenuEntry AttachDiskImageSubMenu[] = {
    { "Unit #8...",
      (UiMenuCallback) UiAttachDisk, (UiCallbackDataPtr) 8, NULL },
    { "Unit #9...",
      (UiMenuCallback) UiAttachDisk, (UiCallbackDataPtr) 9, NULL },
    { "Unit #10...",
      (UiMenuCallback) UiAttachDisk, (UiCallbackDataPtr) 10, NULL },
    { NULL }
};

MenuEntry DetachDiskImageSubMenu[] = {
    { "Unit #8",
      (UiMenuCallback) UiDetachDisk, (UiCallbackDataPtr) 8, NULL },
    { "Unit #9",
      (UiMenuCallback) UiDetachDisk, (UiCallbackDataPtr) 9, NULL },
    { "Unit #10",
      (UiMenuCallback) UiDetachDisk, (UiCallbackDataPtr) 10, NULL },
    { "All",
      (UiMenuCallback) UiDetachDisk, (UiCallbackDataPtr) -1, NULL },
    { NULL }
};

MenuEntry LeftMenu[] = {
    { "Attach a disk image",
      NULL, NULL, AttachDiskImageSubMenu },
    { "Detach disk image",
      NULL, NULL, DetachDiskImageSubMenu },
    { "--" },
#if defined(CBM64) || defined(C128)
    { "Attach a tape image...",
      (UiMenuCallback) UiAttachTape, NULL, NULL },
    { "Detach tape image",
      (UiMenuCallback) UiDetachTape, NULL, NULL },
    { "--" },
#endif
    { "Change working directory...",
      (UiMenuCallback) UiChangeWorkingDir, NULL, NULL },
    { "--" },
    { "Activate the Monitor",
      (UiMenuCallback) UiActivateMonitor, NULL, NULL },
    { "Activate the XDebugger",
      (UiMenuCallback) UiActivateXDebugger, NULL, NULL },
#ifdef LED_ARRAY
    { "Activate the Virtual BUS Tester",
      (UiMenuCallback) NULL, NULL, NULL },
#endif
    { "Run C1541",
      (UiMenuCallback) UiRunC1541, NULL, NULL },
    { "--" },
    { "Browse manuals",
      (UiMenuCallback) UiBrowseManual, NULL, NULL },
    { "--" },
    { "Reset",
      (UiMenuCallback) UiReset, NULL, NULL },
    { "Power-On Reset",
      (UiMenuCallback) UiPowerUpReset, NULL, NULL },
    { "--" },
    { "Exit " EMULATOR " emulator",
      (UiMenuCallback) UiExit, NULL, NULL },
    { "--" },
    { "*Pause",
      (UiMenuCallback) UiTogglePause, NULL, NULL },
    { "--" },
    { "About...",
      (UiMenuCallback) UiInfo, NULL, NULL },
    { NULL }
};

MenuEntry SetRefreshRateSubMenu[] = {
    { "*Auto",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 0, NULL },
    { "*1/1",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 1, NULL },
    { "*1/2",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 2, NULL },
    { "*1/3",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 3, NULL },
    { "*1/4",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 4, NULL },
    { "*1/5",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 5, NULL },
    { "*1/6",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 6, NULL },
    { "*1/7",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 7, NULL },
    { "*1/8",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 8, NULL },
    { "*1/9",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 9, NULL },
    { "*1/10",
      (UiMenuCallback) UiSetRefreshRate, (UiCallbackDataPtr) 10, NULL },
    { "--" },
    { "*Custom...",
      (UiMenuCallback) UiSetCustomRefreshRate, NULL, NULL },
    { NULL }
};

MenuEntry SetMaximumSpeedSubMenu[] = { 
    { "*100%",
      (UiMenuCallback) UiSetMaximumSpeed, (UiCallbackDataPtr) 100, NULL },
    { "*50%",
      (UiMenuCallback) UiSetMaximumSpeed, (UiCallbackDataPtr) 50, NULL },
    { "*20%",
      (UiMenuCallback) UiSetMaximumSpeed, (UiCallbackDataPtr) 20, NULL },
    { "*10%",
      (UiMenuCallback) UiSetMaximumSpeed, (UiCallbackDataPtr) 10, NULL },
    { "*No limit",
      (UiMenuCallback) UiSetMaximumSpeed, (UiCallbackDataPtr) 0, NULL },
    { "--" },
    { "*Custom...",
      (UiMenuCallback) UiSetCustomMaximumSpeed, NULL, NULL },
    { NULL }
};

#if defined (CBM64) || defined (C128)

#ifndef HAS_JOYSTICK

MenuEntry SetNumpadJoystickPortSubMenu[] = { 
    { "*#1",
      (UiMenuCallback) UiSetNumpadJoystickPort, (UiCallbackDataPtr) 1, NULL },
    { "*#2",
      (UiMenuCallback) UiSetNumpadJoystickPort, (UiCallbackDataPtr) 2, NULL },
    { NULL }
};

#else  /* HAS_JOYSTICK */

MenuEntry SetJoystickDevice1SubMenu[] = {
    { "*None",
      (UiMenuCallback) UiSetJoystickDevice1, (UiCallbackDataPtr) 0, NULL },
    { "*Analog Joystick 0",
      (UiMenuCallback) UiSetJoystickDevice1, (UiCallbackDataPtr) 1, NULL },
    { "*Analog Joystick 1",
      (UiMenuCallback) UiSetJoystickDevice1, (UiCallbackDataPtr) 2, NULL },
#ifdef HAS_DIGITAL_JOYSTICK
    { "*Digital Joystick 0",
      (UiMenuCallback) UiSetJoystickDevice1, (UiCallbackDataPtr) 3, NULL },
    { "*Digital Joystick 1",
      (UiMenuCallback) UiSetJoystickDevice1, (UiCallbackDataPtr) 4, NULL },
#endif
    { "*Numpad",
      (UiMenuCallback) UiSetJoystickDevice1, (UiCallbackDataPtr) 5, NULL },
    { NULL }
};

MenuEntry SetJoystickDevice2SubMenu[] = {
    { "*None",
      (UiMenuCallback) UiSetJoystickDevice2, (UiCallbackDataPtr) 0, NULL },
    { "*Analog Joystick 0",
      (UiMenuCallback) UiSetJoystickDevice2, (UiCallbackDataPtr) 1, NULL },
    { "*Analog Joystick 1",
      (UiMenuCallback) UiSetJoystickDevice2, (UiCallbackDataPtr) 2, NULL },
#ifdef HAS_DIGITAL_JOYSTICK
    { "*Digital Joystick 0",
      (UiMenuCallback) UiSetJoystickDevice2, (UiCallbackDataPtr) 3, NULL },
    { "*Digital Joystick 1",
      (UiMenuCallback) UiSetJoystickDevice2, (UiCallbackDataPtr) 4, NULL },
#endif
    { "*Numpad",
      (UiMenuCallback) UiSetJoystickDevice2, (UiCallbackDataPtr) 5, NULL },
    { NULL }
};

#endif /* HAS_JOYSTICK */

#endif /* CBM64 || C128 */

#ifdef HAVE_TRUE1541

MenuEntry Change1541SyncFactorSubMenu[] = { 
    { "*PAL", (UiMenuCallback) UiSet1541SyncFactor,
      (UiCallbackDataPtr) TRUE1541_PAL_SYNC_FACTOR, NULL },
    { "*NTSC", (UiMenuCallback) UiSet1541SyncFactor,
      (UiCallbackDataPtr) TRUE1541_NTSC_SYNC_FACTOR, NULL },
    { "*Custom...", (UiMenuCallback) UiSetCustom1541SyncFactor,
      NULL, NULL },
    { NULL }
};

MenuEntry Change1541IdleMethodSubMenu[] = {
    { "*Skip cycles", (UiMenuCallback) UiSet1541IdleMethod,
      (UiCallbackDataPtr) TRUE1541_IDLE_SKIP_CYCLES, NULL },
    { "*Trap idle", (UiMenuCallback) UiSet1541IdleMethod,
      (UiCallbackDataPtr) TRUE1541_IDLE_TRAP_IDLE, NULL },
    { NULL }
};

#endif

#ifdef SOUND

MenuEntry ChangeSoundSampleRateSubMenu[] = { 
    { "*8000Hz", (UiMenuCallback) UiSetSoundSampleRate,
      (UiCallbackDataPtr) 8000, NULL },
    { "*11025Hz", (UiMenuCallback) UiSetSoundSampleRate,
      (UiCallbackDataPtr) 11025, NULL },
    { "*22050Hz", (UiMenuCallback) UiSetSoundSampleRate,
      (UiCallbackDataPtr) 22050, NULL },
    { "*44100Hz", (UiMenuCallback) UiSetSoundSampleRate,
      (UiCallbackDataPtr) 44100, NULL },
    { "*48000Hz", (UiMenuCallback) UiSetSoundSampleRate,
      (UiCallbackDataPtr) 48000, NULL },
    { NULL }
};
MenuEntry ChangeSoundBufferSizeSubMenu[] = { 
    { "*1.00 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 1000, NULL },
    { "*0.75 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 750, NULL },
    { "*0.50 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 500, NULL },
    { "*0.35 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 350, NULL },
    { "*0.30 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 300, NULL },
    { "*0.25 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 250, NULL },
    { "*0.20 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 200, NULL },
    { "*0.15 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 150, NULL },
    { "*0.10 sec", (UiMenuCallback) UiSetSoundBufferSize,
      (UiCallbackDataPtr) 100, NULL },
    { NULL }
};
MenuEntry ChangeSoundSuspendTimeSubMenu[] = {
    { "*Keep going", (UiMenuCallback) UiSetSoundSuspendTime,
      (UiCallbackDataPtr) 0, NULL },
    { "*1 sec suspend", (UiMenuCallback) UiSetSoundSuspendTime,
      (UiCallbackDataPtr) 1, NULL },
    { "*2 sec suspend", (UiMenuCallback) UiSetSoundSuspendTime,
      (UiCallbackDataPtr) 2, NULL },
    { "*5 sec suspend", (UiMenuCallback) UiSetSoundSuspendTime,
      (UiCallbackDataPtr) 5, NULL },
    { "*10 sec suspend", (UiMenuCallback) UiSetSoundSuspendTime,
      (UiCallbackDataPtr) 10, NULL },
    { NULL }
};

#endif /* SOUND */

#if defined(CBM64) || defined(C128)

MenuEntry SpecialFeaturesSubMenu[] = {
    { "*Emulation identification",
      (UiMenuCallback) UiToggleEmuID, NULL, NULL },
#ifdef IEEE488
    { "*IEEE488 interface emulation",
      (UiMenuCallback) UiToggleIEEE488, NULL, NULL },
#endif
#ifdef REU
#if REUSIZE == 256
    { "*256K RAM Expansion Unit",
      (UiMenuCallback) UiToggleREU, NULL, NULL },
#else
    { "*512K RAM Expansion Unit",
      (UiMenuCallback) UiToggleREU, NULL, NULL },
#endif
#endif
    { NULL }
};

#endif /* CBM64 || C128 */

MenuEntry RightMenu[] = { 
    { "Refresh rate",
      NULL, NULL, SetRefreshRateSubMenu },
    { "Maximum speed",
      NULL, NULL, SetMaximumSpeedSubMenu },
#if defined (C128) || defined (CBM64)
    { "--" },
    { "*Sprite-sprite collisions",
      (UiMenuCallback) UiToggleSpriteToSpriteCollisions, NULL, NULL },
    { "*Sprite-background collisions",
      (UiMenuCallback) UiToggleSpriteToBackgroundCollisions, NULL, NULL },
    { "--" },
#ifndef HAS_JOYSTICK
    { "*Numpad joystick port",
      NULL, NULL, SetNumpadJoystickPortSubMenu },
#else
    { "*Joystick device in port 1",
      NULL, NULL, SetJoystickDevice1SubMenu },
    { "*Joystick device in port 2",
      NULL, NULL, SetJoystickDevice2SubMenu },
#endif
    { "Swap joystick ports",
      (UiMenuCallback) UiSwapJoystickPorts, NULL, NULL },
#endif
    { "--" },
    { "*Video cache",
      (UiMenuCallback) UiToggleVideoCache, NULL, NULL },
    { "*Double size",
      (UiMenuCallback) UiToggleDoubleSize, NULL, NULL },
    { "*Double scan",
      (UiMenuCallback) UiToggleDoubleScan, NULL, NULL },
#ifdef __unix
    { "*Use XSync()",
      (UiMenuCallback) UiToggleUseXSync, NULL, NULL },
#endif
    { "--" },
#ifdef HAVE_TRUE1541
    { "*True 1541 emulation",
      (UiMenuCallback) UiToggleTrue1541, NULL, NULL },
    { "True 1541 sync factor",
      NULL, NULL, Change1541SyncFactorSubMenu },
    { "True 1541 idle method",
      NULL, NULL, Change1541IdleMethodSubMenu },
    { "--" },
#endif
#ifdef SOUND
    { "*Sound",
      (UiMenuCallback) UiToggleSound, NULL, NULL },
    { "*Sound sample rate",
      NULL, NULL, ChangeSoundSampleRateSubMenu },
    { "*Sound buffer size",
      NULL, NULL, ChangeSoundBufferSizeSubMenu },
    { "*Sound speed adjustment",
      (UiMenuCallback) UiToggleSoundSpeedAdjustment, NULL, NULL },
    { "*Sound suspend time",
      NULL, NULL, ChangeSoundSuspendTimeSubMenu },
    { "--" },
#endif
#if defined(CBM64) || defined(C128)
    { "I/O Extensions at $DF00",
      NULL, NULL, SpecialFeaturesSubMenu },
    { "--" },
#endif
    { "Save settings",
      (UiMenuCallback) UiSaveResources, NULL, NULL },
    { "Load settings",
      (UiMenuCallback) UiLoadResources, NULL, NULL },
    { "Restore default settings",
      (UiMenuCallback) UiSetDefaultResources, NULL, NULL },
    { "*Save settings on exit",
      (UiMenuCallback) UiToggleSaveResourcesOnExit, NULL, NULL },
    { NULL }
};
