/*
 * pia.h -- PIA chip emulation.
 *
 * Written by
 *  Jouko Valta (jopi@stekt.oulu.fi)
 *  Andre' Fachat (fachat@physik.tu-chemnitz.de)
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _PIA_H
#define _PIA_H

extern void reset_pia1(void);
extern void reset_pia2(void);
extern void REGPARM2 store_pia1(ADDRESS addr, BYTE value);
extern BYTE REGPARM1 read_pia1(ADDRESS addr);
extern void REGPARM2 store_pia2(ADDRESS addr, BYTE value);
extern BYTE REGPARM1 read_pia2(ADDRESS addr);

#endif
