#ifndef __RVS_FPROPDLG_H__
#define __RVS_FPROPDLG_H__

/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: fpropdlg.h,v $
 *
 * $Revision: 1.3 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: fpropdlg.h,v $
 * Revision 1.3  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 * Revision 1.2  1997/05/27  09:10:46  ruben
 * reworked to act as modal
 *
 * Revision 1.1  1997/03/28  17:48:16  ruben
 * Initial revision
 *
 * Revision 1.1  1997/03/28 17:48:16  ruben
 * Initial revision
 *
 */

#include <qapp.h>
#include <qdialog.h>
#include <qstring.h>

#include <sys/types.h>

class   QCheckBox;
class   QLabel;
class   QComboBox;
class   QStrList;
class   QString;
class   QLineEdit;

class   FPropdlg:public QDialog
{

	Q_OBJECT

	enum Perms
	{
		SETUID = 0, SETGID, STICKY,
		O_READ, O_WRTE, O_EXEC,
		G_READ, G_WRTE, G_EXEC,
		W_READ, W_WRTE, W_EXEC,
		NumPerms
	};

	enum Owner
	{
		UID = 0,
		GID
	};

	public:

	FPropdlg(const char *file, QWidget * parent = 0, const char *name = 0);
	~FPropdlg();

	// these are here for convinience, if you use dlg->exec();
	
	gid_t		getUid();
	uid_t		getGid();
	mode_t		getMode();
	const char*	getName();
	const char*	getNewname();

	public  slots:

	void    getProperties(const char *);

	private slots:

	void    nameChanged(const char *);
	void    modeChanged(int);
	void    ownerChanged(int);

	void    setProperties();
	void    undoProperties();
	void    cancelProperties();

	signals:

	// If a file its properties have changed, you will get the old name
	// in the first argument to your slot, and a new name if the second
	// argument if your file was renamed :)
	
	void    propertiesChanged(const char *, const char *);

	private:

	bool do_rename,
			do_chmod,
			do_chown;

	uid_t   orig_uid,
			new_uid;
	gid_t   orig_gid,
			new_gid;
	mode_t  orig_mode,
			new_mode;

	QString *absfname,
			*newabsfname;
	QLineEdit *fname;
	QStrList *names,
	       *groups;
	QCheckBox *perm_ctl[NumPerms];
	QComboBox *ownership[2];
	QLabel *fileinfo;

};

#endif	 // __RVS_FPROPDLG_H__
