/*
 * Worldvisions Weaver Software:
 *   Copyright (C) 1997 Worldvisions Computer Technology, Inc.
 *
 * Reads /etc/ppp/pap-secrets, and can add entries if need be.
 *
 * Created:	Feb 7 1998		D. Coombs
 *   
 */

#ifndef __WVPAPSECRETS_H
#define __WVPAPSECRETS_H

#define PAP_SECRETS	"/etc/ppp/pap-secrets"
#define PAP_FILE_PERMS	0600	// use 600 for root-only read/write
				// use 660 for dip-group read/write
				// DLC -- I used 660 for testing purposes,
				// but changed it to 600 for distribution.

#include "strutils.h"
#include "wvstream.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

typedef struct a_pap_secret
/*************************/
{
    WvString	local;
    WvString	remote;
    WvString	password;
    WvString	rest;
} a_pap_secret;

class WvPapSecrets
/****************/
{
public:
    WvPapSecrets();
    ~WvPapSecrets();

    a_pap_secret *	get_secret( WvString     username );
    bool		put_secret( WvString	 username,
    				    WvString	 password );
    bool		put_secret( a_pap_secret secret );
    void		del_secret( WvString	 username );
    bool		isok();

private:
    WvFile		pap_file;
    bool		opened_ok;
    bool		open_file();
    bool		parse_secret_line( char * 	   secret_line,
    					   a_pap_secret *  secret );
};

#endif // __WVPAPSECRETS_H
