/* GTK-- - a C++ wrapper for the Gtk toolkit
 *
 * The signal system used by gtk--
 *
 * This file has handling of plain signals - this should be
 * independent of gtk, but it currently isnt.
 * 
 * Copyright (C) 1997 Elliot Lee <sopwith@redhat.com>      
 *                    Phil Dawes
 *                    Tero Pulkkinen
 *
 * Currently maintained by Tero Pulkkinen. <terop@modeemi.cs.tut.fi>
 *                                                        
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GTKMM_SIGCPP
#define GTKMM_SIGCPP
/*************************************************************/
/* Tero's signal implementation starts from here.            */
/* This makes some additions to Phil's slot stuffs           */
/* Now it is possible for a C++ programmer to create signals */
/*************************************************************/

template<class rettype>
class Abstractslot0 : public Connection_impl {
public:
  virtual rettype call()=0;
};


template<class rettype>
class Signal0_r {
  G_List connectionlist;
public:
  void insert_connection(Abstractslot0<rettype>* slot) { 
    connectionlist.insert(slot); 
  }
  rettype operator()() {
    Connection_impl *c=connectionlist.begin();
    while(c!=connectionlist.end()) {
      ( (Abstractslot0<rettype>*)c )->call();
      c=c->next;
    }
  }
};

class Signal0 : public Signal0_r<void> { };

// this is for C++ signal connected to C++ slot
template<class rettype,class T>
class Concretecppslot0 : public Abstractslot0<rettype> {
private:
  T* obj;   
  rettype (T::*method)();
public:
  Concretecppslot0(T* receiver, rettype (T::*met)()) 
  : obj(receiver), method(met) {}
  rettype call() { SP_RETURN (obj->*method)(); }
};

#ifdef HAVE_PARTIAL_SPECIALIZATION
// this is for C++ signal connected to C++ slot
template<class T>
class Concretecppslot0<void,T> : public Abstractslot0<void> {
private:
  T* obj;   
  void (T::*method)();
public:
  Concretecppslot0(T* receiver, void (T::*met)()) 
  : obj(receiver), method(met) {}
  void call() { (obj->*method)(); }
};
#endif


template<class rettype, class T>
Connection
connect_to_method(Signal0_r<rettype> &signal,
	T* receiver, rettype (T::*method)())
{
  Concretecppslot0<rettype,T> *slot=new Concretecppslot0<rettype,T>(receiver,method);
  signal.insert_connection(slot);
  receiver->insert_connection(slot);
  return Connection(slot);
}

template<class T>
Connection
connect_to_method(Signal0 &signal,
	T* receiver, void (T::*method)())
{
  Concretecppslot0<void,T> *slot=new Concretecppslot0<void,T>(receiver,method);
  signal.insert_connection(slot);
  receiver->insert_connection(slot);
  return Connection(slot);
}

// ------------------------------------------------ same with cbdata
// this is for C++ signal connected to C++ slot
template<class rettype,class T, class E>
class Concretecppslot0cb : public Abstractslot0<rettype> {
private:
  T* obj;   
  rettype (T::*method)(E);
  E cbdata;
public:
  Concretecppslot0cb(T* receiver, rettype (T::*met)(E),E cbd) 
  : obj(receiver), method(met), cbdata(cbd) {}
  rettype call() { SP_RETURN (obj->*method)(cbdata); }
};

#ifdef HAVE_PARTIAL_SPECIALIZATION
template<class T, class E>
class Concretecppslot0cb<void,T,E> : public Abstractslot0<void> {
private:
  T* obj;   
  void (T::*method)(E);
  E cbdata;
public:
  Concretecppslot0cb(T* receiver, void (T::*met)(E),E cbd) 
  : obj(receiver), method(met), cbdata(cbd) {}
  void call() { (obj->*method)(cbdata); }
};
#endif


template<class rettype, class T, class E>
Connection
connect_to_method(Signal0_r<rettype> &signal,
	T* receiver, rettype (T::*method)(E),E cbd)
{
  Abstractslot0<rettype> *slot=new Concretecppslot0cb<rettype,T,E>(receiver,method,cbd);
  signal.insert_connection(slot);
  receiver->insert_connection(slot);
  return Connection(slot);
}


template<class T, class E>
Connection
connect_to_method(Signal0 &signal,
	T* receiver, void (T::*method)(E),E cbd)
{
  Abstractslot0<void> *slot=new Concretecppslot0cb<void,T,E>(receiver,method,cbd);
  signal.insert_connection(slot);
  receiver->insert_connection(slot);
  return Connection(slot);
}



// -------------------------------------- without cbdata
// C++ signal connected to static function
template<class rettype,class M>
class Concretegtkslot0 : public Abstractslot0<rettype> {
private:
  M func;
public:
  Concretegtkslot0(M func_) : func(func_){ }
  rettype call() { SP_RETURN func(); }
  static rettype callback(GtkWidget *, Concretegtkslot0<rettype,M>* s) { SP_RETURN s->call(); }
};

#ifdef HAVE_PARTIAL_SPECIALIZATION
template<class M>
class Concretegtkslot0<void,M> : public Abstractslot0<void> {
private:
  M func;
public:
  Concretegtkslot0(M func_) : func(func_){ }
  void call() { func(); }
  static void callback(GtkWidget *, Concretegtkslot0<void,M>* s) { s->call(); }
};
#endif


template<class rettype>
inline Connection
connect_to_function(Signal0_r<rettype> &signal,
	rettype (*func)()) {
  Concretegtkslot0<rettype,rettype(*)()> *slot=new Concretegtkslot0<rettype,rettype(*)()>(func);
  signal.insert_connection(slot);
  return Connection(slot);
}

template<class rettype, class M>
inline Connection
connect_to_signal(Signal0_r<rettype> &signal,
	M& func) {
  Concretegtkslot0<rettype,M&> *slot=new Concretegtkslot0<rettype,M&>(func);
  signal.insert_connection(slot);
  return Connection(slot);
}


inline Connection
connect_to_function(Signal0 &signal,
	void (*func)()) {
  Concretegtkslot0<void,void(*)()> *slot=new Concretegtkslot0<void,void(*)()>(func);
  signal.insert_connection(slot);
  return Connection(slot);
}

// a function object wrapper.
template<class M>
inline Connection
connect_to_signal(Signal0 &signal,
	M &func) {
  Concretegtkslot0<void,M&> *slot=new Concretegtkslot0<void,M&>(func);
  signal.insert_connection(slot);
  return Connection(slot);
}



// -------------------------------------- with cbdata
template<class rettype, class M, class E>
class Concretegtkslot0cb : public Abstractslot0<rettype> {
private:
  M func;
  E cbdata;
public:
  Concretegtkslot0cb(M func_, E cbd) : func(func_),cbdata(cbd) { }
  rettype call() { SP_RETURN func(cbdata); }
  static rettype callback(GtkWidget *, Concretegtkslot0cb<rettype,M,E>* s) { SP_RETURN s->call(); }
};

#ifdef HAVE_PARTIAL_SPECIALIZATION
template<class M, class E>
class Concretegtkslot0cb<void,M,E> : public Abstractslot0<void> {
private:
  M func;
  E cbdata;
public:
  Concretegtkslot0cb(M func_, E cbd) : func(func_),cbdata(cbd) { }
  void call() { func(cbdata); }
  static void callback(GtkWidget *, Concretegtkslot0cb<void,M,E>* s) { s->call(); }
};
#endif


template<class rettype,class E>
Connection
connect_to_function(Signal0_r<rettype> &signal,
	rettype (*func)(E),E cbd) {
  Concretegtkslot0cb<rettype,rettype (*)(E),E> *slot=new Concretegtkslot0cb<rettype,rettype(*)(E),E>(func,cbd);
  signal.insert_connection(slot);
  return Connection(slot);
}

template<class rettype, class M,class E>
Connection
connect_to_signal(Signal0_r<rettype> &signal,
	M& func,E cbd) {
  Concretegtkslot0cb<rettype,M&,E> *slot=new Concretegtkslot0cb<rettype,M&,E>(func,cbd);
  signal.insert_connection(slot);
  return Connection(slot);
}


template<class E>
Connection
connect_to_function(Signal0 &signal,
	void (*func)(E),E cbd) {
  Concretegtkslot0cb<void,void(*)(E),E> *slot=new Concretegtkslot0cb<void,void(*)(E),E>(func,cbd);
  signal.insert_connection(slot);
  return Connection(slot);
}

template<class E, class M>
Connection
connect_to_signal(Signal0 &signal,
	M& func,E cbd) {
  Concretegtkslot0cb<void,M&,E> *slot=new Concretegtkslot0cb<void,M&,E>(func,cbd);
  signal.insert_connection(slot);
  return Connection(slot);
}



	     
#define SIGNALS_IMPL(NUM,CB,TEMPLATE_PARAM,ARG_BOTH,ARG_TYPE,ARG_NAME) \
		     \
template<class rettype, TEMPLATE_PARAM> \
class Abstractslot##NUM : public Connection_impl { \
public: \
  virtual rettype call(ARG_BOTH)=0; \
}; \
\
template<class rettype,TEMPLATE_PARAM> \
class Signal##NUM##_r { \
  G_List connectionlist; \
public: \
  void insert_connection(Abstractslot##NUM<rettype,ARG_TYPE>* slot) { \
    connectionlist.insert(slot); \
  } \
  rettype operator()(ARG_BOTH) { \
    Connection_impl *c=connectionlist.begin(); \
    while(c!=connectionlist.end()) { \
      ( (Abstractslot##NUM<rettype,ARG_TYPE>*)c )->call(ARG_NAME); \
      c=c->next; \
    } \
  } \
}; \
template<TEMPLATE_PARAM> \
class Signal##NUM : public Signal##NUM##_r<void, ARG_TYPE> { };


#define C_SIGNALS_IMPL(NUM,CB,TEMPLATE_PARAM,ARG_BOTH,ARG_TYPE,ARG_NAME,COMMA_CLASS_E,COMMA_E,COMMA_E_PTR,COMMA_E_PTR_ARG,COMMA_ARG,C_ARG,C_VAR,C_DATA) \
template<class rettype,class T,TEMPLATE_PARAM COMMA_CLASS_E> \
class Concretecppslot##NUM##CB : public Abstractslot##NUM<rettype,ARG_TYPE> { \
private: \
  T* obj; \
  rettype (T::*method)(ARG_TYPE COMMA_E_PTR); \
  C_VAR \
public: \
  Concretecppslot##NUM##CB(T* receiver, rettype (T::*met)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) \
    : obj(receiver), method(met) C_ARG {} \
  rettype call(ARG_BOTH) { VR_RETURN (obj->*method)(ARG_NAME C_DATA); } \
}; \
\
template<class rettype,class T,class T1, TEMPLATE_PARAM COMMA_CLASS_E> \
Connection \
connect_to_method(Signal##NUM##_r<rettype,ARG_TYPE> &signal, \
	T* receiver, rettype (T1::*method)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) \
{ \
  Abstractslot##NUM<rettype,ARG_TYPE> *slot= \
    new Concretecppslot##NUM##CB<rettype,T,ARG_TYPE COMMA_E>(receiver,method COMMA_ARG); \
  signal.insert_connection(slot); \
  receiver->insert_connection(slot); \
  return Connection(slot); \
} \
template<class T,class T1, TEMPLATE_PARAM COMMA_CLASS_E> \
Connection \
connect_to_method(Signal##NUM##<ARG_TYPE> &signal, \
	T* receiver, void (T1::*method)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) \
{ \
  Abstractslot##NUM<void,ARG_TYPE> *slot= \
    new Concretecppslot##NUM##CB<void,T,ARG_TYPE COMMA_E>(receiver,method COMMA_ARG); \
  signal.insert_connection(slot); \
  receiver->insert_connection(slot); \
  return Connection(slot); \
} \
\
template<class rettype, class M,TEMPLATE_PARAM COMMA_CLASS_E> \
class Concretegtkslot##NUM##CB : public Abstractslot##NUM<rettype,ARG_TYPE> { \
private: \
  M func;\
  C_VAR \
public: \
  Concretegtkslot##NUM##CB(M func_ COMMA_E_PTR_ARG) \
    : func(func_) C_ARG { } \
  rettype call(ARG_BOTH) { VR_RETURN func(ARG_NAME C_DATA); } \
  static rettype callback(GtkWidget *, ARG_BOTH, Concretegtkslot##NUM##CB<rettype,M,ARG_TYPE COMMA_E>* s) { VR_RETURN s->call(ARG_NAME); }\
}; \
\
template<class rettype,TEMPLATE_PARAM COMMA_CLASS_E> \
Connection \
connect_to_function(Signal##NUM##_r<rettype,ARG_TYPE> &signal, \
	rettype (*func)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) { \
  Concretegtkslot##NUM##CB<rettype,rettype(*)(ARG_TYPE COMMA_E_PTR),ARG_TYPE COMMA_E> *slot= \
    new Concretegtkslot##NUM##CB<rettype,rettype(*)(ARG_TYPE COMMA_E_PTR),ARG_TYPE COMMA_E>(func COMMA_ARG); \
  signal.insert_connection(slot); \
  return Connection(slot); \
}\
template<TEMPLATE_PARAM COMMA_CLASS_E> \
Connection \
connect_to_function(Signal##NUM<ARG_TYPE> &signal, \
	void (*func)(ARG_TYPE COMMA_E_PTR) COMMA_E_PTR_ARG) { \
  Concretegtkslot##NUM##CB<void,void (*)(ARG_TYPE COMMA_E_PTR),ARG_TYPE COMMA_E> *slot= \
    new Concretegtkslot##NUM##CB<void,void(*)(ARG_TYPE COMMA_E_PTR),ARG_TYPE COMMA_E>(func COMMA_ARG); \
  signal.insert_connection(slot); \
  return Connection(slot); \
} \
\
\
template<class rettype,class M,TEMPLATE_PARAM COMMA_CLASS_E> \
Connection \
connect_to_signal(Signal##NUM##_r<rettype,ARG_TYPE> &signal, \
	M& func COMMA_E_PTR_ARG) { \
  Concretegtkslot##NUM##CB<rettype,M&,ARG_TYPE COMMA_E> *slot= \
    new Concretegtkslot##NUM##CB<rettype,M&,ARG_TYPE COMMA_E>(func COMMA_ARG); \
  signal.insert_connection(slot); \
  return Connection(slot); \
}\
template<class M,TEMPLATE_PARAM COMMA_CLASS_E> \
Connection \
connect_to_signal(Signal##NUM<ARG_TYPE> &signal, \
	M& func COMMA_E_PTR_ARG) { \
  Concretegtkslot##NUM##CB<void,M &,ARG_TYPE COMMA_E> *slot= \
    new Concretegtkslot##NUM##CB<void,M&,ARG_TYPE COMMA_E>(func COMMA_ARG); \
  signal.insert_connection(slot); \
  return Connection(slot); \
}



SIGNALS_IMPL(1,,class P1,
	     P1 p,
	     P1,
	     p)

C_SIGNALS_IMPL(1,,class P1,
	     P1 p,
	     P1,
	     p,
	     ,,,,,,,)

C_SIGNALS_IMPL(1,cb,class P1,
  	     P1 p,
  	     P1,
  	     p,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)

SIGNALS_IMPL(2,,class P1 COMMA class P2,
	     P1 p1 COMMA P2 p2,
	     P1 COMMA P2,
	     p1 COMMA p2)

C_SIGNALS_IMPL(2,,class P1 COMMA class P2,
	     P1 p1 COMMA P2 p2,
	     P1 COMMA P2,
	     p1 COMMA p2,
	     ,,,,,,,)

C_SIGNALS_IMPL(2,cb,class P1 COMMA class P2,
	     P1 p1 COMMA P2 p2,
	     P1 COMMA P2,
	     p1 COMMA p2,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)

SIGNALS_IMPL(3,,class P1 COMMA class P2 COMMA class P3,
	     P1 p1 COMMA P2 p2 COMMA P3 p3,
	     P1 COMMA P2 COMMA P3,
	     p1 COMMA p2 COMMA p3)

C_SIGNALS_IMPL(3,,class P1 COMMA class P2 COMMA class P3,
	     P1 p1 COMMA P2 p2 COMMA P3 p3,
	     P1 COMMA P2 COMMA P3,
	     p1 COMMA p2 COMMA p3,
	     ,,,,,,,)

C_SIGNALS_IMPL(3,cb,class P1 COMMA class P2 COMMA class P3,
	     P1 p1 COMMA P2 p2 COMMA P3 p3,
	     P1 COMMA P2 COMMA P3,
	     p1 COMMA p2 COMMA p3,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)

SIGNALS_IMPL(4,,class P1 COMMA class P2 COMMA class P3 COMMA class P4,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4,
	     P1 COMMA P2 COMMA P3 COMMA P4,
	     p1 COMMA p2 COMMA p3 COMMA p4)

C_SIGNALS_IMPL(4,,class P1 COMMA class P2 COMMA class P3 COMMA class P4,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4,
	     P1 COMMA P2 COMMA P3 COMMA P4,
	     p1 COMMA p2 COMMA p3 COMMA p4,
	     ,,,,,,,)

C_SIGNALS_IMPL(4,cb,class P1 COMMA class P2 COMMA class P3 COMMA class P4,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4,
	     P1 COMMA P2 COMMA P3 COMMA P4,
	     p1 COMMA p2 COMMA p3 COMMA p4,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)

SIGNALS_IMPL(5,,class P1 COMMA class P2 COMMA class P3 COMMA class P4 COMMA class P5,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4 COMMA P5 p5,
	     P1 COMMA P2 COMMA P3 COMMA P4 COMMA P5,
	     p1 COMMA p2 COMMA p3 COMMA p4 COMMA p5)

C_SIGNALS_IMPL(5,,class P1 COMMA class P2 COMMA class P3 COMMA class P4 COMMA class P5,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4 COMMA P5 p5,
	     P1 COMMA P2 COMMA P3 COMMA P4 COMMA P5,
	     p1 COMMA p2 COMMA p3 COMMA p4 COMMA p5,
	     ,,,,,,,)

C_SIGNALS_IMPL(5,cb,class P1 COMMA class P2 COMMA class P3 COMMA class P4 COMMA class P5,
	     P1 p1 COMMA P2 p2 COMMA P3 p3 COMMA P4 p4 COMMA P5 p5,
	     P1 COMMA P2 COMMA P3 COMMA P4 COMMA P5,
	     p1 COMMA p2 COMMA p3 COMMA p4 COMMA p5,
COMMA class E,COMMA E,COMMA E,COMMA E cbd,COMMA cbd,COMMA cbdata(cbd),
E cbdata;,COMMA cbdata)

#undef COMMA
#undef CALLBACK_IMPL
#undef SIGNALS_IMPL
#undef C_SIGNALS_IMPL

#endif
