/* gnh.java */
/* Chris Jacobi, August 15, 1997 11:14 am PDT */

/*
    javac -d classes gnh.java
    java xerox.ilu.tools.gnh -jni ilunative.test
    java xerox.ilu.tools.gnh -oni ilunative.in
*/

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: gnh.java,v 1.13 1997/08/15 21:07:07 jacobi Exp $ */

package xerox.ilu.tools;

/**
 * Generate native header files so that the actual
 * native code is independent of the architecture
 * for native headers. <p>
 *
 * This handles only a subset of all possibilities for
 * native access.  Portable programs will either stick
 * to this subset or will extend this tool. This is not
 * a tool for the general public but for programmers of
 * of native ..methods. Besides of restrictions on the
 * supported cases it also expects correct input.<p>
 *
 * ONI is my own acronym for Sun's "OLD native interface"<br>
 * JNI Sun's underpowered "java native interface"<br>
 * RNI Microsofts "raw native interface"<br>
 * JRI is Netscape's "Java Runtime Interface" <p>
 *
 * <pre>
 * Currently understands oni.
 * Currently understands dynamic fields.
 *    (Static fields are not important to ilu)
 *
 * Input is line oriented
 * Lines starting with // are comment
 * Lines starting with CLASS set the current class
 * Lines starting with FIELD make a field in the current class accessible
 *
 * CLASS lines syntax:
 * class fully-qualified-name-of-class 
 *
 * FILED lines syntax:
 * field name-of-field type-signature-of-field
 * Currently supports only simple types
 * Special type-signature: type-signature's starting with 0
 *    are long fields in java used to store native pointers;
 *    following the 0 is the type for the c pointer.
 *
 * </pre>
 */
 
public class gnh {

    /* This is used at build time and I couldn't care
     * less about efficiency
     */

    public static final int modeONI = 1;
    public static final int modeJNI = 2;
    public static final int modeRNI = 3;

    public static boolean debug = false;

    public static String shortMyPackagePrefix = "xerox_ilu_";

    public static String quoted(String s) {
        return "\"" + s + "\"";
    }
    
    public static void usage(String s) {
        if (s !=null) {
            System.err.println(s);
        }
        System.err.print("use: java gnh ");
        System.err.println("(-jni | -oni | -rni) file");
        System.exit(1);
    } //usage
    
    static java.util.Hashtable jni_piece_tab = new java.util.Hashtable();
    static {
        jni_piece_tab.put("Z", "Boolean");
        jni_piece_tab.put("B", "Byte");
        jni_piece_tab.put("C", "Char");
        jni_piece_tab.put("S", "Short");
        jni_piece_tab.put("I", "Int");
        jni_piece_tab.put("J", "Long");
        jni_piece_tab.put("F", "Float");
        jni_piece_tab.put("D", "Double");
    }

    public static String get_jni_piece(String sig){
        Object ob = jni_piece_tab.get(sig);
        if (ob==null) return "Object";
        return (String) ob;
    }
    
    
    /* read a file as a vector of lines */
    public static java.util.Vector readLineVector(String filename) {
        java.util.Vector v = new java.util.Vector();
        try {
        /*$ 1.1 */  java.io.FileReader freader = new java.io.FileReader(filename);
        /*$ 1.1 */  java.io.BufferedReader br  
        /*$ 1.1 */      = new java.io.BufferedReader(freader);
        /*$ 1.0 *///java.io.FileInputStream in 
        /*$ 1.0 *///    = new java.io.FileInputStream(filename);
        /*$ 1.0 *///java.io.DataInputStream br 
        /*$ 1.0 *///   = new java.io.DataInputStream(in);
        String line;
        while ((line = br.readLine()) != null) {
            v.addElement(line);
        }
        br.close();
    } catch (Exception e) {
        System.err.println("Exception: " + e);
        e.printStackTrace(System.err);
        System.exit(1);
    }
        return v;
    } //readLineVector
    
    
    /** write a vector of lines as a file */
    public static void writeLineVector(String s, java.util.Vector v) {
        try {
            int sz = v.size();
            java.io.FileOutputStream out = new java.io.FileOutputStream(s);
            java.io.DataOutputStream ds = new java.io.DataOutputStream(out);
            for (int i = 0; i < sz; i++) {
                String line = (String) v.elementAt(i);
                ds.writeBytes(line);
                ds.writeBytes("\n");
            }
            ds.flush();
            ds.close();
        } catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }  //writeLineVector
    

    /** Copy a vector */
    public static java.util.Vector shallowCopyVector(java.util.Vector v) {
        java.util.Vector c = (java.util.Vector) v.clone();
        return c;
    } //shallowCopyVector
     
     
    /** Create new vector with "v2" inserted in "v1" at "pos" */
    public static java.util.Vector insertVector(
        java.util.Vector v1, int pos,
        java.util.Vector v2) {
        int i;
        int s1 = v1.size();
        int s2 = v2.size();
        java.util.Vector v = new java.util.Vector(s1 + s2);
        if (pos>s1) pos = s1; 
        for (i = 0; i < pos; i++) {
            v.addElement(v1.elementAt(i));
            }
        for (i = 0; i < s2; i++) {
            v.addElement(v2.elementAt(i));
        }
        for (i = pos; i < s2; i++) {
            v.addElement(v1.elementAt(i));
        }
        return v;
    } //insertVector

    /** Create appends vector v2 to v */
    public static void appendVector(
        java.util.Vector v,
        java.util.Vector v2) {
        int s2 = v2.size();
        for (int i = 0; i < s2; i++) {
            v.addElement(v2.elementAt(i));
        }
    } //appendVector
    

    /** Create new vector with v2 inserted in v1; SLOW  */
    public static void insertVector0(
        java.util.Vector v1, int pos,
        java.util.Vector v2) {
        int i;
        int s1 = v1.size();
        int s2 = v2.size();
        if (pos>s1) pos = s1; 
        for (i = 0; i < s2; i++) {
            v1.insertElementAt(v2.elementAt(i), pos);
            pos = pos + 1;
        }
    } //insertVector0
    

    public static void main(String argv[]) {
        int mode = 0;
        Args args = new Args(argv);
        String nameBase = "ilunative";
        try {
            String s = args.next1();
            while (s.startsWith("-")) {
                if (s.equals("-shorten")) { 
                    shortMyPackagePrefix = args.next1();
                } else if (s.equals("-debug")) { 
                    debug = true;
                } else if (s.equals("-name")) { 
                    nameBase = args.next1();
                } else if (s.equals("-rni")) { mode = modeRNI;
                } else if (s.equals("-oni")) { mode = modeONI;
                } else if (s.equals("-jni")) { mode = modeJNI;
                } else {
                    usage("Unknown options");
                }
                s = args.next1();
            }
            if (mode == 0) {
                usage("No mode option set");
            }
            while (s != null) {
                handleOneFile(s, nameBase, mode);
                s = args.next0();
                if (s != null) usage("More then one file! - ignored those beyond the first");
            }
        } catch (ArgsException ae) {
            usage("Bad arguments");
        } 
    } //main
    
    public static void appendLine(java.util.Vector v, String line) {
        if (line!=null) v.addElement(line);
    }
    
    public static void handleOneFile(String filename, String nameBase, int mode) {
        gnhState state = new gnhState();
        state.mode = mode;

		// read all the lines of the file into an internal vector of lines
        state.inV = readLineVector(filename);
        
		// write our standard file beginnings
        appendLine(state.hdrV, "/* " + nameBase + ".h */");
        appendLine(state.hdrV, "/* This file is machine generated */");
        appendLine(state.hdrV, "#ifndef _ILUJAVA_" + nameBase + "_H_" );
        appendLine(state.hdrV, "#define _ILUJAVA_" + nameBase + "_H_\n" );
        appendLine(state.hdrV, "extern void initNativeHeaders(); \n");

        appendLine(state.implV, "/*  " + nameBase + ".c  */");
        appendLine(state.implV, "/* This file is machine generated */\n");
        appendLine(state.implV, "#include " + quoted( "IluJava_Includes.h" ));
        appendLine(state.implV, "#include " + quoted( nameBase + ".h" ));

        // generate the actual code for the lines
        handleVector(state);

		// write our standard file endings
        appendLine(state.hdrV, "\n#endif");

		// write out our internal vectors of the headers and code into files
        writeLineVector(nameBase + ".h",  state.hdrV);
        writeLineVector(nameBase + ".c",  state.implV);

    } //handleOneFile
    

	// generate the actual code for the descriptive input lines
    public static void handleVector(gnhState state) {

        if (debug) System.out.println("generating section comments");

		// initialize the various sections with a comment indicating their purpose 
        appendLine(state.clsInitsV, "\n    /* class initializations... */");
        appendLine(state.fldInitsV, "\n    /* field definitions ... */");
        appendLine(state.globalInitsV, "\n    /* global declarations ... */");
		
		// process all the lines of the input file
        int inputLines = state.inV.size();
        for (int i = 0; i < inputLines; i++) {
            String line = (String) state.inV.elementAt(i);
            handleLine(state, line, i);
        }

		// write out the global declarations section
        appendVector(state.implV, state.globalInitsV);
        appendLine(state.implV, "");

		// write out the initialization function
        appendLine(state.implV, "\nvoid initNativeHeaders() {\n");
		if (state.mode == modeRNI) {  // Microsoft Raw Native Interface
			appendLine(state.implV, "ClassClass* p_class;");
		}
        appendVector(state.implV, state.clsInitsV); // put out any class initializations produced by handleLine...
        appendVector(state.implV, state.fldInitsV); // put out any field initializations produced by handleLine...
        appendLine(state.implV, "}");

    } //handleVector
    

    // process a line from the input file
    public static void handleLine(gnhState state, String line, int lineno) {
        if (debug) {
            System.out.println("line: " + line);
        }
        java.util.StringTokenizer st = new java.util.StringTokenizer(line);
        try {
            if (st.hasMoreTokens()) {
                String key = st.nextToken();
				// call the appropriate processing function based on the first token of the line
                if (key.startsWith("/")) {
                    //comment line
                } else if (key.equalsIgnoreCase("field")) {
                   doField(state, st);
                } else if (key.equalsIgnoreCase("class")) {
                   doClass(state, st);
                } else if (key.equalsIgnoreCase("method")) {
                   doMethod(state, st);
                } else {
                    System.err.println("line: " + lineno + " unrecognized");
                    System.exit(1);
                }
            }
        } catch (java.util.NoSuchElementException e) {
            System.err.println("line: " + lineno + " too short");
            System.exit(1);
        }
    } //handleLine


    public static void doField(gnhState state, java.util.StringTokenizer st) {
        String getFieldLine, putFieldLine;
        String hdrLn = null;
        String defDeclLn = null;
        String initLn = null;
        String fieldName = st.nextToken();
        String fieldSig = st.nextToken();
		String castSig = st.nextToken();
        String fieldFullName = state.className + "_" + fieldName;
        String getMacroStart = 
        "#define GET_" + fieldFullName + "(jh_ob) ";
        String putMacroStart = 
        "#define PUT_" + fieldFullName + "(jh_ob, value) ";

        if (state.mode == modeONI) {
            getFieldLine = "(unhand( jh_ob )->" + fieldName + ")";
            putFieldLine = "(unhand( jh_ob )->" + fieldName + ") = "; 
            if (fieldSig.startsWith("0")) {
                String fieldType = fieldSig.substring(1);
                getFieldLine = "* (" + fieldType + "*) &" + getFieldLine;
                putFieldLine = "* (int**) &" + putFieldLine + "(int*)";
            }
            appendLine(state.hdrV, getMacroStart + "\\");
            appendLine(state.hdrV, "    " + getFieldLine);
            appendLine(state.hdrV, putMacroStart + "\\");
            appendLine(state.hdrV, "    " + putFieldLine + "value;");
        }

        if (state.mode == modeRNI) {  // Microsoft Raw Native Interface

			// build up the lines that declare, define, and init our cached fieldblock pointers
			String declarefieldline = "extern struct fieldblock** gwpfield_xerox_ilu_" + state.className + "_" + fieldName + ";";

			String definefieldline = "struct fieldblock** gwpfield_xerox_ilu_" + state.className + "_" + fieldName + ";";

			String getclassline = "p_class = FindClass(NULL, \"xerox/ilu/" + state.className + "\", TRUE);";
			String checkclassline = "if (!p_class) \n\t\t ilu_DebugPrintf(\"$ Class xerox/ilu/" + state.className + " NOT FOUND!\\n\");\n\telse {";

			String initfieldline = "\tgwpfield_xerox_ilu_" + state.className + "_" + fieldName + " = (struct fieldblock**)";
			initfieldline = initfieldline + "GCGetPtr((HObject*)Class_GetField( p_class, \"" + fieldName + "\" ));" ;
			String checkfieldline = "\tif (! gwpfield_xerox_ilu_" + state.className + "_" + fieldName +  ") ilu_DebugPrintf(\"$ Class xerox/ilu/" + state.className + ": Field " + fieldName +" NOT Obtained!\\n\");";

			String finishcheckclassline = "}";

			// build up the lines that define the accessor macros
 			getFieldLine = "(" + castSig + ") Field_GetValue((HObject*) jh_ob, *gwpfield_xerox_ilu_" + 
					state.className + "_" + fieldName + ")";

 			putFieldLine = "Field_SetValue((HObject*) jh_ob, *gwpfield_xerox_ilu_" + 
					state.className + "_" + fieldName + ", (__int32)value )";
		
			// write fieldblock pointer declaration
            appendLine(state.hdrV, declarefieldline);
			
			// write out the accessor macros
            appendLine(state.hdrV, getMacroStart + "\\");		
            appendLine(state.hdrV, "\t" + getFieldLine);
            appendLine(state.hdrV, putMacroStart + "\\");
            appendLine(state.hdrV, "\t" + putFieldLine);
            appendLine(state.hdrV, "");

			// add the fieldblock pointer definition to the global init section
            appendLine(state.globalInitsV, "    " + definefieldline);

			// add the fieldblock pointer initialization to the init function
            appendLine(state.fldInitsV, "\t" + getclassline);
            appendLine(state.fldInitsV, "\t" + checkclassline);
            appendLine(state.fldInitsV, "\t" + initfieldline);
            appendLine(state.fldInitsV, "\t" + checkfieldline);
            appendLine(state.fldInitsV, "\t" + finishcheckclassline);

        } // end RNI

        if (state.mode == modeJNI) {
            String getcast = "";
            String putcast = "";
            if (fieldSig.startsWith("0")) {
                fieldSig = "J";
                putcast = "(jlong) ";
                getcast = "(jobject) ";
            }
            String jniTypeOfField = get_jni_piece(fieldSig);
            String fieldIDName = "FIELDID_" + fieldFullName;
            hdrLn = "extern jfieldID " 
                + fieldIDName 
                + ";";
            appendLine(state.hdrV, hdrLn); 
            defDeclLn = "jfieldID " 
                + fieldIDName 
                + ";";
            appendLine(state.implV, defDeclLn); 
            initLn = fieldIDName 
                + " = GetFieldID(JNI_ENV, " 
                + state.classIDName 
                + ", " 
                + quoted(fieldName) 
                + ", " 
                + quoted(fieldSig) 
                + ");";  
            appendLine(state.fldInitsV, "    " + initLn);
            getFieldLine = getcast
               + "Get" + jniTypeOfField
               + "Field(JNI_ENV, jh_ob, " + fieldIDName
               + ")";
            appendLine(state.hdrV, getMacroStart + "\\");
            appendLine(state.hdrV, "    " + getFieldLine);
            putFieldLine = 
                 "Put" + jniTypeOfField
               + "Field(JNI_ENV, jh_ob, " + fieldIDName
               + ", " + putcast + "value )"; 
            appendLine(state.hdrV, putMacroStart + "\\");
            appendLine(state.hdrV, "    " + putFieldLine);
        }
    } //doField
    
    
    /* dynamic methods; no 64 bit arguments or returns ... */
    public static void doMethod(gnhState state, java.util.StringTokenizer st) {
        String name = st.nextToken();
        String signature = st.nextToken();
        AnalizeCallSignature as = new AnalizeCallSignature(signature);
        String methFullName = state.className + "_" + name;
                String callMacroPiece = "";
        for (int i = 0;  i < as.argCnt; i++) {
            callMacroPiece = callMacroPiece + ", arg" + i;
        }
        String callMacroStart =
              "#define JCALL_" + methFullName + "(jh_ob"
            + callMacroPiece + ") \\";
        if (state.mode == modeJNI) {
            //not yet defined
        } else if (state.mode == modeONI || state.mode == modeRNI) {
            String callMacroRest;
            appendLine(state.hdrV, callMacroStart);
            callMacroRest = "    execute_java_dynamic_method(EE(), \\";
            appendLine(state.hdrV, callMacroRest);
            callMacroRest = "    (Hjava_lang_Object *) jh_ob, \\";
            appendLine(state.hdrV, callMacroRest);
            callMacroRest = "    " + quoted(name) + ",\\";
            appendLine(state.hdrV, callMacroRest);
            callMacroRest = "    " + quoted(signature) + callMacroPiece + ")";
            appendLine(state.hdrV, callMacroRest);
        }
    } //doMethod
    
    
    public static void doClass(gnhState state, java.util.StringTokenizer st) {
        String classKey = st.nextToken();
        state.className = classKey.replace('.', '_');
        state.className = state.className.replace('/', '_');
        if (state.className.startsWith(shortMyPackagePrefix)) {
            int skip = shortMyPackagePrefix.length();
            state.className = state.className.substring(skip);
        }
        state.classIDName = "CLASSID_" + state.className;
        if (state.mode == modeJNI) {
            String hdrDeclLn = null;
            String defDeclLn = null;
            String initLn = null;
            hdrDeclLn = "extern jclass " + state.classIDName + ";";
            appendLine(state.hdrV, hdrDeclLn);
            defDeclLn = "jclass " + state.classIDName + ";";
            appendLine(state.implV, defDeclLn);
            initLn = state.classIDName + " = FindClass(JNI_ENV, "  
                + quoted(state.className.replace('_', '/'))
                + ");";
            appendLine(state.clsInitsV, "   " + initLn);
        } else if (state.mode == modeONI) {
            //nothing
        } else if (state.mode == modeRNI) {
            //nothing
        }
    } //doClass
    
} //gnh
    

class gnhState {
    //
    //input
    int mode = 0; // relects native interface use e.g. ONI, RNI, ...
    java.util.Vector inV = null;   // vector that holds the lines of the input file
    //
    //output
    java.util.Vector hdrV = null; 	//the .h include file
    java.util.Vector implV = null;	//the .c include file
    //
    //internals
    String className;	//name of current class
    String classIDName;	//??of current class
    java.util.Vector globalInitsV = null; // global declarations, etc.
    java.util.Vector clsInitsV = null; //initializations done first
    java.util.Vector fldInitsV = null; //initializations done second
    
    public gnhState() {
        classIDName = "ERROR NO CLASS DEFINED";
        className = "ERROR NO CLASS DEFINED";
        hdrV = new java.util.Vector();
        implV = new java.util.Vector();
        globalInitsV = new java.util.Vector();
        clsInitsV = new java.util.Vector();
        fldInitsV = new java.util.Vector();
    } //constructor
} //gnhState


/** 
 * Argument handling utility.
 * Single threaded use expected. 
 */
class Args {
    int idx = 0;
    String[] argv;
    /** 
     * Construct an Args object from argv data and position
     * it at the beginning.
     */
    public Args(String[] argv) {
        this.argv = argv;
    } //constructor
    /** returns the next argument or raise an exception if none available */
    public String next1() throws ArgsException {
        if (idx >= argv.length) {
            throw new ArgsException();
        }
        String s = argv[idx];
        idx++;
        return s;
    } //next1
    /** returns the next argument or null if none available */
    public String next0() {
        if (idx >= argv.length) {
            return null;
        }
        String s = argv[idx];
        idx++;
        return s;
    } //next0
    /** returns whether more arguments are available */
    public boolean more() {
       return (idx < argv.length);
    }//more
} //Args
    

class ArgsException extends java.lang.Exception {
    public ArgsException() {
	super();
    }
    public ArgsException(java.lang.String s) {
	super(s);
    }
} //ArgsException


class StringReader {
    String s = null;
    int nextPos = 0;
    public StringReader(String s) {
        this.s = s;
        this.nextPos = 0;
    }
    public char get() {
        char ch = ' ';
        if (this.nextPos<this.s.length()) {
            ch = this.s.charAt(this.nextPos);
            this.nextPos = this.nextPos+1;
        } else {
            throw new java.util.NoSuchElementException("bad signature");
        }
        return ch;
    }
}// StringReader

class AnalizeCallSignature extends StringReader {
    int argCnt = 0;
    String retType = null;
    public AnalizeCallSignature(String s) {
        super(s);
        char ch = super.get();
        if (ch != '(') {
            throw new java.util.NoSuchElementException("bad signature"); 
        }
        ch = super.get();
        while (ch != ')') {
            argCnt = argCnt+1;
            while (ch == '[') {ch = super.get();}
            if (ch == 'L') {
                while (ch != ';') {ch = super.get();}
            }
            ch = super.get();
        }
        retType = super.s.substring(super.nextPos);
    } //AnalizeCallSignature
    
}// AnalizeCallsignature
