/*
Copyright (c) 1996-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cppgencommon.cpp,v 1.26 1997/09/19 01:57:55 srjohnso Exp $
*/

#include <string.h>  // TEMP: for ReusableString

#include "cppgen.hpp"
#include "cppparse.hpp"
#include "cppparsestream.hpp"
#include "cppportability.hpp"


// TEMP should move this to some common place
class ReusableString {
public:
    ReusableString (int initialMaxLen = 100) {
        initialMaxLen = (initialMaxLen < 0) ? 0 : initialMaxLen;
        maxLen = 0;
        resize(initialMaxLen);
    }
    ~ReusableString () {
        if (str != NULL)
            delete [] str;
    }
    void reset () {
        str[0] = '\0';
    }
    char * resize (int newMaxLen) {
        char * old = str;
        str = new char[(maxLen = newMaxLen) + 1];
        return old;
    }
    void strcpy (const char * from, int extraBytes = 100) {
        str[0] = '\0';
        strcat(from, extraBytes);
    }
    void strcat (const char * from, int extraBytes = 100) {
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        if (from == NULL)
            from = "";
        const int newLen = strlen(str) + strlen(from);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, from);
    }
    void ucat (unsigned long u, int extraBytes = 100) {
        #define CHARS_FOR_2E64 20  // string length needed for max 64-bit unsigned
        char num[CHARS_FOR_2E64 + 1];
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        sprintf(num, "%lu", u);
        const int newLen = strlen(str) + strlen(num);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, num);
    }

    char * str;
    int maxLen;
};


CppParseStream(ofstream) &
CppGen(Type)::
_commonDefForward (CppParseStream(ofstream) & ofs) {
    // Normally, a derived class's specialization of this method is called
    return ofs;
}

CppParseStream(ofstream) &
CppGen(Type)::
_commonDef (CppParseStream(ofstream) & ofs) {
    // Normally, a derived class's specialization of this method is called
    return ofs;
}

CppParseStream(ofstream) &
CppGen(Type)::
_commonDefIOOperators (CppParseStream(ofstream) & ofs) {
    // Normally, a derived class's specialization of this method is called
    return ofs;
}

CppParseStream(ofstream) &
CppGen(Type)::
_commonImpl (CppParseStream(ofstream) & ofs) {
    // Normally, a derived class's specialization of this method is called
    return ofs;
}

void
CppGen(Type)::
aliasCommonDefForward (const CppParseName(TypeName) * alias, CppParseStream(ofstream) & ofs) const {

    ofs << "// " << alias->name(CppGen_(period_key)) << endl;
    ofs << endl;

    // typedef for type
    ofs << "typedef " << name(alias->scope()) << " " << alias->localName() << ";" << endl;

    // typedef for type_var
    ofs << "typedef " << usageName(CppParseName(var), alias->scope())
        << " " << alias->localUsageName(CppParseName(var)) << ";" << endl;
    ofs << endl;

}

void
CppGen(Type)::
aliasCommonDef (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const {
}


/* TMP 8/9
// Template specialization
void  // TMP 8/5: NEW
optionalCommonDefForward (const CppGen(Byte)* type, const CppParseName(TypeName)* optional, CppParseStream(ofstream)& ofs) {

    // typedef for optional
    ofs << "typedef " << type->name(optional->scope()) << "* " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << type->name(optional->scope()) << "* "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptionalByteMgr "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}

// Template specialization
void  // TMP 8/5: NEW
optionalCommonDefForward (const CppGen(Boolean)* type, const CppParseName(TypeName)* optional, CppParseStream(ofstream)& ofs) {

    // typedef for optional
    ofs << "typedef " << type->name(optional->scope()) << "* " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << type->name(optional->scope()) << "* "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptionalBooleanMgr "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}

template <class T>  // TMP 8/5: NEW
TEMPLATE_STATIC
void
optionalCommonDefForward (const T* type, const CppParseName(TypeName)* optional, CppParseStream(ofstream)& ofs) {

    // typedef for optional
    ofs << "typedef " << type->name(optional->scope()) << "* " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << type->name(optional->scope()) << "* "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptional" << (type->needsSurrogateSideCleanup() ? "WithCleanup" : "") << "MgrT<"
        << type->name(optional->scope()) << "> "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}


#define DEF_SCALAR_TYPE_OPTIONAL_COMMON_DEF_FORWARD_FUNC(T, UNUSED1, UNUSED2, UNUSED3, UNUSED4)  \
    void \
    CppGen(T):: \
    optionalCommonDefForward (const CppParseName(TypeName)* optional, CppParseStream(ofstream)& ofs) const { \
        ::optionalCommonDefForward(this, optional, ofs); \
    }

CppParse_ENUMERATE_SCALAR_TYPES(DEF_SCALAR_TYPE_OPTIONAL_COMMON_DEF_FORWARD_FUNC)  // TMP 8/5: NEW


void  // TMP 8/3: NEW
CppGen(Type)::
optionalCommonDefForward (const CppParseName(TypeName) * optional, CppParseStream(ofstream) & ofs) const {
    ::optionalCommonDefForward(this, optional, ofs);
}
*/


void  // TMP 8/9: NEW
CppGen(Type)::
optionalCommonDefForward (const CppParseName(TypeName) * optional, CppParseStream(ofstream) & ofs) const {

    // typedef for optional
    ofs << "typedef " << name(optional->scope()) << "* " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << name(optional->scope()) << "* "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptional" << typeKindName(ILUCPP_TRUE) << "Mgr "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}


CppParseStream(ofstream) &
CppGen(Object)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
    
    ofs << "class " << localName() << ";" << endl;
    ofs << "typedef " << localName() << "* " 
        << localUsageName(CppParseName(ptr)) << ";" << endl;
    ofs << "typedef iluTemplatableObject_var<" << localName()
        << "> " << localUsageName(CppParseName(var)) << ";" << endl;

    ofs << endl;
    return ofs;
}

CppParseStream(ofstream) & 
CppGen(Object)::
_commonDef (CppParseStream(ofstream) & ofs) {
  CppParse(ProcedureListIter) procs(procedures());
  const CppGen_(Procedure) * proc;

  ofs << "// " << name(CppGen_(period_key)) << endl;
  ofs << endl;
  
  ofs << "//////////////////////////////////////////////////////////////////////" << endl;
  ofs << "// For Clients, instances of _surrogate subclasses of this class will function" << endl;
  ofs << "// as surrogates - that is, their IDL specified member functions will forward" << endl;
  ofs << "// calls to the true object. Servers will subclass from this class, and supply" << endl;
  ofs << "// the IDL specified member functions to provide the true object's implementations" << endl;
  ofs << endl;

  // Begin generation of the class for this object

  ofs << "class " << localName() << ": ";

  // List superclasses

  if (superclasses().count() == 0)
      ofs << "public virtual iluObject";
  else {
      ILUCPP_BOOL firstSuperclass = ILUCPP_TRUE;
/* TMP 9/7
      const CppParse(Object) * object;
      CppParse(ObjectListIter) objectListIter(superclasses());
      while ((object = objectListIter.next()) != NULL) {
          if (firstSuperclass)
              firstSuperclass = ILUCPP_FALSE;
          else
              ofs << ", ";
          ofs << "public virtual " << object->name(scope());
      };
TMP 9/7 */
      const CppParse(Type) * super;  // TMP 9/7: NEW
      CppParse(TypeListIter) superListIter(superclasses());  // TMP 9/7: NEW
      while ((super = superListIter.next()) != NULL) {  // TMP 9/7: NEW
          if (firstSuperclass)
              firstSuperclass = ILUCPP_FALSE;
          else
              ofs << ", ";
          ofs << "public virtual " << super->name(scope());
      };
  };
  ofs << " {" << endl;

  ofs.indent++;

  // Needed for every class (object reference methods, _narrow(), etc)

  ofs << endl;
  ofs << "public:" << endl;
  ofs.indent++;

  // construct from instance handle
  ofs << endl;
  ofs << localName() << " (" << endl;
  ofs.indent++;
  ofs << "char* _instance_handle," << endl;
  ofs << "iluServer& _ilu_server = iluServer::iluGetDefaultServer()," << endl;
  ofs << CppParseName(CorbaBoolean)()->name() << " _within_object_table = "
      << CppGen_(Bool)::value(ILUCPP_FALSE) << endl;
  ofs.indent--;
  ofs << ")" << endl;
  ofs.indent++;
  ofs << ": iluObject(" << endl;
  ofs.indent++;
  ofs << localName() << "::m_ILUClassRecord," << endl;
  ofs << "_instance_handle," << endl;
  ofs << "_ilu_server," << endl;
  ofs << "_within_object_table" << endl;
  ofs.indent--;
  ofs << "  )" << endl;
  ofs.indent--;
  ofs << "{}" << endl;
  ofs << endl;

  ofs << "// CORBA object reference operations" << endl;

  // _duplicate
  ofs << endl;
  ofs << "static" << endl;
  ofs << localUsageName(CppParseName(ptr)) << endl;
  ofs << " _duplicate (" << localUsageName(CppParseName(ptr)) << ");" << endl;
  ofs << endl;

  // _narrow CORBA::Object_ptr
  ofs << "static" << endl;
  ofs << localUsageName(CppParseName(ptr)) << endl;
  ofs << "_narrow(" << CppParseName(CorbaObject_ptr)()->name() << " obj) {" << endl;
  ofs.indent++;
  ofs << "return "
      << CppGen_(Cast)::reinterpretCast(localUsageName(CppParseName(ptr)), "obj->iluDowncast(m_ILUClassRecord)")
      << ";" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  ofs << endl;

  // _narrow iluObject*
  ofs << "static" << endl;
  ofs << localUsageName(CppParseName(ptr)) << endl;
  ofs << "_narrow(iluObject* obj) {" << endl;
  ofs.indent++;
  ofs << "return "
      << CppGen_(Cast)::reinterpretCast(localUsageName(CppParseName(ptr)), "obj->iluDowncast(m_ILUClassRecord)")
      << ";" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  ofs << endl;

  // _nil
  ofs << "static" << endl;
  ofs << localUsageName(CppParseName(ptr)) << endl;
  ofs << "_nil();" << endl;

  // _this
  ofs << endl;
  ofs << this->CppParse(Type)::localUsageName(CppParseName(ptr)) << endl;
  ofs << "_this() {" << endl;
  ofs.indent++;
  ofs << "return _duplicate((" << localUsageName(CppParseName(ptr)) << ") this);" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  ofs << endl;

  // The "while" loop causes the prototypes for the OBJECT's methods to be output

  ofs << "// IDL/ISL specified methods" << endl;
  ofs << endl;
  while ((proc = CppGen_(Procedure)::narrow(procs.next())) != NULL) {
    ofs << proc->commonDef();
    ofs << endl;
    ofs << endl;
  };

  ofs << endl;



  // More standard methds (initialization, object lookup, etc)

  // iluInitialize
  ofs << "// initialize to use " << name(CppGen_(period_key)) << " class of objects" << endl;
  ofs << "static" << endl;
  ofs << "void" << endl;
  ofs << "iluInitialize();" << endl;
  ofs << endl;

  // iluLookup
  ofs << "// Simple Object Lookup" << endl;
  ofs << "static" << endl;
  ofs << localUsageName(CppParseName(ptr)) << endl;
  ofs << "iluLookup (char * server_id, char * instance_handle);" << endl;
  ofs << endl;

  // iluGetILUClassRecord
  ofs << "// For ILU C++ runtime - stub use only - returns the m_ILUClassRecord member variable" << endl;
  ofs << "static" << endl;
  ofs << "ilu_Class" << endl;
  ofs << "iluGetILUClassRecord () {" << endl;
  ofs.indent++;
  ofs << "return m_ILUClassRecord;" << endl;
  ofs.indent--;
  ofs << "}" << endl;

  // iluDowncast
  ofs << "// for use in narrowing" << endl;
  ofs << "virtual" << endl;
  ofs << "void *" << endl;
  ofs << "iluDowncast (iluClass class_to_cast_down_to);" << endl;

  ofs << endl;
  ofs.indent--;


  // Generate the kernel class member variable, along with the constructors, destructor,
  // copy constructor and assignment operator prototypes.

  ofs << "protected:" << endl;
  ofs.indent++;
  ofs << endl;

  ofs << "// Holds the kernel class for this kind of object" << endl;
  ofs << "static ilu_Class m_ILUClassRecord;" << endl;
  ofs << endl;
  ofs << localName() << "();\t// default constructor" << endl;
  ofs << "virtual ~" << localName() << "();\t // destructor" << endl;
  ofs << endl;
  ofs.indent--;

  ofs << "private:" << endl;
  ofs.indent++;
  ofs << localName() << "(const " << localName() << "&);\t// copy constructor" << endl;
  ofs << "void operator=(const " << localName() << "&);\t// assignment operator" << endl;
  ofs << endl;
  ofs.indent--;

  ofs.indent--;
  ofs << "};" << endl;
  ofs << endl;
  return ofs;
}

CppParseStream(ofstream) & 
CppGen(Object)::
_commonDefIOOperators (CppParseStream(ofstream) & ofs) {
    ofs << "iluBaseCall& operator+= (iluBaseCall&, "
        << "const " << usageName(CppParseName(var)) << "&);" << endl;
    ofs << "iluBaseCall& operator<< (iluBaseCall&, "
        << "const " << usageName(CppParseName(var)) << "&);" << endl;
    ofs << "iluBaseCall& operator>> (iluBaseCall&, "
        << usageName(CppParseName(var)) << "&);" << endl;
    return ofs;
}

void
CppGen(Object)::
aliasCommonDefForward (const CppParseName(TypeName) * alias, CppParseStream(ofstream) & ofs) const {

    ofs << "// " << alias->name(CppGen_(period_key)) << endl;
    ofs << endl;

    // typedef for class
    ofs << "typedef " << name(alias->scope()) << " " << alias->localName() << ";" << endl;

    // typedef for _ptr
    ofs << "typedef " << usageName(CppParseName(ptr), alias->scope()) << " "
        << alias->localUsageName(CppParseName(ptr)) << ";" << endl;

    // typedef for _var
    ofs << "typedef " << usageName(CppParseName(var), alias->scope()) << " "
        << alias->localUsageName(CppParseName(var)) << ";" << endl;

    ofs << endl;
}

void  // TMP 8/3: NEW
CppGen(Object)::
optionalCommonDefForward (const CppParseName(TypeName) * optional, CppParseStream(ofstream) & ofs) const {

    // typedef for optional
    ofs << "typedef " << usageName(CppParseName(ptr), optional->scope()) << " " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << name(optional->scope()) << "* " <<
        optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptionalObjectMgrT<" << name(optional->scope()) << "> "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}


void  // TMP 8/3: NEW
CppGen(String)::
optionalCommonDefForward (const CppParseName(TypeName) * optional, CppParseStream(ofstream) & ofs) const {

    // typedef for optional
    ofs << "typedef " << name(optional->scope()) << " " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef " << usageName(CppParseName(constRef), optional->scope()) << " "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptionalCStringMgr " << optional->localUsageName(CppParseName(var)) << ";" << endl;

}


void  // TMP 8/3: NEW
CppGen(WideString)::
optionalCommonDefForward (const CppParseName(TypeName) * optional, CppParseStream(ofstream) & ofs) const {

    // typedef for optional
    ofs << "typedef " << name(optional->scope()) << " " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef " << usageName(CppParseName(constRef), optional->scope()) << " "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptionalWStringMgr " << optional->localUsageName(CppParseName(var)) << ";" << endl;

}


CppParseStream(ofstream) &
CppGen(Record)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
    
    ofs << "struct " << localName() << ";" << endl;
    ofs << "typedef iluTemplatableT_var<" << localName()
        << "> " << localUsageName(CppParseName(var)) << ";" << endl;

    ofs << endl;
    return ofs;
}

CppParseStream(ofstream) & 
CppGen(Record)::
_commonDef (CppParseStream(ofstream) & ofs) {
    const CppParseName(Scope) * definedIn = scope();
    CppParse(MemberListIter) memberListIter(members());
    const CppGen_(Member) * member;

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
    
    // begin struct
    ofs << "struct " << localName() << " {" << endl;
    ofs.indent++;

    // constructors & destructor
	ofs << localName() << " ();" << endl;
	ofs << "/* TMP" << endl;
    ofs << localName() << " (" << localUsageName(CppParseName(in)) << ");" << endl;
	ofs << "TMP */" << endl;
    ofs << "~" << localName() << " ();" << endl;
	ofs << "/* TMP" << endl;
    ofs << localName() << "& operator= (" << localUsageName(CppParseName(in)) << ");" << endl;
	ofs << "TMP */" << endl;

    // surrogate side cleanup function
    if (needsSurrogateSideCleanup()) {
        ofs << endl;
        ofs << "// For ILU stub use only" << endl;
        ofs << "void _surrogateSideCleanup () const;" << endl;
    };

    // ISL-defined members
    ofs << endl;
    ofs << "// ISL-defined members" << endl;
    while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
        ofs << member->type()->usageName(CppParseName(recordMember), definedIn)
            << " " << member->localName() << ";" << endl;

    // end struct
    ofs.indent--;
    ofs << "};" << endl;
    ofs << endl;
    return ofs;
}

CppParseStream(ofstream) & 
CppGen(Record)::
_commonDefIOOperators (CppParseStream(ofstream) & ofs) {
    ofs << "iluBaseCall& operator+= (iluBaseCall&, "
        << "const " << name() << "&);" << endl;
    ofs << "iluBaseCall& operator<< (iluBaseCall&, "
        << "const " << name() << "&);" << endl;
    ofs << "iluBaseCall& operator>> (iluBaseCall&, "
        << name() << "&);" << endl;
    return ofs;
};

CppParseStream(ofstream) & 
CppGen(Record)::
_commonImpl (CppParseStream(ofstream) & ofs) {

    CppParse(MemberListIter) memberListIter(members());
    const CppGen_(Member) * member;

    // Default constructor
    ofs << name() << "::" << endl;
    ofs << localName() << " () {" << endl;
    ofs << "}" << endl;
    ofs << endl;

    // Copy constructor
	ofs << "/* TMP" << endl;
    ofs << name() << "::" << endl;
    ofs << localName() << " (const " << localName() << "& _rec) {" << endl;
    ofs.indent++;
    while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
        CppGen_(Type)::narrow(member->type())->assignValue(member->localName(), member->name(CppGen_(member_key)), ofs);
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;
	ofs << "TMP */" << endl;

    // Destructor
    ofs << name() << "::" << endl;
    ofs << "~" << localName() << " () {" << endl;
    ofs << "}" << endl;
    ofs << endl;

    // Assignment operator
	ofs << "/* TMP" << endl;
    memberListIter.reset();
    ofs << name() << "&" << endl;
    ofs << name() << "::" << endl;
    ofs << "operator= (const " << localName() << "& _rec) {" << endl;
    ofs.indent++;
    if (members().count() > 0) {
        ofs << "if (this != &_rec) {" << endl;
        ofs.indent++;
        while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
            CppGen_(Type)::narrow(member->type())->assignValue(member->localName(), member->name(CppGen_(member_key)), ofs);
        ofs.indent--;
        ofs << "};" << endl;
    };
    ofs << "return *this;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;
	ofs << "TMP */" << endl;

    // surrogate-side cleanup
    if (needsSurrogateSideCleanup()) {
        memberListIter.reset();
        ofs << "void" << endl;
        ofs << name() << "::" << endl;
        ofs << "_surrogateSideCleanup () const {" << endl;
        ofs.indent++;
        while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
            CppGen_(Type)::narrow(member->type())->surrogateCleanup(member, ofs);
        ofs.indent--;
        ofs << "}" << endl;
        ofs << endl;
    };

    // Sizing operator
    memberListIter.reset();
    ofs << "iluBaseCall&" << endl;
    ofs << "operator+= (iluBaseCall& _call, const " << name() << "& _rec) {" << endl;
    ofs.indent++;
    while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
        ofs << member->initialDeclsOutput();
    ofs << "_call << iluSizeRecord;" << endl;
    memberListIter.reset();
    while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
        ofs << member->sizing();
    ofs << "_call << iluEndRecord;" << endl;
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // Extraction (output) operator
    memberListIter.reset();
    ofs << "iluBaseCall&" << endl;
    ofs << "operator<< (iluBaseCall& _call, const " << name() << "& _rec) {" << endl;
    ofs.indent++;
    while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
        ofs << member->initialDeclsOutput();
    ofs << "_call << iluOutputRecord;" << endl;
    memberListIter.reset();
    while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
        ofs << member->send();
    ofs << "_call << iluEndRecord;" << endl;
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // Insertion (input) operator
    memberListIter.reset();
    ofs << "iluBaseCall&" << endl;
    ofs << "operator>> (iluBaseCall& _call, " << name() << "& _rec) {" << endl;
    ofs.indent++;
    while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
        ofs << member->initialDeclsInput();
    ofs << "_call << iluInputRecord;" << endl;
    memberListIter.reset();
    while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL)
        ofs << member->receive();
    ofs << "_call << iluEndRecord;" << endl;
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    return ofs;
}

void
CppGen(Record)::  // TMP 8/5: NEW
optionalCommonDefForward (const CppParseName(TypeName)* optional, CppParseStream(ofstream)& ofs) const {

    // typedef for optional
    ofs << "typedef " << name(optional->scope()) << "* " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << name(optional->scope()) << "* "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "MgrT<"
        << name(optional->scope()) << "> "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}


CppParseStream(ofstream) &
CppGen(Union)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
    
    ofs << "class " << localName() << ";" << endl;
    ofs << "typedef iluTemplatableT_var<" << localName()
        << "> " << localUsageName(CppParseName(var)) << ";" << endl;

    ofs << endl;
    return ofs;
}

CppParseStream(ofstream) & 
CppGen(Union)::
_commonDef (CppParseStream(ofstream) & ofs) {

    CppParse(MemberListIter) armListIter(arms());
    const CppGen_(UnionArm) * arm;

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
    
    // begin class
    ofs << "class " << localName() << " {" << endl;
    ofs.indent++;

    // friend declarations
    ofs << endl;
    ofs << "friend iluBaseCall& operator+= (iluBaseCall&, const " << localName() << "&);" << endl;
    ofs << "friend iluBaseCall& operator<< (iluBaseCall&, const " << localName() << "&);" << endl;
    ofs << "friend iluBaseCall& operator>> (iluBaseCall&, " << localName() << "&);" << endl;

    ofs << endl;
    ofs << "public:" << endl;
    ofs.indent++;

    // constructors & destructor
    ofs << endl;
    ofs << localName() << " ();" << endl;
    ofs << localName() << " (" << localUsageName(CppParseName(in)) << ");" << endl;
    ofs << "~" << localName() << " ();" << endl;

    // assignment operator
    ofs << endl;
    ofs << localName() << "&" << endl;
    ofs << "operator= (" << localUsageName(CppParseName(in)) << ");" << endl;

    // discriminator accessors
    ofs << endl;
    ofs << discriminatorType()->name(this) << endl;
    ofs << "_d () const;" << endl;
    ofs << endl;
    ofs << "void" << endl;
    ofs << "_d (" << discriminatorType()->name(this) << ");" << endl;

    // accessors corresponding to ISL-specified members
    ofs << endl;
    ofs.indent--;
    ofs << "public:  // accessors for ISL-defined members" << endl;
    ofs.indent++;
    while ((arm = CppGen_(UnionArm)::narrow(armListIter.next())) != NULL) {
        ofs << endl;
        ofs << arm->getDefs();
        ofs << endl;
        ofs << arm->setDefs();
    };

    // surrogate side cleanup function
    if (needsSurrogateSideCleanup()) {
        ofs << endl;
        ofs.indent--;
        ofs << "public:  // for ILU stub use only" << endl;
        ofs.indent++;
        ofs << endl;
        ofs << "void _surrogateSideCleanup () const;" << endl;
    };

    ofs << endl;
    ofs.indent--;
    ofs << "private:" << endl;
    ofs.indent++;

    // _unset
    ofs << endl;
    ofs << "void" << endl;
    ofs << "_unset ();" << endl;

    // data members corresponding to ISL-specified members
    if (arms().count() > 0) {
        ofs << endl;
        ofs << "union {" << endl;
        ofs.indent++;
        armListIter.reset();
/* TMP 9/4
        while ((arm = CppGen_(UnionArm)::narrow(armListIter.next())) != NULL)
            ofs << arm->type()->usageName(CppParseName(unionMember)) << " " << arm->localName() << ";" << endl;
TMP 9/4 */
        while ((arm = CppGen_(UnionArm)::narrow(armListIter.next())) != NULL) {  // TMP 9/4: NEW
			const CppGen_(Type) * armType = CppGen_(Type)::narrow(arm->type());
			if (armType->unionDataMemberIsVar())
				ofs << armType->usageName(CppParseName(var), this) << "* " << arm->localName() << ";" << endl;
			else
				ofs << armType->name(this) << " " << arm->localName() << ";" << endl;
		};
		/* TEMP: Note: cppgenname.cpp contains several overloads of "simpleName (CppParseName::TypeUsage)"
		   which respond to an argument of CppParseName(unionMember). We used to invoke that code from here;
		   since we no longer invoke it, we may be able to remove it.
		*/
        ofs.indent--;
        ofs << "};" << endl;
    };

    // _discriminator, _beenSet data members
    ofs << endl;
    ofs << discriminatorType()->name(this) << " _discriminator;" << endl;
    ofs << CppParseName(CorbaBoolean)()->name() << " _beenSet;" << endl;

    // end class
    ofs << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "};" << endl;
    ofs << endl;
    return ofs;
}

CppParseStream(ofstream) & 
CppGen(Union)::
_commonImpl (CppParseStream(ofstream) & ofs) {

    CppParse(MemberListIter) armListIter(arms());
    const CppGen_(UnionArm) * arm;

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;

    // default constructor
    ofs << endl;
    ofs << name() << "::" << endl;
    ofs << localName() << "()" << endl;
    ofs.indent++;
    ofs << ": _beenSet(" << CppGen_(Bool)::value(ILUCPP_FALSE) << ")" <<endl;
    ofs.indent--;
    ofs << "{" << endl;
    ofs << "}" << endl;

    // copy constructor
    ofs << endl;
    ofs << name() << "::" << endl;
    ofs << localName() << " (const " << localName() << "& " << name(CppGen_(instance_key)) << ")" << endl;
    ofs.indent++;
    ofs << ": _beenSet(" << CppGen_(Bool)::value(ILUCPP_FALSE) << ")" <<endl;
    ofs.indent--;
    ofs << "{" << endl;
    ofs.indent++;
    ofs << "*this = " << name(CppGen_(instance_key)) << ";" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // destructor
    ofs << endl;
    ofs << name() << "::" << endl;
    ofs << "~" << localName() << "() {" << endl;
    ofs.indent++;
    ofs << "_unset();" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // begin assignment operator
    ofs << endl;
    ofs << name() << "&" << endl;
    ofs << name() << "::" << endl;
    ofs << "operator= (const " << localName() << "&" << name(CppGen_(instance_key)) << ") {" << endl;
    ofs.indent++;


    ofs << "if (this == &" << name(CppGen_(instance_key)) << ")" << endl;
    ofs.indent++;
    ofs << "return *this;" << endl;
    ofs.indent--;

    ofs << "_unset();" << endl;

    ofs << "_beenSet = " << name(CppGen_(instance_key)) << "._beenSet;" << endl;

    ofs << "if (!_beenSet)" << endl;
    ofs.indent++;
    ofs << "return *this;" << endl;
    ofs.indent--;

    ofs << "_discriminator = " << name(CppGen_(instance_key)) << "._discriminator;" << endl;

    // assign current member according to discriminator
    discriminatorSwitch(assignmentCase, "_discriminator", ofs);

    // end assignment operator
    ofs << "return *this;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // discriminator get accessor
    ofs << endl;
    ofs << discriminatorType()->usageName(CppParseName(returnVal)) << endl;
    ofs << name() << "::" << endl;
    ofs << "_d () const {" << endl;
    ofs.indent++;
    ofs << "return _discriminator;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // begin discriminator set accessor
    ofs << endl;
    ofs << "void" << endl;
    ofs << name() << "::" << endl;
    ofs << "_d (" << discriminatorType()->usageName(CppParseName(in)) << " _new_d) {" << endl;
    ofs.indent++;

    // if already set, check for new value and old value in same arm, and set
    ofs << "if (_beenSet) {" << endl;
    ofs.indent++;
    discriminatorSwitch(discriminatorSetAccessorCase, "_discriminator", ofs);
    ofs << "if (_discriminator != _new_d)" << endl;
    ofs.indent++;
    ofs << "ILUCPP_WARN(\"Ignoring attempt to set " << name(CppGen_(period_key))
        << " discriminator outside current membership\");" << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "}" << endl;

    // else, simply set discriminator
    ofs << "else" << endl;
    ofs.indent++;
    ofs << "_discriminator = _new_d;" << endl;
    ofs.indent--;

    // end discriminator set accessor
    ofs.indent--;
    ofs << "}" << endl;

    // accessors corresponding to ISL-specified members
    while ((arm = CppGen_(UnionArm)::narrow(armListIter.next())) != NULL) {
        ofs << endl;
        ofs << arm->getImpls();
        ofs << endl;
        ofs << arm->setImpls();
    };

    // surrogate side cleanup function
    if (needsSurrogateSideCleanup()) {
        ofs << endl;

        // begin function
        ofs << "void" << endl;
        ofs << name() << "::" << endl;
        ofs << "_surrogateSideCleanup () const {" << endl;
        ofs.indent++;

        // if _beenSet, cleanup current arm (if data member type requires it)
        ofs << "if (_beenSet) {" << endl;
        ofs.indent++;
        discriminatorSwitch(surrogateSideCleanupCase, "_discriminator", ofs);
        ofs.indent--;
        ofs << "};" << endl;

        // end function
        ofs.indent--;
        ofs << "}" << endl;
    };

    // begin unset function
    ofs << endl;
    ofs << "void" << endl;
    ofs << name() << "::" << endl;
    ofs << "_unset () {" << endl;
    ofs.indent++;
    
    // if _beenSet, delete current arm data member (if required)
    ofs << "if (_beenSet) {" << endl;
    ofs.indent++;
    discriminatorSwitch(unsetCase, "_discriminator", ofs);
    ofs << "_beenSet = " << CppGen_(Bool)::value(ILUCPP_FALSE) << ";" << endl;
    ofs.indent--;
    ofs << "};" << endl;
    
    // end unset function
    ofs.indent--;
    ofs << "}" << endl;

    // sizing, input, and output operations
    ofs << endl;
    outputIOOpImpl(CppGen_(size), ofs);
    ofs << endl;
    outputIOOpImpl(CppGen_(input), ofs);
    ofs << endl;
    outputIOOpImpl(CppGen_(output), ofs);

    ofs << endl;
    return ofs;
};

void
CppGen(Union)::
discriminatorSwitch (
    CppGen_(UnionDiscriminatorSwitchAction) genCase,
    const char * discriminatorName,
    CppParseStream(ofstream)& ofs) const {

    const CppGen_(UnionArm) * default_arm = CppGen_(UnionArm)::narrow(defaultArm());
    CppParse(MemberListIter) memberListIter(arms());
    const CppGen_(UnionArm) * arm;

    // begin switch statement
    ofs << "switch (" << discriminatorName << ") {" << endl;
    ofs.indent++;

    // output a switch arm for each UnionArm (except DEFAULT)
    while ((arm = CppGen_(UnionArm)::narrow(memberListIter.next())) != NULL) {
        CppParse(ConstantValueListIter) valueListIter(arm->values());
        ILUCPP_BOOL firstValue = ILUCPP_TRUE;
        const CppParse(ConstantValue) * value;
        if (arm == default_arm)
            continue;
        while ((value = valueListIter.next()) != NULL) {
            if (!firstValue)
                ofs << endl;
            ofs << "case " << value->str() << ":";
            firstValue = ILUCPP_FALSE;
        };
        ofs << " {" << endl;
        ofs.indent++;
        (this->*genCase)(arm, ofs);
        ofs << "break;" << endl;
        ofs.indent--;
        ofs << "};" << endl;
    };

    // default arm  (ISL DEFAULT, ISL OTHERS, or illegal disriminant value)
    ofs << "default: {" << endl;
    ofs.indent++;
    (this->*genCase)(default_arm, ofs);
    ofs << "break;" << endl;
    ofs.indent--;
    ofs << "};" << endl;

    // end case statement
    ofs.indent--;
    ofs << "};" << endl;

}

void
CppGen(Union)::
assignmentCase (const CppGen_(UnionArm) * arm, CppParseStream(ofstream)& ofs) const {
    if (arm != NULL) {  // TEMP: Check for invalid discriminator (!otherDiscriminatorValuesOK()) ?

        // If data member is a managed (_var) Type, allocate a copy
        if (CppGen_(Type)::narrow(arm->type())->unionDataMemberIsVar()) {
            ofs << arm->localName() << " = new "
                << arm->type()->usageName(CppParseName(var))
                << "(*" << arm->name(CppGen_(member_key)) << ");" << endl;
        }

        // Non-managed data types => simple assignment
        else {
            ofs << arm->localName()
                << " = " << arm->name(CppGen_(member_key)) << ";" << endl;
        };
    };
}

void
CppGen(Union)::
discriminatorSetAccessorCase (const CppGen_(UnionArm) * arm, CppParseStream(ofstream)& ofs) const {

    // ISL DEFAULT or ISL OTHERS
    // make sure _new_d isn't equal to any of the specified arm values
    if ((arm == NULL && otherDiscriminatorValuesOK()) || (arm != NULL && arm == defaultArm())) {
        const ILUCPP_BOOL haveNonDefaultArms = (arms().count() > ((defaultArm() == NULL) ? 0 : 1));
        ILUCPP_BOOL firstValue = ILUCPP_TRUE;
        if (haveNonDefaultArms) {
            CppParse(MemberListIter) armListIter(arms());
            ofs << "if (";
            ofs.indent++;
            const CppGen_(UnionArm) * specifiedArm;
            while ((specifiedArm = CppGen_(UnionArm)::narrow(armListIter.next())) != NULL) {
                if (specifiedArm != defaultArm()) {
                    CppParse(ConstantValueListIter) valueListIter(specifiedArm->values());
                    const CppParse(ConstantValue) * value;
                    while ((value = valueListIter.next()) != NULL) {
                        if (firstValue) {
                            ofs << "_new_d != " << value->str();
                            firstValue = ILUCPP_FALSE;
                        }
                        else {
                            ofs << " &&" << endl;
                            ofs << "_new_d != " << value->str();
                        };
                    };
                };
            };
            ofs << ")" << endl;
            ofs << "_discriminator = _new_d;" << endl;
            ofs.indent--;
        }
        else
            ofs << "_discriminator = _new_d;" << endl;
    }

    // Regular arm
    // make sure _new_d is equal to one of the values specified for this arm
    else if (arm != NULL) {
        CppParse(ConstantValueListIter) valueListIter(arm->values());
        const CppParse(ConstantValue) * value = valueListIter.next();
        ofs << "if (_new_d == " << value->str();
        ofs.indent++;
        while ((value = valueListIter.next()) != NULL) {
            ofs << " ||" << endl;
            ofs << "_new_d == " << value->str();
        };
        ofs << ")" << endl;
        ofs << "_discriminator = _new_d;" << endl;
        ofs.indent--;
    };

}

void
CppGen(Union)::
surrogateSideCleanupCase (const CppGen_(UnionArm) * arm, CppParseStream(ofstream)& ofs) const {
    if (arm != NULL)  // TEMP: Check for invalid discriminator (!otherDiscriminatorValuesOK()) ?
        CppGen_(Type)::narrow(arm->type())->surrogateCleanup(arm, ofs);
}

void
CppGen(Union)::
unsetCase (const CppGen_(UnionArm) * arm, CppParseStream(ofstream)& ofs) const {
    if (arm != NULL && CppGen_(Type)::narrow(arm->type())->unionDataMemberIsVar())  // TEMP: Check for invalid discriminator (!otherDiscriminatorValuesOK()) ?
        ofs << "delete " << arm->localName() << ";" << endl;
}

void
CppGen(Union)::
sizingCase (const CppGen_(UnionArm) * arm, CppParseStream(ofstream)& ofs) const {
/* TMP 9/5
    if (arm != NULL)  // TEMP: Check for invalid discriminator (!otherDiscriminatorValuesOK()) ?
        CppGen_(Type)::narrow(arm->type())->sizing(arm, ofs);
TMP 9/5 */
    if (arm != NULL) {  // TEMP: Check for invalid discriminator (!otherDiscriminatorValuesOK()) ?  // TMP 9/5: NEW
		ofs << arm->initialDeclsOutput();
        CppGen_(Type)::narrow(arm->type())->sizing(arm, ofs);
	};
}

void
CppGen(Union)::
sendCase (const CppGen_(UnionArm) * arm, CppParseStream(ofstream)& ofs) const {
/* TMP 9/5
    if (arm != NULL)  // TEMP: Check for invalid discriminator (!otherDiscriminatorValuesOK()) ?
        CppGen_(Type)::narrow(arm->type())->send(arm, ofs);
TMP 9/5 */
    if (arm != NULL) {  // TEMP: Check for invalid discriminator (!otherDiscriminatorValuesOK()) ?  // TMP 9/5: NEW
		ofs << arm->initialDeclsOutput();
        CppGen_(Type)::narrow(arm->type())->send(arm, ofs);
	};
}

void
CppGen(Union)::
receiveCase (const CppGen_(UnionArm) * arm, CppParseStream(ofstream)& ofs) const {
    if (arm != NULL) {  // TEMP: Check for invalid discriminator (!otherDiscriminatorValuesOK()) ?
        ofs << arm->initialDeclsInput();
        ofs << arm->receive();
    };
}

void
CppGen(Union)::
outputIOOpImpl (CppGen_(IOOp) op, CppParseStream(ofstream)& ofs) const {

    // determine operation, whether union is const or not, and discriminator to switch on
    const char * opStr;
    CppGen_(UnionDiscriminatorSwitchAction) opCase;
    const char * constStr;
    static ReusableString descName;
    switch (op) {
        case CppGen_(size):
            opStr = "+=";
            opCase = sizingCase;
            constStr = "const ";
            descName.strcpy(name(CppGen_(instance_key)));
            descName.strcat("._discriminator");
            break;
        case CppGen_(input):
            opStr = ">>";
            opCase = receiveCase;
            constStr = "";
            descName.strcpy("_union_wrapper");  // TEMP: quick & dirty wrapper name
            descName.strcat(".m_card_discriminator");
            break;
        default:  // CppGen::output
            opStr = "<<";
            opCase = sendCase;
            constStr = "const ";
            descName.strcpy(name(CppGen_(instance_key)));
            descName.strcat("._discriminator");
            break;
    };

    // begin function
    ofs << "iluBaseCall&" << endl;
    ofs << "operator " << opStr << " (iluBaseCall& _call, "
        << constStr << name() << "& " << name(CppGen_(instance_key)) << ") {" << endl;
    ofs.indent++;

    // declare union wrapper
/* TMP 9/13
    ofs << "iluUnionWrapper " << "_union_wrapper" << "(";  // TEMP: quick & dirty wrapper name
    if (op == CppGen_(input))
        ofs << "0, ";
    else
        ofs << name(CppGen_(instance_key)) << "._d(), ";
    ofs << "ilu_" << discriminatorType()->typeKindName() << "_tk);" << endl;
TMP 9/13 */
    if (op == CppGen_(input)) {  // TMP 9/13: NEW
        ofs << "iluUnionWrapper " << "_union_wrapper(0, ilu_"
			<< discriminatorType()->typeKindName() << "_tk);" << endl;
		ofs << "_union._unset();" << endl;
	}
	else { // TMP 9/13: NEW
        ofs << "iluUnionWrapper " << "_union_wrapper(_union._d(), ilu_"
		    << discriminatorType()->typeKindName() << "_tk);" << endl;
	};

	// operate on wrapper
    ofs << "_call " << opStr << " " << "_union_wrapper" << ";" << endl;  // TEMP: quick & dirty wrapper name
    
    // operate on current union arm
    discriminatorSwitch(opCase, descName.str, ofs);

    // end function
    ofs << "_call << iluEndUnion;" << endl;
    if (op == CppGen_(input)) {
// TMP 9/7        ofs << localName(CppGen_(instance_key)) << "._d(" << descName.str << ");" << endl;
		// NOTE: arbitrary static cast below is overkill; really only needed
		// when discriminatorType() is Enumeration
        ofs << localName(CppGen_(instance_key))  // TMP 9/7: NEW
			<< "._d(" << CppGen_(Cast)::staticCast(discriminatorType()->name(), descName.str) << ");" << endl;  // TMP 9/7: NEW
	};
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

}


CppParseStream(ofstream) &
CppGen(Alias)::
_commonDefForward (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(urType())->aliasCommonDefForward(this, ofs);
    return ofs;
}


CppParseStream(ofstream) &
CppGen(Alias)::
_commonDef (CppParseStream(ofstream) & ofs) {
    CppGen_(Type)::narrow(urType())->aliasCommonDef(this, ofs);
    return ofs;
}


CppParseStream(ofstream) &
CppGen(Array)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    const char * simple_name = simpleName();
    CppParse(ArrayDimensionListIter) dimensionListIter(dimensions());
    const CppParse(ArrayDimension) * dimension;
    static ReusableString allocName;
    static ReusableString dupName;
    static ReusableString freeName;

    allocName.strcpy(simple_name);
    allocName.strcat("_alloc");
    dupName.strcpy(simple_name);
    dupName.strcat("_dup");
    freeName.strcpy(simple_name);
    freeName.strcat("_free");

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;    
    
    // _var declaration
    ofs << "class " << localUsageName(CppParseName(var)) << ";" << endl;

    // array declaration
    ofs << "typedef " << elementType()->usageName(CppParseName(element), scope()) << " " << localName();
    while ((dimension = dimensionListIter.next()) != NULL)
        ofs << "[" << dimension->length() << "]";
    ofs << ";" << endl;

    // _slice declaration
    ofs << "typedef " << elementType()->usageName(CppParseName(element), scope()) << " " << localUsageName(CppParseName(slice));
    dimensionListIter.reset();
    dimensionListIter.next();
    while ((dimension = dimensionListIter.next()) != NULL)
        ofs << "[" << dimension->length() << "]";
    ofs << ";" << endl;

    // _alloc declaration
    ofs << CppGen_(Namespace)::declareExtern() << " " << localUsageName(CppParseName(slice)) << "* "
        << (CppParseName(TempName)(allocName.str, scope())).localName() << " ();" << endl;

    // _dup declaration
    ofs << CppGen_(Namespace)::declareExtern() << " " << localUsageName(CppParseName(slice)) << "* "
// TMP 9/3        << (CppParseName(TempName)(dupName.str, scope())).localName() << " ("
        << (CppParseName(TempName)(dupName.str, scope())).localName() << " (const "  // TMP 9/3: NEW
        << localUsageName(CppParseName(slice)) << "*);" << endl;

    // _free declaration
    ofs << CppGen_(Namespace)::declareExtern() << " void "
        << (CppParseName(TempName)(freeName.str, scope())).localName() << "("
        << localUsageName(CppParseName(slice)) << "*);" << endl;

    ofs << endl;
    return ofs;
}

void
CppGen(Array)::
aliasCommonDefForward (const CppParseName(TypeName) * alias, CppParseStream(ofstream) & ofs) const {

    const char * simple_name = alias->simpleName();
    static ReusableString allocName;
    static ReusableString dupName;
    static ReusableString freeName;

    allocName.strcpy(simple_name);
    allocName.strcat("_alloc");
    dupName.strcpy(simple_name);
    dupName.strcat("_dup");
    freeName.strcpy(simple_name);
    freeName.strcat("_free");

    ofs << "// " << alias->name(CppGen_(period_key)) << endl;
    ofs << endl;    
    
    // _var declaration
    ofs << "typedef " << usageName(CppParseName(var), alias->scope()) << " "
        << alias->localUsageName(CppParseName(var)) << ";" << endl;

    // array declaration
    ofs << "typedef " << name(alias->scope()) << " " << alias->localName() << ";" << endl;

    // _slice declaration
    ofs << "typedef " << usageName(CppParseName(slice), alias->scope()) << " "
        << alias->localUsageName(CppParseName(slice)) << ";" << endl;

    // _alloc declaration
    ofs << alias->localUsageName(CppParseName(slice)) << "* "
        << (CppParseName(TempName)(allocName.str, alias->scope())).localName() << " ();" << endl;

    // _dup declaration
    ofs << alias->localUsageName(CppParseName(slice)) << "* "
// TMP 9/3        << (CppParseName(TempName)(dupName.str, alias->scope())).localName() << " ("
        << (CppParseName(TempName)(dupName.str, alias->scope())).localName() << " (const "  // TMP 9/3: NEW
        << alias->localUsageName(CppParseName(slice)) << "*);" << endl;

    // _free declaration
    ofs << "void "
        << (CppParseName(TempName)(freeName.str, alias->scope())).localName() << "("
        << alias->localUsageName(CppParseName(slice)) << "*);" << endl;

    ofs << endl;
}

CppParseStream(ofstream) & 
CppGen(Array)::
_commonDef (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
    
    // define array_var class

    ofs << "class " << localUsageName(CppParseName(var)) << ": public ilu_var {" << endl;
    ofs.indent++;
    ofs << endl;

    ofs << "public:" << endl;
    ofs.indent++;

    // default constructor
    ofs << localUsageName(CppParseName(var)) << "() : "
        << "_release(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ") {" << endl;
    ofs.indent++;
    ofs << "_slice_ = NULL;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // construct from slice*
    ofs << localUsageName(CppParseName(var)) << "(" << localUsageName(CppParseName(slice)) << "* _slice) :"
        << "_release(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ") {" << endl;
    ofs.indent++;
    ofs << "_slice_ = _slice;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // copy constructor
    ofs << localUsageName(CppParseName(var)) << "(const " << localUsageName(CppParseName(var)) << "& _array) :"
        << "_release(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ") {" << endl;
    ofs.indent++;
    static ReusableString dupName;
    dupName.strcpy(simpleName());
    dupName.strcat("_dup");
    ofs << "_slice_ = " << (CppParseName(TempName)(dupName.str, scope())).localName() << "(_array._slice_);" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // destructor
    ofs << "~" << localUsageName(CppParseName(var)) << "() {" << endl;
    ofs.indent++;
    ofs << "if (_release)" << endl;
    ofs.indent++;
    static ReusableString freeName;
    freeName.strcpy(simpleName());
    freeName.strcat("_free");
    ofs << (CppParseName(TempName)(freeName.str, scope())).localName() << "(_slice_);" << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // assign from slice*
    ofs << localUsageName(CppParseName(var)) << "&" << endl;
    ofs << "operator= (" << localUsageName(CppParseName(slice)) << "* _slice) {" << endl;
    ofs.indent++;
    ofs << "if (_slice_ != _slice)" << endl;
    ofs.indent++;
    ofs << "if (_release)" << endl;
    ofs.indent++;
    ofs << (CppParseName(TempName)(freeName.str, scope())).localName() << "(_slice_);" << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "_slice_ = _slice;" << endl;
    ofs << "return *this;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // assign from var&
    ofs << localUsageName(CppParseName(var)) << "&" << endl;
    ofs << "operator= (const " << localUsageName(CppParseName(var)) << "& _array) {" << endl;
    ofs.indent++;
    ofs << "if ((&_array != this) && (_slice_ != _array._slice_)) {" << endl;
    ofs.indent++;
    ofs << "if (_release)" << endl;
    ofs.indent++;
    ofs << (CppParseName(TempName)(freeName.str, scope())).localName() << "(_slice_);" << endl;
    ofs << "_slice_ = " << (CppParseName(TempName)(dupName.str, scope())).localName() << "(_array._slice_);" << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "};" << endl;
    ofs << "return *this;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // left-side indexing operator
    ofs << localUsageName(CppParseName(slice)) << "&" << endl;
    ofs << "operator [] (" << CppParseName(CorbaULong)()->name() << " _index) {" << endl;
    ofs.indent++;
    ofs << "return *(_slice_ + _index);" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // right-side indexing operator
    ofs << "const " << localUsageName(CppParseName(slice)) << "&" << endl;
    ofs << "operator [] (" << CppParseName(CorbaULong)()->name() << " _index) const {" << endl;
    ofs.indent++;
    ofs << "return *(_slice_ + _index);" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // conversion to const var& (in parameter conversion)
    static ReusableString arrayStarName;
    static ReusableString constArrayStarName;
    arrayStarName.strcpy(localName());
    arrayStarName.strcat("*");
    constArrayStarName.strcpy("const ");
    constArrayStarName.strcat(arrayStarName.str);
    ofs << "operator const " << localName() << "& () const {" << endl;
    ofs.indent++;
    ofs << "return *(" << CppGen_(Cast)::staticCast(constArrayStarName.str);
    ofs << CppGen_(Cast)::staticCast("void*", "_slice_") << "));" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // conversion to var& (inout & fixed out parameter conversion)
    ofs << "operator " << localName() << "& () const {" << endl;
    ofs.indent++;
    ofs << "return *(" << CppGen_(Cast)::staticCast(arrayStarName.str);
    ofs << CppGen_(Cast)::staticCast("void*", "_slice_") << "));" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // iluSetRelease
    static ReusableString corbaBooleanStar;
    corbaBooleanStar.strcpy(CppParseName(CorbaBoolean)()->name());
    corbaBooleanStar.strcat("*");
    ofs << "void" << endl;
    ofs << "iluSetRelease (" << CppParseName(CorbaBoolean)()->name() << " release_on_destruct) const {" << endl;
    ofs.indent++;
    ofs << "*" << CppGen_(Cast)::constCast(corbaBooleanStar.str, "&_release") << " = release_on_destruct;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // iluGetRelease
    ofs << CppParseName(CorbaBoolean)()->name() << endl;
    ofs << "iluGetRelease () const {" << endl;
    ofs.indent++;
    ofs << "return _release;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    ofs.indent--;
    ofs << "public:  // for ILU stub use" << endl;
    ofs.indent++;
    ofs << endl;

    CppParse(ArrayDimensionListIter) dimensionListIter(dimensions());
    const CppParse(ArrayDimension) * dimension;
    static ReusableString arrayMinus1stDim;
    arrayMinus1stDim.strcpy(elementType()->usageName(CppParseName(element), scope()));
    arrayMinus1stDim.strcat(" _array[]");
    dimensionListIter.next();
    while ((dimension = dimensionListIter.next()) != NULL) {
        arrayMinus1stDim.strcat("[");
        arrayMinus1stDim.ucat(dimension->length());
        arrayMinus1stDim.strcat("]");
    };

    // _size, _input, and _output functions
    ofs << "static iluBaseCall&" << endl;
    ofs << "_size_const (iluBaseCall&, const " << arrayMinus1stDim.str << ");" << endl;
    ofs << endl;
    ofs << "static iluBaseCall&" << endl;
    ofs << "_size (iluBaseCall&, " << arrayMinus1stDim.str << ");" << endl;
    ofs << endl;
    ofs << "static iluBaseCall&" << endl;
    ofs << "_output_const (iluBaseCall&, const " << arrayMinus1stDim.str << ");" << endl;
    ofs << endl;
    ofs << "static iluBaseCall&" << endl;
    ofs << "_output (iluBaseCall&, " << arrayMinus1stDim.str << ");" << endl;
    ofs << endl;
    ofs << "static iluBaseCall&" << endl;
    ofs << "_input (iluBaseCall&, " << arrayMinus1stDim.str << ");" << endl;

    // _alloc function  // TMP 7/15: NEW
    ofs << endl;  // TMP 7/15: NEW
    ofs << "static " << localUsageName(CppParseName(slice)) << "*" << endl;  // TMP 7/15: NEW
    ofs << "_alloc ();" << endl;  // TMP 7/15: NEW

    // _copy function
    ofs << endl;
    ofs << "static void" << endl;
    ofs << "_copy (const " << localName() << ", " << localName() << ");" << endl;

    // surrogate-side cleanup functions
    if (variableLength()) {
        ofs << endl;
        ofs << "static void" << endl;
        ofs << "_surrogateSideCleanup (" << localUsageName(CppParseName(slice)) << "*);" << endl;
        ofs << "static void" << endl;
        ofs << "_surrogateSideCleanup_const (const " << localUsageName(CppParseName(slice)) << "*);" << endl;
    };

    ofs << endl;

    ofs.indent--;
    ofs << "protected:" << endl;
    ofs.indent++;
    ofs << endl;

    // _slice_ member
    ofs << localUsageName(CppParseName(slice)) << "* _slice_;" << endl;
    ofs << endl;

    // _release member
    ofs << CppParseName(CorbaBoolean)()->name() << " _release;" << endl;
    ofs << endl;

    ofs.indent--;
    ofs << "private:" << endl;
    ofs.indent++;
    ofs << endl;

    // assignment from const ilu_var&
    ofs << localUsageName(CppParseName(var)) << "&" << endl;
    ofs << "operator= (const ilu_var&);" << endl;
    ofs << endl;

    // construction from const ilu_var&
    ofs << localUsageName(CppParseName(var)) << " (const ilu_var&);" << endl;
    ofs << endl;

    ofs.indent--;
    ofs.indent--;
    ofs << "};" << endl;

    ofs << endl;
    return ofs;
}

void
CppGen(Array)::
aliasCommonDef (const CppParseName(TypeName) * alias, CppParseStream(ofstream) & ofs) const {

    // names of alias' alloc, dup, and free functions
    static ReusableString aliasAllocName;
    static ReusableString aliasDupName;
    static ReusableString aliasFreeName;

    // names of original array's alloc, dup, and free functions
    static ReusableString allocName;
    static ReusableString dupName;
    static ReusableString freeName;

    aliasAllocName.strcpy(alias->simpleName());
    aliasAllocName.strcat("_alloc");
    aliasDupName.strcpy(alias->simpleName());
    aliasDupName.strcat("_dup");
    aliasFreeName.strcpy(alias->simpleName());
    aliasFreeName.strcat("_free");

    allocName.strcpy(simpleName());
    allocName.strcat("_alloc");
    dupName.strcpy(simpleName());
    dupName.strcat("_dup");
    freeName.strcpy(simpleName());
    freeName.strcat("_free");

    ofs << "// " << alias->name(CppGen_(period_key)) << endl;
    
    // _alloc function
    ofs << endl;
    ofs << "inline" << endl;
    ofs << alias->localUsageName(CppParseName(slice)) << "* " << endl;
    ofs << (CppParseName(TempName)(aliasAllocName.str, alias->scope())).localName() << " () {" << endl;
    ofs.indent++;
    ofs << "return " << (CppParseName(TempName)(allocName.str, alias->scope())).name(alias->scope()) << "();" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // _dup function
    ofs << endl;
    ofs << "inline" << endl;
    ofs << alias->localUsageName(CppParseName(slice)) << "* " << endl;
    ofs << (CppParseName(TempName)(aliasDupName.str, alias->scope())).localName()
// TMP 9/3        << " (" << alias->localUsageName(CppParseName(slice)) << "* _slice) {" << endl;
        << " (const " << alias->localUsageName(CppParseName(slice)) << "* _slice) {" << endl;  // TMP 9/3: NEW
    ofs.indent++;
    ofs << "return " << (CppParseName(TempName)(dupName.str, alias->scope())).name(alias->scope())
        << "(_slice);" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // _free function
    ofs << endl;
    ofs << "inline" << endl;
    ofs << "void" << endl;
    ofs << (CppParseName(TempName)(aliasFreeName.str, alias->scope())).localName()
        << " (" << alias->localUsageName(CppParseName(slice)) << "* _slice) {" << endl;
    ofs.indent++;
    ofs << (CppParseName(TempName)(freeName.str, alias->scope())).name(alias->scope())
        << "(_slice);" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    ofs << endl;
}

void  // TMP 8/3: NEW
CppGen(Array)::
optionalCommonDefForward (const CppParseName(TypeName) * optional, CppParseStream(ofstream) & ofs) const {

    // typedef for optional
    ofs << "typedef " << usageName(CppParseName(slice), optional->scope()) << "* "
        << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << usageName(CppParseName(slice), optional->scope()) << "* "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptionalArray" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "MgrT<"
        << usageName(CppParseName(slice), optional->scope()) << ", "
        << usageName(CppParseName(var), optional->scope()) << "> "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}


CppParseStream(ofstream) &
CppGen(Array)::
_commonImpl (CppParseStream(ofstream) & ofs) {

    CppParse(ArrayDimensionListIter) dimensionListIter(dimensions());
    const CppParse(ArrayDimension) * dimension;
    int i;  // loop index

    // fully-qualified form of array_alloc
    static ReusableString allocName;
    allocName.strcpy(simpleName());
    allocName.strcat("_alloc");
    allocName.strcpy(CppParseName(TempName)(allocName.str, scope()).name());

    // fully-qualified form of array_dup
    static ReusableString dupName;
    dupName.strcpy(simpleName());
    dupName.strcat("_dup");
    dupName.strcpy(CppParseName(TempName)(dupName.str, scope()).name());

    // fully-qualified form of array_free
    static ReusableString freeName;
    freeName.strcpy(simpleName());
    freeName.strcat("_free");
    freeName.strcpy(CppParseName(TempName)(freeName.str, scope()).name());

    // fully-qualified form of array_slice*
    static ReusableString sliceStar;
    sliceStar.strcpy(usageName(CppParseName(slice)));
    sliceStar.strcat("*");

    // fully-qualified form of elementType*, const elementType*
    static ReusableString elementTypeStar;
    static ReusableString constElementTypeStar;
    elementTypeStar.strcpy(elementType()->usageName(CppParseName(element)));
    elementTypeStar.strcat("*");
	constElementTypeStar.strcpy("const ");
	constElementTypeStar.strcat(elementTypeStar.str);

    // _alloc
    {
        static ReusableString newArray;
        newArray.strcpy("(new ");
        newArray.strcat(elementType()->usageName(CppParseName(element)));
        while ((dimension = dimensionListIter.next()) != NULL) {
            newArray.strcat("[");
            newArray.ucat(dimension->length());
            newArray.strcat("]");
        };
        newArray.strcat(")");
        ofs << usageName(CppParseName(slice)) << "*" << endl;
        ofs << allocName.str << " () {" << endl;
        ofs.indent++;
        dimensionListIter.reset();
        ofs << "return " << CppGen_(Cast)::staticCast(sliceStar.str, newArray.str) << ";" << endl;
        ofs.indent--;
        ofs << "}" << endl;
        ofs << endl;
    };

    // begin _dup function
    ofs << usageName(CppParseName(slice)) << "*" << endl;
    ofs << dupName.str << " ";
// TMP 9/3    ofs << "(" << usageName(CppParseName(slice)) << "* _slice) {" << endl;
    ofs << "(const " << usageName(CppParseName(slice)) << "* _slice) {" << endl;  // TMP 9/3: NEW
    ofs.indent++;

	// if arg is NULL, return NULL
    ofs << "if (_slice == NULL)" << endl;
    ofs.indent++;
    ofs << "return NULL;" << endl;
    ofs.indent--;

	// else, allocate new slice, copy individual elements and return
    ofs << "else {" << endl;
    ofs.indent++;

	// declare/allocate new slice
    ofs << usageName(CppParseName(slice)) << "* _new_slice = "
        << allocName.str << "();" << endl;

	// declare/initialize pointer to new element
    ofs << elementTypeStar.str << " _new_element = "
        << CppGen_(Cast)::staticCast(elementTypeStar.str);
    ofs << CppGen_(Cast)::staticCast("void*", "_new_slice") << ");" << endl;

	// declare/initialize pointer to old element
    ofs << constElementTypeStar.str << " _old_element = "
        << CppGen_(Cast)::staticCast(constElementTypeStar.str);
    ofs << CppGen_(Cast)::staticCast("const void*", "_slice") << ");" << endl;

	// loop thru elements, copying old to new
    ofs << "for (" << CppParseName(CorbaULong)()->name() << " _count = 0; ";
    dimensionListIter.reset();
    dimension = dimensionListIter.next();
    ofs << "_count < (" << dimension->length();
    while ((dimension = dimensionListIter.next()) != NULL)
        ofs << " * " << dimension->length();
    ofs << "); _count++)" << endl;
    ofs.indent++;
    ofs << "*_new_element++ = *_old_element++;" << endl;
    ofs.indent--;

	// return new slice
    ofs << "return _new_slice;" << endl;
    ofs.indent--;
    ofs << "};" << endl;

	// end _dup function
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // _free
    ofs << "void" << endl;
    ofs << freeName.str << " (" << usageName(CppParseName(slice)) << "* _slice) {" << endl;
    ofs.indent++;
    ofs << "delete [] _slice;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // sizing, input, and output operations
    outputIOOpImpl(CppGen_(size), ofs, FALSE);
    ofs << endl;
    outputIOOpImpl(CppGen_(size), ofs, TRUE);
    ofs << endl;
    outputIOOpImpl(CppGen_(input), ofs, FALSE);
    ofs << endl;
    outputIOOpImpl(CppGen_(output), ofs, FALSE);
    ofs << endl;
    outputIOOpImpl(CppGen_(output), ofs, TRUE);
    ofs << endl;

    // _alloc function  // TMP 7/15
    ofs << endl;  // TMP 7/15
    ofs << usageName(CppParseName(slice)) << "*" << endl;  // TMP 7/15
    ofs << usageName(CppParseName(var)) << "::" << endl;  // TMP 7/15
    ofs << "_alloc () {" << endl;  // TMP 7/15
    ofs.indent++;  // TMP 7/15
    ofs << "return " << allocName.str << "();" << endl;  // TMP 7/15
    ofs.indent--;  // TMP 7/15
    ofs << "}" << endl;  // TMP 7/15

    // _copy function
    ofs << endl;
    ofs << "void" << endl;
    ofs << usageName(CppParseName(var)) << "::" << endl;
    ofs << "_copy (const " << localName() << " _from, " << localName() << " _to) {" << endl;
    ofs.indent++;
    ofs << "const " << elementTypeStar.str << " _from_element = &_from";
    for (i = dimensions().count(); i > 0; i--)
        ofs << "[0]";
    ofs << ";" << endl;
    ofs << elementTypeStar.str << " _to_element = &_to";
    for (i = dimensions().count(); i > 0; i--)
        ofs << "[0]";
    ofs << ";" << endl;
    ofs << "for (" << CppParseName(CorbaULong)()->name() << " _count = 0; ";
    dimensionListIter.reset();
    dimension = dimensionListIter.next();
    ofs << "_count < (" << dimension->length();
    while ((dimension = dimensionListIter.next()) != NULL)
        ofs << " * " << dimension->length();
    ofs << "); _count++)" << endl;
    ofs.indent++;
    ofs << "*_to_element++ = *_from_element++;" << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "}" << endl;

    // surrogate-side-cleanup functions
    if (needsSurrogateSideCleanup()) {
        ofs << endl;
        outputSurrogateSideCleanupImpl(ofs, FALSE);
        ofs << endl;
        outputSurrogateSideCleanupImpl(ofs, TRUE);
        ofs << endl;
    };

    return ofs;
};

void
CppGen(Array)::
outputIOOpImpl (CppGen_(IOOp) op, CppParseStream(ofstream)& ofs, ILUCPP_BOOL constArray) const {
    
    CppParse(ArrayDimensionListIter) dimensionListIter(dimensions());
    const CppParse(ArrayDimension) * dimension;
	static ReusableString nElements;

	// Build up expression for total number of elements in array
	// of the form "n * m * ..."
	dimension = dimensionListIter.next();
	nElements.reset();
	nElements.ucat(dimension->length());  // array must have at least one dimension
	while ((dimension = dimensionListIter.next()) != NULL) {
		nElements.strcat(" * ");
		nElements.ucat(dimension->length());
	};
    
    ofs << "iluBaseCall&" << endl;
    ofs << usageName(CppParseName(var)) << "::" << endl;
    
    // function name
    switch (op) {
    case CppGen_(size):
        ofs << "_size";
        break;
    case CppGen_(input):
        ofs << "_input";
        break;
    case CppGen_(output):
        ofs << "_output";
        break;
    };
    if (constArray)
        ofs << "_const";
    ofs << " ";
    
    // parameter list
    ofs << "(iluBaseCall& _call, ";
    if (constArray)
        ofs << "const ";
    ofs << elementType()->usageName(CppParseName(element)) << " _array[]";
	dimensionListIter.reset();
    dimensionListIter.next();
    while ((dimension = dimensionListIter.next()) != NULL)
        ofs << "[" << dimension->length() << "]";
    ofs << ") {" << endl;
    ofs.indent++;
    
	if (CppGen_(Byte)::narrow(elementType()->urType()) != NULL) {

		// Rutime/kernel has separate (optimized) I/O operations for Arrays of Bytes

		ofs << "iluOpaqueWrapper _array_wrapper" << "(_array, " << nElements.str << ");" << endl;
		switch (op) {
		case CppGen_(size):
			ofs << "_call += _array_wrapper;" << endl;
			break;
		case CppGen_(input):
			ofs << "_call >> _array_wrapper;" << endl;
			break;
		case CppGen_(output):
			ofs << "_call << _array_wrapper;" << endl;
			break;
		default:  // shouldn't happen
			break;
		};
	}

	else {

		// Generic array I/O operations

		// set _call mode
		if (op == CppGen_(input))
			ofs << "_call << iluInputArray;" << endl;
		else {
			if (op == CppGen_(output))
				ofs << "_call.iluOutputArray";
			else  // CppGen::size
				ofs << "_call.iluSizeArray";
/* TMP 9/15
			dimensionListIter.reset();
			dimension = dimensionListIter.next();
			ofs << "(" << dimension->length();  // array must have at least one dimension
			while ((dimension = dimensionListIter.next()) != NULL)
				ofs << " * " << dimension->length();
			ofs << ");" << endl;
TMP 9/15 */
			ofs << "(" << nElements.str << ");" << endl;
		};

		// begin for loops to iterate through array elements
		long unsigned index = 0;
		dimensionListIter.reset();
		while ((dimension = dimensionListIter.next()) != NULL) {
			ofs << "for (iluCardinal _index" << index << " = 0; "
				<< "_index" << index << " < " << dimension->length() << "; "
				<< "_index" << index << "++) {" << endl;
			ofs.indent++;
			index++;
		};

		// body of inner loop: perform operation with array element
	/* TMP 9/8
		switch (op) {
		case CppGen_(size):
			ofs << "_call += _array";
			break;
		case CppGen_(input):
			ofs << "_call >> _array";
			break;
		case CppGen_(output):
			ofs << "_call << _array";
			break;
		};
		index = 0;
		dimensionListIter.reset();
		while ((dimension = dimensionListIter.next()) != NULL) {
			ofs << "[_index" << index << "]";
			index++;
		};
		ofs << ";" << endl;
	TMP 9/8 */
		{  // TMP 9/8: NEW
			const CppGen_(Type) * eType = CppGen_(Type)::narrow(elementType());
			switch (op) {
			case CppGen_(size):
				eType->initialDeclsOutput(&element, ILUCPP_FALSE, ofs);
				eType->sizing(&element, ofs);
				break;
			case CppGen_(input):
				eType->initialDeclsInput(&element, ILUCPP_FALSE, ofs);
				eType->receive(&element, ofs);
				break;
			case CppGen_(output):
				eType->initialDeclsOutput(&element, ILUCPP_FALSE, ofs);
				eType->send(&element, ofs);
				break;
			default:  // shouldn't happen
				break;
			};
		};

		// end for loops
		while (index-- > 0) {
			ofs.indent--;
			ofs << "};" << endl;
		};

		ofs << "_call << iluEndArray;" << endl;
	};

    // finish function
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

}

void
CppGen(Array)::
outputSurrogateSideCleanupImpl (CppParseStream(ofstream)& ofs, ILUCPP_BOOL constArray) const {
    
    CppParse(ArrayDimensionListIter) dimensionListIter(dimensions());
    const CppParse(ArrayDimension) * dimension;

    // fully-qualified form of elementType*
    static ReusableString elementTypeStar;
    elementTypeStar.strcpy(elementType()->usageName(CppParseName(element)));
    elementTypeStar.strcat("*");

    // unqualified (local) form of _slice*
    static ReusableString sliceTypeStar;
    sliceTypeStar.strcpy(usageName(CppParseName(slice)));
    sliceTypeStar.strcat("*");

    // begin function
    ofs << "void" << endl;
    ofs << usageName(CppParseName(var)) << "::" << endl;
    ofs << "_surrogateSideCleanup"
        << (constArray ? "_const " : " ")
        << "(" << (constArray ? "const " : "") << sliceTypeStar.str << " _slice) {" << endl;
    ofs.indent++;

    // begin if
    ofs << "if (_slice != NULL) {" << endl;
    ofs.indent++;
    ofs << elementTypeStar.str << " _element = "
        << CppGen_(Cast)::staticCast(elementTypeStar.str);
    ofs << CppGen_(Cast)::staticCast("void*");
    ofs << CppGen_(Cast)::constCast(sliceTypeStar.str, "_slice") << "));" << endl;

    // begin for loop
    ofs << "for (" << CppParseName(CorbaULong)()->name() << " _count = 0; ";
    dimension = dimensionListIter.next();
    ofs << "_count < (" << dimension->length();
    while ((dimension = dimensionListIter.next()) != NULL)
        ofs << " * " << dimension->length();
    ofs << "); _count++) {" << endl;
    ofs.indent++;

    // loop body
    CppGen_(Type)::narrow(elementType())->surrogateCleanup(&element, ofs);
    ofs <<"_element++;" << endl;

    // end loop
    ofs.indent--;
    ofs << "};" << endl;

    // end if
    ofs.indent--;
    ofs << "};" << endl;

    // end function
    ofs.indent--;
    ofs << "}" << endl;

}


/* TMP 7/7
CppParseStream(ofstream) &
CppGen(Optional)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    const char * deref = valueType()->isPtr()
        ? " "
        : "* ";
    static ReusableString const_simple_name;

    const_simple_name.strcpy("const_");
    const_simple_name.strcat(simpleName());

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;

    // typedef for optional
    ofs << "typedef " << valueType()->name(scope()) << deref << localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << valueType()->name(scope()) << deref
        << CppParseName(TempName)(const_simple_name.str, scope()).localName() << ";" << endl;

    ofs << endl;
    return ofs;
}
*/

/* TMP 7/14
CppParseStream(ofstream) &  // TMP 7/7: NEW
CppGen(Optional)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    const char * const_name;
    const char * definition;
    const char * const_definition;

    // build up simple (unqualified) name for constant optional
    {
        static ReusableString work1;
        static ReusableString work2;
        work1.strcpy("const_");
        work1.strcat(simpleName());
        work2.strcpy(CppParseName(TempName)(work1.str, scope()).localName());
        const_name = work2.str;
    };

    // build up definitions
    if (valueType()->indirection() == CppParse_(pseudoPointer)) {
        static ReusableString work1;
        static ReusableString work2;
        definition = valueType()->name(scope());
        work1.strcpy("const_");
        work1.strcat(valueType()->simpleName());
        work2.strcpy(CppParseName(TempName)(work1.str, valueType()->scope()).name(scope()));
        const_definition = work2.str;
    }
    else {
        static ReusableString work1;
        static ReusableString work2;
        work1.strcpy(valueType()->name(scope()));
        work1.strcat("*");
        definition = work1.str;
        work2.strcpy("const ");
        work2.strcat(definition);
        const_definition = work2.str;
    };

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;

    // typedef for optional
    ofs << "typedef " << definition << " " << localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef " << const_definition << " " << const_name << ";" << endl;

    ofs << endl;
    return ofs;
}
*/

/* TMP 8/3
CppParseStream(ofstream) &  // TMP 7/14: NEW
CppGen(Optional)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    const char * const_name;

    // build up simple (unqualified) name for constant optional
    {
        static ReusableString work1;
        static ReusableString work2;
        work1.strcpy("const_");
        work1.strcat(simpleName());
        work2.strcpy(CppParseName(TempName)(work1.str, scope()).localName());
        const_name = work2.str;
    };

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;

    // typedef for optional
    ofs << "typedef " << valueType()->usageName(CppParseName(optionalBaseRef), scope()) << " "
        << localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef " << valueType()->usageName(CppParseName(constOptionalBaseRef), scope()) << " "
        << const_name << ";" << endl;

    // typedef for optional_var
    ofs << "typedef " << valueType()->usageName(CppParseName(var), scope()) << " "
        << localUsageName(CppParseName(var)) << ";" << endl;

    ofs << endl;
    return ofs;
}
*/

CppParseStream(ofstream) &  // TMP 8/3: NEW
CppGen(Optional)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;

    CppGen_(Type)::narrow(valueType())->optionalCommonDefForward(this, ofs);

    ofs << endl;
    return ofs;
}

void  // TMP 6/28
CppGen(Optional)::
aliasCommonDefForward (const CppParseName(TypeName) * alias, CppParseStream(ofstream) & ofs) const {

/* TMP 8/4
    static ReusableString const_simple_name;
    static ReusableString const_alias_simple_name;

    const_simple_name.strcpy("const_");
    const_simple_name.strcat(simpleName());
    const_alias_simple_name.strcpy("const_");
    const_alias_simple_name.strcat(alias->simpleName());
*/
    ofs << "// " << alias->name(CppGen_(period_key)) << endl;
    ofs << endl;

    // typedef for optional
    ofs << "typedef " << name(alias->scope()) << " " << alias->localName() << ";" << endl;

    // typedef for const_optional
/* TMP 8/4
    ofs << "typedef " << CppParseName(TempName)(const_simple_name.str, scope()).name(alias->scope());
    ofs << " " << CppParseName(TempName)(const_alias_simple_name.str, alias->scope()).localName() << ";" << endl;
*/
    ofs << "typedef " << usageName(CppParseName(constRef), alias->scope()) << " "  // TMP 8/4: NEW
        << alias->localUsageName(CppParseName(constRef)) << ";" << endl;  // TMP 8/4: NEW

    // typedef for optional_var
    ofs << "typedef " << usageName(CppParseName(var), alias->scope())
        << " " << alias->localUsageName(CppParseName(var)) << ";" << endl;

    ofs << endl;
}


CppParseStream(ofstream) &
CppGen(Object)::
_commonImpl (CppParseStream(ofstream) & ofs) {
	
    ofs << "//////////////////////////////////////////////////////////" << endl;
    ofs << "//  " << name(CppGen_(period_key)) << " IO operators" << endl;
	ofs << endl;
	ofs << commonImplIOOperators();

	ofs << endl;
    ofs << endl;
    ofs << "//////////////////////////////////////////////////////////////////////" << endl;
	ofs << "// " << name(CppGen_(period_key)) << " members" << endl;
	ofs << endl;
	
	ofs << "// CORBA object reference operations" << endl;
	ofs << endl;
	ofs << commonImplDuplicate();
	ofs << endl;
	ofs << commonImplNil();
	
	ofs << endl;
	ofs << endl;
	ofs << "// constructors/destructor" << endl;
	ofs << endl;
	ofs << commonImplTors();
	
	ofs << endl;
	ofs << endl;
	ofs << "// assignment operator" << endl;
	ofs << endl;
	ofs << commonImplAssignmentOperator();
	
	ofs << endl;
	ofs << endl;
	ofs << "// Simple Object Lookup" << endl;
	ofs << endl;
	ofs << commonImplIluLookup();
	
	ofs << endl;
	ofs << endl;
	ofs << "// for use in narrowing" << endl;
	ofs << endl;
	ofs << commonImplIluDowncast();
	
	ofs << endl;
	ofs << endl;
	ofs << "// initialize to use " << name(CppGen_(period_key)) << " class of objects" << endl;
	ofs << endl;
	ofs << commonImplIluInitialize();
	
	return ofs;
}

CppParseStream(ofstream) &
CppGen(Object)::
_commonImplDuplicate (CppParseStream(ofstream) & ofs) {
	ofs << usageName(CppParseName(ptr)) << " " << name() << "::_duplicate( "
		<< localUsageName(CppParseName(ptr)) << " a_ptr) {" << endl;
	ofs.indent++;
    ofs << "if (a_ptr != NULL)" << endl;
    ofs.indent++;
	ofs << "a_ptr->iluIncrementReferenceCount();" << endl;
    ofs.indent--;
	ofs << "return a_ptr;" << endl;
	ofs.indent--;
	ofs << "}" << endl;
	return ofs;
};

CppParseStream(ofstream) &
CppGen(Object)::
_commonImplNil (CppParseStream(ofstream) & ofs) {
	ofs << usageName(CppParseName(ptr)) << " " << name() << "::_nil() {" << endl;
	ofs.indent++;
    ofs << "return " << CppGen_(Cast)::staticCast(localUsageName(CppParseName(ptr)), "NULL") << ";" << endl;
	ofs.indent--;
	ofs << "}" << endl;
	return ofs;
};

CppParseStream(ofstream) &
CppGen(Object)::
_commonImplIluInitialize (CppParseStream(ofstream) & ofs) {

	// begin fuction
    ofs << "void " << name() << "::iluInitialize() {" << endl;
	ofs.indent++;
    ofs << endl;

    // declare method variable
    if (procedures().count() > 0)
        ofs << "ilu_Method _method;" << endl;

    // declare superclass uid array
/* TMP 9/7
    if (superclasses().count() > 0) {
        CppParse(ObjectListIter) objectListIter(superclasses());
        ILUCPP_BOOL firstSuperclass = ILUCPP_TRUE;
        const CppParse(Object) * object;
        ofs << endl;
        ofs << "char * _superclasses[] = {" << endl;
        ofs.indent++;
        while ((object = objectListIter.next()) != NULL) {
            if (firstSuperclass)
                firstSuperclass = ILUCPP_FALSE;
            else
                ofs << "," << endl;
            ofs << "\"" << object->uid() << "\"";
        };
        ofs << endl;
        ofs.indent--;
        ofs << "};" << endl;
    };
TMP 9/7 */
    if (superclasses().count() > 0) {  // TMP 9/7: NEW
        CppParse(TypeListIter) superListIter(superclasses());
        ILUCPP_BOOL firstSuperclass = ILUCPP_TRUE;
        const CppParse(Type) * super;
        ofs << endl;
        ofs << "char * _superclasses[] = {" << endl;
        ofs.indent++;
        while ((super = superListIter.next()) != NULL) {
            if (firstSuperclass)
                firstSuperclass = ILUCPP_FALSE;
            else
                ofs << "," << endl;
            ofs << "\"" << super->uid() << "\"";
        };
        ofs << endl;
        ofs.indent--;
        ofs << "};" << endl;
    };

	// define object type
	ofs << "// create and set the class record member to be the iluClass for "
		<< "this object type" << endl;
	ofs << "m_ILUClassRecord = iluCppInternal::iluDefineObjectType(" << endl;
	ofs.indent++;
	ofs << "\"" << name(CppGen_(period_key)) << "\", // ILU name" << endl;
	ofs << "\"" << ((brand() == NULL) ? "" : brand()) << "\", // brand" << endl;
	ofs << "\"" << ((uid() == NULL) ? "" : uid()) << "\", // type id" << endl;
	if (singleton() == NULL)
		ofs << "NULL,  // singleton" << endl;
	else
		ofs << "\"" << singleton() << "\",  //singleton" << endl;
    ofs << CppGen_(Bool)::value(optional()) << ",  // optional ?" << endl;
    ofs << CppGen_(Bool)::value(collectible()) << ",  // collectible ?" << endl;
	if (docString() == NULL)
		ofs << "NULL,  // doc string" << endl;
	else
		ofs << "\"" << docString() << "\",  // doc string" << endl;
	ofs << procedures().count() << ",  // number of methods" << endl;
	ofs << superclasses().count() << ",  // number of superclasses" << endl;
    if (superclasses().count() > 0)
        ofs << "_superclasses" << endl;
    else
        ofs << "NULL  // no superclasses" << endl;
	ofs.indent--;
	ofs << ");" << endl;
	ofs << endl;
	
    // define object's methods
	ofs << endl;
	CppParse(ProcedureListIter) procs(procedures());
	const CppGen_(Procedure) * proc;
	while ((proc = CppGen_(Procedure)::narrow(procs.next())) != NULL) {
		ofs << proc->commonImplDefineMethod();
		ofs << endl;
	};
	
	ofs << "iluCppInternal::iluObjectTypeDefined(m_ILUClassRecord);" << endl;

	// end function
    ofs.indent--;
	ofs << "};" << endl;
	return ofs;
}

CppParseStream(ofstream) &
CppGen(Object)::
_commonImplIluLookup (CppParseStream(ofstream) & ofs) {
	ofs << usageName(CppParseName(ptr)) << " " << name()
		<< "::iluLookup(char* server_id, char* instance_handle) {" << endl;
	ofs.indent++;
    ofs << "return (" << CppGen_(Cast)::staticCast(
           localUsageName(CppParseName(ptr)),
           "iluObject::iluLookup(server_id, instance_handle, m_ILUClassRecord)")
           << ");" << endl;
	ofs.indent--;
	ofs << "}" << endl;
	return ofs;
}


// Generate "else if" clauses for iluDowncast function

static  // TMP 8/1: NEW
void
generateClassToCastDownToCheck (const CppParse(Object) * from, const CppParse(Object) * to, CppParseStream(ofstream)& ofs) {
/* TMP 9/7
    CppParse(ObjectListIter) objectListIter(to->superclasses());
    const CppParse(Object) * object;
TMP 9/7 */
    CppParse(TypeListIter) superListIter(to->superclasses());  // TMP 9/7: NEW
    const CppParse(Type) * super;  // TMP 9/7: NEW

    // First, check class_to_cast_down_to against the class specified by to
    if (from == to) {
        ofs << "else if (class_to_cast_down_to == m_ILUClassRecord)" << endl;
        ofs.indent++;
        ofs << "return " << CppGen(Cast)::reinterpretCast("void*", "this") << ";" << endl;
    }
    else {
        ofs << "else if (class_to_cast_down_to == " << to->name(from) << "::m_ILUClassRecord)" << endl;
        ofs.indent++;
        ofs << "return " << CppGen(Cast)::reinterpretCast("void*");
        ofs << CppGen(Cast)::staticCast(to->usageName(CppParseName(ptr), from), "this") << ");" << endl;
    };
    ofs.indent--;

    // Now, recursively check each of to's superclasses
/* TMP 9/7
    while ((object = objectListIter.next()) != NULL)
        generateClassToCastDownToCheck(from, object, ofs);
TMP 9/7 */
    while ((super = superListIter.next()) != NULL)  // TMP 9/7: NEW
        generateClassToCastDownToCheck(from, CppParse(Object)::narrow(super->urType()), ofs);

}

/* TMP 8/1
CppParseStream(ofstream) &
CppGen(Object)::
_commonImplIluDowncast (CppParseStream(ofstream) & ofs) {
	// TMP: 1/13: Downcasting is ovbiously more complex than this
	// when the object has superclasses.

    // begin function
	ofs << "void *" << name() << "::iluDowncast (iluClass class_to_cast_down_to) {" << endl;
	ofs.indent++;

    // if clause
	ofs << "if (class_to_cast_down_to == NULL || class_to_cast_down_to == ilu_rootClass)" << endl;
	ofs.indent++;
    ofs << "return " << CppGen_(Cast)::reinterpretCast("void*");
    ofs << CppGen_(Cast)::staticCast("iluObject*", "this") << ");" << endl;
	ofs.indent--;

    // else if clause
	ofs << "else if (class_to_cast_down_to == m_ILUClassRecord)" << endl;
	ofs.indent++;
    ofs << "return " << CppGen_(Cast)::reinterpretCast("void*", "this") << ";" << endl;
	ofs.indent--;

    // else clause
	ofs << "else" << endl;
    ofs.indent++;
    ofs << "return NULL;" << endl;
	ofs.indent--;

    // end function
	ofs << "}" << endl;
	ofs.indent--;
	return ofs;
};
*/

CppParseStream(ofstream) &  // TMP 8/1
CppGen(Object)::
_commonImplIluDowncast (CppParseStream(ofstream) & ofs) {

    // begin function
	ofs << "void *" << name() << "::iluDowncast (iluClass class_to_cast_down_to) {" << endl;
	ofs.indent++;

    // check against NULL or ilu_rootClass
	ofs << "if (class_to_cast_down_to == NULL || class_to_cast_down_to == ilu_rootClass)" << endl;
	ofs.indent++;
    ofs << "return " << CppGen_(Cast)::reinterpretCast("void*");
    ofs << CppGen_(Cast)::staticCast("iluObject*", "this") << ");" << endl;
	ofs.indent--;

    // check against this Object type, and (recursively) all supertypes
	generateClassToCastDownToCheck(this, this, ofs);

    // default
	ofs << "else" << endl;
    ofs.indent++;
    ofs << "return NULL;" << endl;
	ofs.indent--;

    // end function
	ofs.indent--;
	ofs << "}" << endl;
	return ofs;
};

CppParseStream(ofstream) &
CppGen(Object)::
_commonImplTors (CppParseStream(ofstream) & ofs) {

	ofs << name() << "::" << localName() << "() {" << endl;
	ofs.indent++;
	ofs << "// to be determined" << endl;
	ofs.indent--;
	ofs << "}" << endl;

	ofs << endl;
	ofs << name() << "::~" << localName() << "() {" << endl;
	ofs.indent++;
	ofs << "// to be determined" << endl;
	ofs.indent--;
	ofs << "}" << endl;

	ofs << endl;
	ofs << name() << "::" << localName() << "(const "
		<< localName() << "&) {" << endl;
	ofs.indent++;
	ofs << "// to be determined" << endl;
	ofs.indent--;
	ofs << "}" << endl;

	return ofs;
};

CppParseStream(ofstream) &
CppGen(Object)::
_commonImplAssignmentOperator (CppParseStream(ofstream) & ofs) {
	ofs << "void " << name() << "::operator=(const "
		<< localName() << "&) {" << endl;
	ofs.indent++;
	ofs << "// to be determined" << endl;
	ofs.indent--;
	ofs << "}" << endl;
	return ofs;
};

CppParseStream(ofstream) &
CppGen(Object)::
_commonImplIOOperators (CppParseStream(ofstream) & ofs) {

    // Sizing operator
    ofs << "iluBaseCall& operator+= (iluBaseCall& call, const "
        << usageName(CppParseName(var)) << "& obj) {" << endl;
    ofs.indent++;
    ofs << "call += obj.iluGetObjectPointer();" << endl;
    ofs << "return (call);" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // Insertion Operator
    ofs << endl;
    ofs << "iluBaseCall& operator<< (iluBaseCall& call, const "
        << usageName(CppParseName(var)) << "& obj) {" << endl;
    ofs.indent++;
    ofs << "if (obj.iluGetWrapper() != NULL)  // must be a true side inout"
        << endl;
    ofs.indent++;
    ofs << "obj.iluDeleteWrapper();" << endl;
    ofs.indent--;
    ofs << "obj.iluSetWrapper(new iluObjectWrapper(" << endl;
    ofs.indent++;
    ofs << "obj.iluGetObjectPointer()," << endl;
    ofs << CppGen_(Bool)::value(ILUCPP_FALSE) << "," << endl;
    ofs << "((obj.iluGetObjectPointer() == NULL)" << endl;
    ofs.indent++;
    ofs << "? " << name() << "::iluGetILUClassRecord()" << endl;
    ofs << ": " << "NULL)));" << endl;
    ofs.indent--; ofs.indent--;
    ofs << "iluObjectWrapper* wrapper = obj.iluGetWrapper();" << endl;
    ofs << "call << *wrapper;" << endl;
    ofs << "wrapper->m_b_do_refcount_decrement = " << CppGen_(Bool)::value(ILUCPP_FALSE) << ";" << endl;
    ofs << "return (call);" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    //Extraction operator
    ofs << endl;
    ofs << "iluBaseCall& operator>> (iluBaseCall& call, "
        << usageName(CppParseName(var)) << "& obj) {" << endl;
    ofs.indent++;
    ofs << "if (obj.iluGetWrapper() != NULL) {  // must be a surrogate side inout"
        << endl;
    ofs.indent++;
    ofs << "obj.iluDeleteWrapper();" << endl;
    ofs << "obj = NULL; // force a release since the var's in control of the "
        << "refcount" << endl;
    ofs.indent--;
    ofs << "};"  << endl;
    ofs << "obj.iluSetWrapper(new iluObjectWrapper(" << endl;
    ofs.indent++;
    ofs << CppGen_(Bool)::value(ILUCPP_FALSE) << "," << endl;
    ofs << name() << "::iluGetILUClassRecord()));" << endl;
    ofs.indent--;
    ofs << "iluObjectWrapper* wrapper = obj.iluGetWrapper();" << endl;
    ofs << "call >> *wrapper;" << endl;
    ofs << "obj = " << CppGen_(Cast)::staticCast(
        usageName(CppParseName(ptr)),
        "wrapper->m_pv_iluobject") << ";" << endl;
    ofs << "wrapper->m_b_do_refcount_decrement = " << CppGen_(Bool)::value(ILUCPP_FALSE) << ";" << endl;
    ofs << "return (call);" << endl;
    ofs.indent--;
    ofs << "}" << endl;

	return ofs;
};


// Called for each INTERFACE seen by the parser; generates the actual stubs


CppParseStream(ofstream) & 
CppGen(Interface)::
_commonImpl (CppParseStream(ofstream) & ofs) {

// TMP 6/14	CppParse(ObjectListIter) objectListIter(objects());
    CppParse(ObjectListIter) objectListIter(objects());  // TMP 6/14: NEW
	const CppGen_(Object) * object;

	CppParse(ExceptionListIter) exceptionListIter(exceptions());
    CppParse(ExceptionListIter) importedExceptionListIter(importedExceptions());  // TMP 6/14: NEW
    const CppParse(Exception) * ex;

	CppParse(TypeListIter) typeListIter(types());
    const CppGen(Type) * type;

	CppParseName(TempName) initialized("_initialized", this);
	CppParseName(TempName) initialization_function_list(
		"_initialization_function_list",
		this);


	// Start the actual generation for the stubs; for most of the "common" stubs, this
	// is fairly cookie-cutter code

	ofs << "#include \"" << localName() << "-cpp.hpp\"" << endl;
    ofs << "#include \"optionaltemplates.hpp\"  // TMP 7/19" << endl;
	ofs << endl;

	ofs << "//////////////////////////////////////////////////////////////////////" << endl;
	ofs << "// globals & static members" << endl;
	ofs << endl;

	// Output the array of exception holders (they contain 0 in the generated code at this point)

// TMP 6/15    if (exceptions().count() > 0) {
    if (exceptions().count() > 0 || importedExceptions().count() > 0) {  // TMP 6/15: NEW
        ofs << "// exceptions vector" << endl;
        ofs << "static iluException interface_exceptions[] = {" << endl;
        ofs.indent++;
        while ((ex = exceptionListIter.next()) != NULL)
// TMP 6/14            ofs << "(iluException) 0,\t//" << ex->localName() << "exception" << endl;
            ofs << "(iluException) 0,  // " << ex->name(CppGen_(period_key)) << endl;  // TMP 6/14: NEW
        while ((ex = importedExceptionListIter.next()) != NULL)  // TMP 6/15: NEW
            ofs << "(iluException) 0,  // " << ex->name(CppGen_(period_key)) << endl;  // TMP 6/15: NEW
        ofs.indent--;
        ofs << "};" << endl;
    }
    else
        ofs << "const iluException* interface_exceptions = NULL;" << endl;
	ofs << endl;
	ofs << "// list of initialization functions to call for the " << localName() << " interface" << endl;
	ofs << "iluInitializationFunctionNode* " << initialization_function_list.name() << ";" << endl;
	ofs << "int " << initialized.name() << ";" << endl;

	// Walk the object list, and output class records for OBJECT types
	while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) 
	{
		ofs << "// holds the ilu class record for " << object->name() << " objects" << endl;
		ofs << "iluClass " << object->name() << "::m_ILUClassRecord;" << endl;
		ofs << endl;
	}

	// Output initialization code for this interface
	ofs << "//////////////////////////////////////////////////////////////////////" << endl;
	ofs << "// " << localName() << " initialization" << endl;
	ofs << endl;
	ofs << commonImplIluInitialize();
	ofs << endl;
	ofs << commonImplInitializer();

	// Generate common functions for each Type

	ofs << endl;
	ofs << endl;
	typeListIter.reset();
    while ((type = CppGen_(Type)::narrow(typeListIter.next())) != NULL)
		ofs << type->commonImpl();
	ofs << endl;


	// Generate common functions for each Object

	ofs << endl;
	ofs << endl;
	objectListIter.reset();
    while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL)
		ofs << object->commonImpl();
	ofs << endl;


	// Generate classes for the exceptions

	ofs << "// Exception implementations for " << name() << endl;
	ofs << endl;
/* TMP 6/14
	exceptionListIter.reset();
	while ((ex = exceptionListIter.next()) != NULL)
        ofs << CppGen_(Exception)::narrow(ex)->commonImpl();
*/
    exceptionListIter.reset();  // TMP 6/14: NEW
	while ((ex = exceptionListIter.next()) != NULL)  // TMP 6/14: NEW
		ofs << CppGen_(Exception)::narrow(ex)->commonImpl();  // TMP 6/14: NEW

	return ofs;
}

CppParseStream(ofstream) &
CppGen(Interface)::
_commonImplIluInitialize (CppParseStream(ofstream) & ofs) {

	CppParse(ExceptionListIter) exceptionListIter(exceptions());
	CppParse(ExceptionListIter) importedExceptionListIter(importedExceptions());
// TMP 6/14	const CppParse(Exception) * ex;
    const CppGen_(Exception) * ex;  // TMP 6/14: NEW
// TMP 6/14	CppParse(ObjectListIter) objectListIter(objects());
    CppParse(ObjectListIter) objectListIter(objects());  // TMP 6/14: NEW
	const CppGen_(Object) * object;

    // begin function
    ofs << "void" << endl;
    ofs << CppParseName(TempName)("iluInitialize", this).name() << " () {" << endl;
	ofs << endl;

	// begin if
    ofs << "if (!" << CppParseName(TempName)("_initialized", this).localName() << ") {" << endl;
	ofs.indent++;

    // declare mutex
    ofs << "iluMutexer _mutex(iluCppInternal::sm_object_type_mutex);" << endl;

	// define exceptions belonging to this interface
    exceptionListIter.reset();
// TMP 6/14    while ((ex = exceptionListIter.next()) != NULL)
    while ((ex = CppGen_(Exception)::narrow(exceptionListIter.next())) != NULL)  // TMP 6/14: NEW
	{
/* TMP 6/14
		ofs << "interface_exceptions[_ilu_nsconst_" << localName() << "_" << ex->name(CppGen_(underscore_key), this)
			<< "_index] = iluCppInternal::iluDefineException(" << endl;
*/
        ofs << "interface_exceptions[";  // TMP 6/14
        ex->indexName(this, ofs);  // TMP 6/14
	    ofs << "] = iluCppInternal::iluDefineException(" << endl;  // TMP 6/14
        ofs.indent++;
        ofs << "\"" << name(CppGen_(period_key)) << "\"," << endl;
        ofs << "\"" << ex->simpleName() << "\"," << endl;
        if (ex->value() == NULL)
            ofs << "\"NULL\""  << endl;
        else
            ofs << "\"" << ex->value()->type()->uid() << "\"" << endl;
        ofs.indent--;
        ofs << ");" << endl;
		// TEMP: We may have to replace the name and/or simpleName calls above with
		// something else when ILU understands nested interfaces.
	}

	// define exceptions imported from other interfaces
    importedExceptionListIter.reset();  // TMP 6/15: NEW
    while ((ex = CppGen_(Exception)::narrow(importedExceptionListIter.next())) != NULL)  // TMP 6/15: NEW
	{
        ofs << "interface_exceptions[";  // TMP 6/15: NEW
        ex->indexName(this, ofs);  // TMP 6/15: NEW
	    ofs << "] = iluCppInternal::iluDefineException(" << endl;  // TMP 6/15: NEW
        ofs.indent++;  // TMP 6/15: NEW
        ofs << "\"" << ex->scope()->name(CppGen_(period_key)) << "\"," << endl;  // TMP 6/15: NEW
        ofs << "\"" << ex->simpleName() << "\"," << endl;  // TMP 6/15: NEW
        if (ex->value() == NULL)  // TMP 6/15: NEW
            ofs << "\"NULL\""  << endl;  // TMP 6/15: NEW
        else  // TMP 6/15: NEW
            ofs << "\"" << ex->value()->type()->uid() << "\"" << endl;  // TMP 6/15: NEW
        ofs.indent--;  // TMP 6/15: NEW
        ofs << ");" << endl;  // TMP 6/15: NEW
		// TEMP: We may have to replace the name and/or simpleName calls above with  // TMP 6/15: NEW
		// something else when ILU understands nested interfaces.  // TMP 6/15: NEW
	}  // TMP 6/15: NEW

	// initialize all objects
	objectListIter.reset();
	while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) 
		ofs << object->localName() << "::iluInitialize();" << endl;


    // output ifdef conditionalized code to do the type registration needed for IIOP

	ofs << endl << "#ifdef IIOP_PROTOCOL" << endl;
	ofs << "{" << endl << "ILUCPP_BOOL b_new_registration;" << endl;
	ofs << "iluType a_type;" << endl << endl;

	// get an iterator over the list of types for this interface
// TMP 6/14	CppParse(TypeListIter) interface_type_iterator(types());
    CppParse(TypeListIter) interface_type_iterator(types());  // TMP 6/14: NEW
	const CppGen_(Type) * p_type;


	// iterate over all the types in the interface
	while ((p_type = CppGen(Type)::narrow(interface_type_iterator.next())) != NULL) {
	  p_type->registerType(ofs);
	}

	ofs << "}" << endl << "#endif // IIOP_PROTOCOL" << endl << endl;


    // set initialization flag to TRUE
    ofs << CppParseName(TempName)("_initialized", this).localName() << " = "
        << CppGen_(Bool)::value(ILUCPP_TRUE) << ";" << endl;

	// end if
    ofs.indent--;
	ofs << "}" << endl;

	// call initialization functions
	ofs << "iluCppInternal::iluCallInitializationFunctions(&"
        << CppParseName(TempName)("_initialization_function_list", this).localName() << ");" << endl;

    // end function
    ofs.indent--;
	ofs << "}" << endl;

	return ofs;
};

CppParseStream(ofstream) &
CppGen(Interface)::
_commonImplInitializer (CppParseStream(ofstream) & ofs) {

    CppParseName(TempName) initializer("_initializer", this);

    // initializer instance
    ofs << initializer.name() << " " << initializer.name() << "::instance;" << endl;

    // constructor
    ofs << endl;
    ofs << initializer.name() << "::" << endl;
    ofs << initializer.localName() << " () {" << endl;
    ofs.indent++;
    ofs << "iluCppRuntime::iluAddInitializationFunction("
        << CppParseName(TempName)("iluInitialize", this).localName() << ");" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // ensure instantiation function
    ofs << endl;
    ofs << "void *" << endl;
    ofs << initializer.name() << "::" << endl;
    ofs << "ensure_instantiation () {" << endl;
    ofs.indent++;
    ofs << "return this;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    return ofs;
};


CppParseStream(ofstream) & 
CppGen(Interface)::
_commonDef (CppParseStream(ofstream) & ofs) {

// TMP 6/14  CppParse(TypeListIter) typeListIter(types());
  CppParse(TypeListIter) typeListIter(types());  // TMP 6/14: NEW
// TMP 6/14  CppParse(ObjectListIter) objectListIter(objects());
  CppParse(ObjectListIter) objectListIter(objects());  // TMP 6/14: NEW
  CppParse(ImportListIter) importListIter(imports());
  const CppGen_(Type) * type;
  const CppGen_(Object) * object;
  const CppParse(Import) * import;
  unsigned exceptionNum = 0;  // TMP 6/14

  // define preprocessor symbol to prevent multiple inclusions
  ofs << "#ifndef __" << localName() << "_cpp_hpp_" << endl;
  ofs << "#define __" << localName() << "_cpp_hpp_" << endl;
  ofs << endl;

  // generate #include's
  ofs << "#include <corba.hpp>" << endl;
  while ((import = importListIter.next()) != NULL) {  // TMP 6/12: NEW
      if (strcmp("ilu", import->baseName()) == 0)
          continue;
      ofs << "#include \"" << import->baseName() << "-cpp.hpp\"" << endl;  // TMP 6/12: NEW
  }
  ofs << "#include \"optionaltemplates.hpp\"  // TMP 7/20: For _var typedefs" << endl;
// TMP 6/12  ofs << "// start the module scope" << endl;

  // begin namespace
  ofs << endl;
  ofs << CppGen_(Namespace)::open(localName());
  ofs.indent++;
/* TMP 6/12
  ofs << endl;
  ofs << "#define CORBA_(name) NAME_INSIDE_SCOPE(CORBA, name)" << endl;
  ofs << "#define CORBA(name) NAME_OUTSIDE_SCOPE(CORBA, name)" << endl;
  ofs << endl;
*/

  ofs << endl;
  ofs << "/////////////////////////////////////////////" << endl;
  ofs << "// Forward declarations and typedefs" << endl;
  ofs << endl;

  
  // Forward-declare Objects
  objectListIter.reset();
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL)
      ofs << object->commonDefForward();
  ofs << endl;


  // Forward-declare non-Object Types
  typeListIter.reset();
  while ((type = CppGen_(Type)::narrow(typeListIter.next())) != NULL) {
// TMP 6/29      const CppGen_(Optional) * optional;  // TMP 6/28: NEW
      if (CppGen_(Object)::narrow(type) != NULL)  // TMP 9/6: Is this check still necessary ?
          continue;
      if (CppGen_(String)::narrow(type) != NULL) {  // TMP 4/30: quick & dirty

/* TMP 8/4
          static ReusableString const_simple_name;
          const_simple_name.strcpy("const_");
          const_simple_name.strcat(type->simpleName());
          const_name.reset(const_simple_name.str, type->scope());
*/
          ofs << "// " << type->name(CppGen_(period_key)) << endl;
          ofs << endl;
          ofs << "typedef char* " << type->localUsageName(CppParseName(returnVal)) << ";" << endl;
          ofs << "typedef const char* " << type->localUsageName(CppParseName(in)) << ";" << endl;
          ofs << "typedef " << CppParseName(CorbaString_var)()->name() << " "
              << type->localUsageName(CppParseName(var)) << ";" << endl;
          ofs << endl;
      }
      else if (CppGen_(WideString)::narrow(type) != NULL) {  // TMP 3/16: A horrible hack to get around lack of Aliases
          ofs << "// " << type->name(CppGen_(period_key)) << endl;
          ofs << endl;
          ofs << "typedef iluCharacter* " << type->localUsageName(CppParseName(returnVal)) << ";" << endl;
          ofs << "typedef const iluCharacter* " << type->localUsageName(CppParseName(in)) << ";" << endl;
          ofs << "typedef iluWString_var "
              << type->localUsageName(CppParseName(var)) << ";" << endl;
          ofs << endl;
/* TMP 6/29
      }
      else if ((optional = CppGen_(Optional)::narrow(type)) != NULL) {  // TMP 6/28: NEW: This might be better done with Aliases
          const CppParse(Type) * valueType = optional->valueType();
          static ReusableString const_optional_simple_name;
          const_optional_simple_name.strcpy("const_");
          const_optional_simple_name.strcat(optional->simpleName());
          ofs << "// " << optional->name(CppGen_(period_key)) << endl;
          ofs << endl;
          ofs << "typedef " << valueType->name(this) << (valueType->isPtr() ? " " : "* ")
              << optional->localName() << ";" << endl;
          ofs << "typedef const " << valueType->name(this) << (valueType->isPtr() ? " " : "* ")
              << CppParseName(TempName)(const_optional_simple_name.str, valueType->scope()).localName() << ";" << endl;
          ofs << endl;
*/
      };
      ofs << type->commonDefForward();
  };
  ofs << endl;

  
  // forward declare exceptions defined in this interface
  // define exception index constants
// TMP 6/14  CppParse(ExceptionListIter) exceptionListIter(exceptions());
  CppParse(ExceptionListIter) exceptionListIter(exceptions());  // TMP 6/14: NEW
  const CppGen_(Exception) * ex;
// TMP 6/14  while ((ex = CppGen_(Exception)::narrow(exceptionListIter.next())) != NULL)
// TMP 6/14	  ofs << ex->commonDefForward();
  while ((ex = CppGen_(Exception)::narrow(exceptionListIter.next())) != NULL) {  // TMP 6/14: NEW
	  ofs << ex->commonDefForward();  // TMP 6/14: NEW
      ofs << "#define "; ex->indexName(this, ofs); ofs << " " << exceptionNum++ << endl;  // TMP 6/14: NEW
      ofs << endl;  // TMP 6/15: NEW
  };  // TMP 6/14: NEW
  ofs << endl;

  // define exception index constants for imported exceptions
  CppParse(ExceptionListIter) importedExceptionListIter(importedExceptions());  // TMP 6/15: NEW
  while ((ex = CppGen_(Exception)::narrow(importedExceptionListIter.next())) != NULL) {  // TMP 6/15: NEW
      ofs << "#define "; ex->indexName(this, ofs); ofs << " " << exceptionNum++ << endl;  // TMP 6/15: NEW
      ofs << endl;  // TMP 6/15: NEW
  };  // TMP 6/15: NEW
  ofs << endl;  // TMP 6/15: NEW


  // Generate forward declarations for initialization routines

  ofs << endl;
  ofs << "/////////////////////////////////////////////" << endl;
  ofs << "// Interface initialization" << endl;
  ofs << endl;
  CppParseName(TempName) tempName;
  tempName.reset("iluInitialize", this);
  ofs << "// Declarations for initialization" << endl;
  ofs << CppGen_(Namespace)::declareExtern() << " void " << tempName.localName() << "();" << endl;
  tempName.reset("_initialized", this);
  ofs << CppGen_(Namespace)::declareExtern() << " int " << tempName.localName() << ";" << endl;
  ofs << endl;
  tempName.reset("_initialization_function_list", this);
  ofs << CppGen_(Namespace)::declareExtern() << " iluInitializationFunctionNode* " << tempName.localName() << ";" << endl;
  ofs << endl;


  // Generate definitions for all types and exceptions defined in this Interface

  ofs << endl;
  ofs << "/////////////////////////////////////////////" << endl;
  ofs << "// Type definitions" << endl;
  ofs << endl;
  typeListIter.reset();
  while ((type = CppGen_(Type)::narrow(typeListIter.next())) != NULL)
      ofs << type->commonDef();
  ofs << endl;
  ofs << endl;
  ofs << "/////////////////////////////////////////////" << endl;
  ofs << "// Object definitions" << endl;
  ofs << endl;
  objectListIter.reset();
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL)
      ofs << object->commonDef();
  ofs << endl;
  ofs << endl;
  ofs << "/////////////////////////////////////////////" << endl;
  ofs << "// Exception definitions" << endl;
  ofs << endl;
  exceptionListIter.reset();
  while ((ex = CppGen_(Exception)::narrow(exceptionListIter.next())) != NULL) {
      ofs << ex->commonDef();
	  ofs << endl;
  }
  ofs << endl;


  ofs << "////////////////////////////////////////////////////////" << endl;
  ofs << "// Initialization related" << endl;
  ofs << endl;

  // _initializer class
  CppParseName(TempName) initializer;
  initializer.reset("_initializer", this);
  ofs << "class " << initializer.localName() << " {" << endl;
  ofs.indent++;
  ofs << "public:" << endl;
  ofs.indent++;
  ofs << initializer.localName() << " ();" << endl;
  ofs << "void* ensure_instantiation ();" << endl;
  ofs << "static " << initializer.localName() << " instance;" << endl;
  ofs.indent--;
  ofs.indent--;
  ofs << "};" << endl;

  ofs << "// If you're using a C++ compiler which does not initialize all non-local" << endl;
  ofs << "// statics before running main() (or you're doing something else which" << endl;
  ofs << "// could cause an unusual initialization order), you should use" << endl;
  ofs << "// one of the following three macros to perform your initialization" << endl;
  ofs << "// rather than simply calling " << simpleName() << "::iluInitialize()" << endl;
  ofs << endl << endl;

  // For each object, output the #defines for client/server initialization

  ofs << commonDefInitMacros();

  ofs.indent--;
  ofs << CppGen_(Namespace)::close(localName());
  ofs << endl;
  ofs << endl;

  // IO operators for Objects
  objectListIter.reset();
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
      ofs << object->commonDefIOOperators();
      ofs << endl;
  };

  // IO operators for types
  typeListIter.reset();
  while ((type = CppGen_(Type)::narrow(typeListIter.next())) != NULL) {
      ofs << type->commonDefIOOperators();
      ofs << endl;
  };

  // I/O Operators for exceptions
  exceptionListIter.reset();
  while ((ex = CppGen_(Exception)::narrow(exceptionListIter.next())) != NULL) {
      ofs << ex->commonDefIOOperators();
	  ofs << endl;
  };


  ofs << "#endif" << "  // __" << localName() << "_cpp_hpp_" << endl;

  return ofs;
}

CppParseStream(ofstream) &
CppGen(Interface)::
_commonDefInitMacros (CppParseStream(ofstream) & ofs) {

    CppParseName(TempName) initializer("_initializer", this);
// TMP 6/14    CppParse(ObjectListIter) objs(objects());
    CppParse(ObjectListIter) objs(objects());  // TMP 6/14: NEW
    const CppParse(Object) * obj;
    static ReusableString objInitializer;

    // CLIENT_ONLY
    ofs << "#define ILU_INIT_" << name(CppGen_(underscore_key)) << "_CLIENT_ONLY() { \\" << endl;
    ofs.indent++;
    ofs << initializer.name() << "::instance.ensure_instantiation(); \\" << endl;
    objs.reset();
    while ((obj = objs.next()) != NULL) {
        objInitializer.strcpy(obj->CppParse(Type)::simpleName());
        objInitializer.strcat("_initializer");
        ofs << CppParseName(TempName)(objInitializer.str, this).name(CppGen_(surrogate_key))
            << "::_instance.ensure_instantiation(); \\" << endl;
    };
    ofs.indent--;
    ofs << "}" << endl;

    // SERVER_ONLY
    ofs << endl;
    ofs << "#define ILU_INIT_" << name(CppGen_(underscore_key)) << "_SERVER_ONLY() { \\" << endl;
    ofs.indent++;
    ofs << initializer.name() << "::instance.ensure_instantiation(); \\" << endl;
    objs.reset();
    while ((obj = objs.next()) != NULL) {
        objInitializer.strcpy(obj->CppParse(Type)::simpleName());
        objInitializer.strcat("_initializer");
        ofs << CppParseName(TempName)(objInitializer.str, this).name(CppGen_(true_key))
            << "::_instance.ensure_instantiation(); \\" << endl;
    };
    ofs.indent--;
    ofs << "}" << endl;

    // CLIENT_SERVER
    ofs << endl;
    ofs << "#define ILU_INIT_" << name(CppGen_(underscore_key)) << "_CLIENT_SERVER() { \\" << endl;
    ofs.indent++;
    ofs << initializer.name() << "::instance.ensure_instantiation(); \\" << endl;
    objs.reset();
    while ((obj = objs.next()) != NULL) {
        objInitializer.strcpy(obj->CppParse(Type)::simpleName());
        objInitializer.strcat("_initializer");
        ofs << CppParseName(TempName)(objInitializer.str, this).name(CppGen_(surrogate_key))
            << "::_instance.ensure_instantiation(); \\" << endl;
        ofs << CppParseName(TempName)(objInitializer.str, this).name(CppGen_(true_key))
            << "::_instance.ensure_instantiation(); \\" << endl;
    };
    ofs.indent--;
    ofs << "}" << endl;

    return ofs;
}


// This method is called to output code in the header file for each PROCEDURE in an OBJECT

CppParseStream(ofstream) &
CppGen(Procedure)::
_commonDef (CppParseStream(ofstream) & ofs) {
    CppParse(ArgumentListIter) args(arguments());
    const CppGen_(ReturnVal) * return_val = CppGen_(ReturnVal)::narrow(returnVal());
    ILUCPP_BOOL firstArg = ILUCPP_TRUE;
    const CppGen_(Argument) * arg;
    ofs << "virtual" << endl;
    if (return_val->type() == NULL)
        ofs << "void" << endl;
    else
        ofs << return_val->type()->usageName(CppParseName(returnVal), scope()) << endl;
    ofs << localName() << " (";
    ofs.indent++;
    while ((arg = CppGen_(Argument)::narrow(args.next())) != NULL) {
        if (! firstArg)
            ofs << ", ";
        ofs << endl;
        ofs << arg->type()->usageName(arg->usage(), scope()) << " ";
        ofs << arg->localName();
        firstArg = ILUCPP_FALSE;
    };
    ofs << endl;
    ofs.indent--;
    ofs << ") = 0;" << endl;
    return ofs;
}


// This method is called to output code in the .cpp file for each PROCEDURE in an OBJECT


CppParseStream(ofstream) &
CppGen(Procedure)::
_commonImplDefineMethod (CppParseStream(ofstream) & ofs) {

	CppParse(ExceptionListIter) exceptionIter(exceptions());
	CppParse(ArgumentListIter) argumentIter(arguments());
	const int nExceptions = exceptions().count();
// TMP 6/14	const CppParse(Exception) * ex;
    const CppGen_(Exception) * ex;  // TMP 6/14: NEW
	const CppParse(Argument) * argument;
    unsigned argIndex = 0;
	
	if (nExceptions > 0)
        ofs << "iluException " << simpleName() << "_exception_array"
        << "[" << nExceptions << "];" << endl;
    else
        ofs << "iluException* " << simpleName() << "_exception_array"
        << " = NULL;" << endl;
	int exIndex = 0;  // index into exception array
// TMP 6/14	while ((ex = exceptionIter.next()) != NULL)	{
    while ((ex = CppGen_(Exception)::narrow(exceptionIter.next())) != NULL)	{  // TMP 6/14: NEW
/* TMP 6/14
		ofs << localName() << "_exception_array[" << exIndex << "] = "
			<< "interface_exceptions[_ilu_nsconst_"
			<< ex->name(CppGen_(underscore_key)) << "_index];" << endl;
*/
        ofs << localName() << "_exception_array[" << exIndex << "] = interface_exceptions[";  // TMP 6/14: NEW
        ex->indexName(scope(), ofs);  // TMP 6/14: NEW
        ofs << "];" << endl;  // TMP 6/14: NEW
		exIndex++;
	};

	// define method
    ofs << "_method = iluCppInternal::iluDefineMethod(" << endl;
    ofs.indent++;
    ofs << "m_ILUClassRecord," << endl;
	ofs << methodNum() << ",  // method index" << endl;
// TMP 9/18	ofs << "\"" << localName() << "\", // name" << endl;
	ofs << "\"" << baseName() << "\", // name" << endl;  // TMP 9/18: NEW
	ofs << protocolId() << ",  //method ID" << endl;
    ofs << CppGen_(Bool)::value(functional()) << ",  // functional ?" << endl;
    ofs << CppGen_(Bool)::value(asynch()) << ",  // asynchronous ?" << endl;
	ofs << nExceptions << ",  // number of exceptions" << endl;
	ofs << simpleName() << "_exception_array," << endl;
    ofs << arguments().count() << ",  // number of arguments" << endl;
    if (returnVal()->type() == NULL)
        ofs << "NULL  // return type ID" << endl;
    else
        ofs << "\"" << returnVal()->type()->uid() << "\"  // return type ID" << endl;
	ofs.indent--;
	ofs << ");" << endl;

    // define method args
    while ((argument = argumentIter.next()) != NULL) {
        const char * usage =
            argument->usage() == CppParseName(in) ? "ilu_In" :
            argument->usage() == CppParseName(out) ? "ilu_Out" :
            "ilu_InOut";
        ofs << "iluCppInternal::iluDefineMethodArg("
            << "_method, " << argIndex << ", \"" << argument->simpleName() << "\", "
            << CppGen_(Bool)::value(argument->sibling()) << ", "
            << usage << ", \"" << argument->type()->uid() << "\""
            << ");" << endl;
        argIndex++;
    };

	return ofs;
}


CppParseStream(ofstream) &
CppGen(Exception)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;

    ofs << "class " << localName() << ";" << endl;
/* TMP 6/14
    ofs << "#define _ilu_nsconst_" << name(CppGen_(underscore_key)) 
        << "_index " << "\t" << exceptionNum() << endl;

    ofs << endl;
*/
    return ofs;
}

CppParseStream(ofstream) &
CppGen(Exception)::
_commonDef (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
	
    // begin class
    ofs << "class " << localName() << ": public " << CppParseName(CorbaUserException)()->name() << " {" << endl;
    ofs << endl;
    ofs.indent++;
    ofs << "public:" << endl;
    ofs.indent++;
    ofs << endl;

    // default constructor
    ofs << localName() << " () {};" << endl;

    // construct from value
    if (value() != NULL)
// TMP 9/9        ofs << localName() << " (" << value()->type()->usageName(CppParseName(in), this) << " _val_) : _val(_val_) {};" << endl;
        ofs << localName() << " (" << value()->type()->usageName(CppParseName(in), this) << ");" << endl;  // TMP 9/9: NEW

    // copy constructor
	ofs << "/* TMP" << endl;
    ofs << localName() << " (const " << localName() << "&);" << endl;
	ofs << "*/" << endl;

    // destructor
    ofs << "~" << localName() << " ();" << endl;

    // assignment operator
	ofs << "/* TMP" << endl;
    ofs << localName() << "& operator= (const " << localName() << "&);" << endl;
	ofs << "*/" << endl;

    // value accessor
    if (value() == NULL) {
        ofs << "void _value () {};" << endl;
        ofs << "void _value () const {};" << endl;
    }
    else {
        ofs << value()->type()->usageName(CppParseName(recordMember), this)
            << "& _value () { return _val; };" << endl;
        ofs << "const " << value()->type()->usageName(CppParseName(recordMember), this) <<
            "& _value () const { return _val; };" << endl;
    };

    // data member
    if (value() != NULL) {
        ofs << endl;
        ofs.indent--;
        ofs << "public:" << endl;
        ofs.indent++;
        ofs << endl;
        ofs << value()->type()->usageName(CppParseName(recordMember), this) << " _val;" << endl;
    };

    // end class
    ofs << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "};" << endl;

  return ofs;
};

CppParseStream(ofstream) & 
CppGen(Exception)::
_commonImpl (CppParseStream(ofstream) & ofs) {

	ofs << "/////////////////////////////////////////////////" << endl;
	ofs << "// " << localName() << " member functions" << endl;

    // copy constructor
	ofs << "/* TMP" << endl;
	ofs << endl;
    ofs << name() << "::" << endl;
    ofs << localName() << " (const " << localName() << "& _exception) {" << endl;
    if (value() != NULL) {
        ofs.indent++;
        CppGen_(Type)::narrow(value()->type())->assignValue("_val", "_exception._val", ofs);
        ofs.indent--;
    };
    ofs << "}" << endl;
	ofs << "*/" << endl;

    // constructor from value
    if (value() != NULL) {
		// function type, scope, and prototype
		ofs << endl;
		ofs << name() << "::" << endl;
        ofs << localName() << " (" << value()->type()->usageName(CppParseName(in), this) << " _val_) {" << endl;  // TMP 9/9: NEW
		ofs.indent++;
		// assign value
		CppGen_(Type)::narrow(value()->type())->assignValue("_val", "_val_", ofs);
		// end constructor
		ofs.indent--;
		ofs << "}" << endl;
    };

    // destructor
	ofs << endl;
    ofs << name() << "::" << endl;
    ofs << "~" << localName() << " () {" << endl;
    ofs << "}" << endl;

    // assignment operator
	ofs << "/* TMP" << endl;
	ofs << endl;
    ofs << name() << "&" << endl;
    ofs << name() << "::" << endl;
    ofs << "operator= (const " << localName() << "& _exception) {" << endl;
    ofs.indent++;
    if (value() != NULL) {
        ofs << "if (this != &_exception)" << endl;
        ofs.indent++;
        CppGen_(Type)::narrow(value()->type())->assignValue("_val", "_exception._val", ofs);
        ofs.indent--;
    };
    ofs << "return *this;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
	ofs << "*/" << endl;

    // IO operators
    ofs << endl;
    ofs << commonImplIOOperators();

	return ofs;
}


CppParseStream(ofstream) &
CppGen(IDLException)::
_commonDef (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
	
    // begin class
    ofs << "class " << localName()
// TMP 8/29        << ": public " << CppGen_(Record)::narrow(record())->name(scope()) << ", "
        << ": public " << value()->type()->name(scope()) << ", "  // TMP 8/29: NEW
        << "public " << CppParseName(CorbaUserException)()->name() << " {" << endl;
    ofs << endl;
    ofs.indent++;
    ofs << "public:" << endl;
    ofs.indent++;
    ofs << endl;

    // default constructor
    ofs << localName() << " () {};" << endl;

    // construct from member values
    if (record()->members().count() == 0)
        ofs << localName() << " () {};" << endl;
    else {
        CppParse(MemberListIter) memberListIter(record()->members());
        const CppGen_(Member) * member;
        ILUCPP_BOOL firstMember = ILUCPP_TRUE;
        ofs << localName() << " (" << endl;
        ofs.indent++;
        while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL) {
            if (firstMember)
                firstMember = ILUCPP_FALSE;
            else
                ofs << "," << endl;
            ofs << member->type()->usageName(CppParseName(in), this) << " "
            << member->localName(CppGen_(val_key));
        };
        ofs.indent--;
        ofs << ");" << endl;
    };

    // copy constructor
	ofs << "/* TMP" << endl;
    ofs << localName() << " (const " << localName() << "&);" << endl;
	ofs << "*/" << endl;

    // destructor
    ofs << "~" << localName() << " ();" << endl;

    // assignment operator
	ofs << "/* TMP" << endl;
    ofs << localName() << "& operator= (const " << localName() << "&);" << endl;
	ofs << "*/" << endl;

    // value accessor
    ofs << record()->name(scope()) << "& _value () { return *this; };" << endl;
// TMP 8/29    ofs << "const " << record()->name(scope()) << "& _value () const { return *this; };" << endl;
    ofs << "const " << value()->type()->name(scope()) << "& _value () const { return *this; };" << endl;  // TMP 8/29: NEW

    // end class
    ofs << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "};" << endl;

  return ofs;
};

CppParseStream(ofstream) &
CppGen(IDLException)::
_commonImpl (CppParseStream(ofstream) & ofs) {

	ofs << "/////////////////////////////////////////////////" << endl;
	ofs << "// " << localName() << " member functions" << endl;

    // copy constructor
	ofs << "/* TMP" << endl;
	ofs << endl;
    ofs << name() << "::" << endl;
    ofs << localName() << " (const " << localName() << "& _exception) {" << endl;
    if (value() != NULL) {
        ofs.indent++;
        CppGen_(Type)::narrow(value()->type())->assignValue("_value()", "_exception._value()", ofs);
        ofs.indent--;
    };
    ofs << "}" << endl;
	ofs << "*/" << endl;

    // constructor from member values
	ofs << endl;
    ofs << name() << "::" << endl;
    if (record()->members().count() == 0) {
		// no members, so nothing to do...
        ofs << localName() << " () {};" << endl;
	}
    else {
		// function type, scope, and prototype
        CppParse(MemberListIter) memberListIter(record()->members());
        const CppGen_(Member) * member;
        ILUCPP_BOOL firstMember = ILUCPP_TRUE;
        ofs << localName() << " (" << endl;
        ofs.indent++;
        while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL) {
            if (firstMember)
                firstMember = ILUCPP_FALSE;
            else
                ofs << "," << endl;
            ofs << member->type()->usageName(CppParseName(in), this) << " "
            << member->localName(CppGen_(val_key));
        };
		ofs << endl;
        ofs.indent--;
        ofs << ") {" << endl;
		ofs.indent++;
		// assign each parm to its associated member
		memberListIter.reset();
        while ((member = CppGen_(Member)::narrow(memberListIter.next())) != NULL) {
            CppGen_(Type)::narrow(member->type())->assignValue(
				member->localName(),
				member->localName(CppGen_(val_key)),
				ofs
			);
        };
		// end constructor
		ofs.indent--;
		ofs << "}" << endl;
    };

    // destructor
	ofs << endl;
    ofs << name() << "::" << endl;
    ofs << "~" << localName() << " () {" << endl;
    ofs << "}" << endl;

    // assignment operator
	ofs << "/* TMP" << endl;
	ofs << endl;
    ofs << name() << "&" << endl;
    ofs << name() << "::" << endl;
    ofs << "operator= (const " << localName() << "& _exception) {" << endl;
    ofs.indent++;
    if (value() != NULL)
        CppGen_(Type)::narrow(value()->type())->assignValue("_value()", "_exception._value()", ofs);
    ofs << "return *this;" << endl;
    ofs.indent--;
    ofs << "}" << endl;
	ofs << "*/" << endl;

    // IO operators
    ofs << endl;
    ofs << commonImplIOOperators();

	return ofs;
}

CppParseStream(ofstream) &
CppGen(IDLException)::
_commonImplIOOperators (CppParseStream(ofstream) & ofs) {

    // Sizing operator
    ofs << "iluBaseCall&" << endl;
    ofs << "operator+= (iluBaseCall& _call, const " << name() << "& _exception) {" << endl;
    ofs.indent++;
// TMP 6/14    ofs << "_call.iluSizeExceptionMode(_ilu_nsconst_" << name(CppGen_(underscore_key)) << "_index + 1);" << endl;
    if (value() != NULL)
        ofs << "_call += _exception._value();" << endl;
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // Insertion Operator
    ofs << endl;
    ofs << "iluBaseCall&" << endl;
    ofs << "operator<< (iluBaseCall& _call, const " << name() << "& _exception) {" << endl;
    ofs.indent++;
    ofs << "_call << iluSendExceptionMode;" << endl;
    if (value() != NULL)
        ofs << "_call << _exception._value();" << endl;
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // Extraction operator
    ofs << endl;
    ofs << "iluBaseCall&" << endl;
    ofs << "operator>> (iluBaseCall& _call, " << name() << "& _exception) {" << endl;
    ofs.indent++;
    if (value() != NULL)
        ofs << "_call >> _exception._value();" << endl;
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    return ofs;
};


CppParseStream(ofstream) &
CppGen(Enumeration)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;

    // forward declaration for enumeration
    ofs << "enum " << localName() << ";" << endl;

    // typedef for enumeration _var
    ofs << "typedef iluTemplatableT_var<" << localName() << "> " << localUsageName(CppParseName(var)) << ";" << endl;
    
    ofs << endl;
    return ofs;
}


CppParseStream(ofstream) &
CppGen(Enumeration)::
_commonDef (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
    
    CppParse(EnumeratorListIter) enumeratorListIter(enumerators());
    const CppParse(Enumerator) * enumerator;
    CppParseName(TempName) enumLast;
    static ReusableString enumLast_simpleName;

    if ((simpleName())[0] != '_')
        enumLast_simpleName.strcpy("_");
    else
        enumLast_simpleName.reset();
    enumLast_simpleName.strcat(simpleName());
    enumLast_simpleName.strcat("_last");
    enumLast.reset(enumLast_simpleName.str, scope());

    ofs << "enum " << localName() << " {" << endl;
    ofs.indent++;
    while ((enumerator = enumeratorListIter.next()) != NULL)
        ofs << enumerator->localName() << " = " << enumerator->id() << "," << endl;
    ofs << enumLast.localName() << " = 4294967295" << endl;
    ofs.indent--;
    ofs << "};" << endl;
    ofs << endl;
    return ofs;
}

void  // TMP 8/9: NEW
CppGen(Enumeration)::
optionalCommonDefForward (const CppParseName(TypeName) * optional, CppParseStream(ofstream) & ofs) const {

    // typedef for optional
    ofs << "typedef " << name(optional->scope()) << "* " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << name(optional->scope()) << "* "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptionalEnumerationMgrT<" << name(optional->scope()) << "> "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}


CppParseStream(ofstream) &
CppGen(Sequence)::
_commonDefForward (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;

    // Sequence
	ofs << "class " << localName() << ";" << endl;

	// Sequence _var
// TMP 9/2    ofs << "class " << localUsageName(CppParseName(var)) << ";" << endl;
    ofs << "typedef iluTemplatableSequence_var<"  // TMP 9/2: NEW
		<< localName() << ", "  // Sequence type
		<< elementType()->usageName(CppParseName(element), scope()) << "> "  // Element type
		<< localUsageName(CppParseName(var)) << ";" << endl;
    
    ofs << endl;
    return ofs;
}

void
CppGen(Sequence)::
aliasCommonDefForward (const CppParseName(TypeName) * alias, CppParseStream(ofstream) & ofs) const {

    ofs << "// " << alias->name(CppGen_(period_key)) << endl;
    ofs << endl;

    // typedef for sequence
    ofs << "typedef " << name(alias->scope()) << " " << alias->localName() << ";" << endl;

    // typedef for sequence var
    ofs << "typedef " << usageName(CppParseName(var), alias->scope()) << " "
        << alias->localUsageName(CppParseName(var)) << ";" << endl;
    ofs << endl;
}

CppParseStream(ofstream) &
CppGen(Sequence)::
_commonDef (CppParseStream(ofstream) & ofs) {

    ofs << "// " << name(CppGen_(period_key)) << endl;
    ofs << endl;
    
    // begin sequence class
    ofs << "class " << localName() << " {" << endl;
    ofs.indent++;
    ofs << endl;
    ofs << "public:" << endl;
    ofs.indent++;

    // constructors & destructor
    ofs << endl;
    ofs << localName() << " ();" << endl;
    if (limit() == 0)   {// unbounded
        ofs << localName() << " (" << CppParseName(CorbaULong)()->name() << " max);" << endl;
        ofs << localName() << " ("
            << CppParseName(CorbaULong)()->name() << " max, "
            << CppParseName(CorbaULong)()->name() << " length, "
            << dataElementType() << "* data, "
            << CppParseName(CorbaBoolean)()->name() << " release = " << CppGen_(Bool)::value(ILUCPP_FALSE) << ");" << endl;
    }
    else {
        ofs << localName() << " ("
            << CppParseName(CorbaULong)()->name() << " length, "
            << dataElementType() << "* data, "
            << CppParseName(CorbaBoolean)()->name() << " release = " << CppGen_(Bool)::value(ILUCPP_FALSE) << ");" << endl;
    };
    ofs << localName() << " (const " << localName() << "&);" << endl;
    ofs << "~" << localName() << " ();" << endl;
    
    // assignment operator
    ofs << endl;
    ofs << localName() << "&" << endl;
    ofs << "operator = (const " << localName() << "&);" << endl;

    // maximum accessor function
    ofs << endl;
    ofs << CppParseName(CorbaULong)()->name() << endl;
    ofs << "maximum () const;" << endl;

    // length accessor function
    ofs << endl;
    ofs << CppParseName(CorbaULong)()->name() << endl;
    ofs << "length () const;" << endl;

    // set length function
    ofs << endl;
    ofs << "void" << endl;
    ofs << "length (" << CppParseName(CorbaULong)()->name() << ");" << endl;

    // left-side indexing operator
    ofs << endl;
    ofs << elementType()->usageName(CppParseName(element), scope()) << "&" << endl;
    ofs << "operator [] (" << CppParseName(CorbaULong)()->name() << ");" << endl;

    // right-side indexing operatorusageName(CppParseName(element), scope)
    ofs << endl;
    ofs << "const " << elementType()->usageName(CppParseName(element), scope()) << "&" << endl;
    ofs << "operator [] (" << CppParseName(CorbaULong)()->name() << ") const;" << endl;

    // allocbuf function
    ofs << endl;
    ofs << "static" << endl;
    ofs << dataElementType() << "*" << endl;
    ofs << "allocbuf (" << CppParseName(CorbaULong)()->name() << " num_elements);" << endl;

    // freebuf function
    ofs << endl;
    ofs << "static" << endl;
    ofs << "void" << endl;
    ofs << "freebuf (" << dataElementType() << "*" << ");" << endl;

    // surrogate side cleanup function
    if (needsSurrogateSideCleanup()) {
        ofs << endl;
        ofs << "// For ILU stub use only" << endl;
        ofs << "void" << endl;
        ofs << "_surrogateSideCleanup () const;" << endl;
    };

    // begin private section
    ofs << endl;
    ofs.indent--;
    ofs << "private:" << endl;
    ofs.indent++;

    // data members
    ofs << endl;
    ofs << CppParseName(CorbaULong)()->name() << " _maximum;" << endl;
    ofs << CppParseName(CorbaULong)()->name() << " _length;" << endl;
    ofs << dataElementType() << "* _buffer;" << endl;
    if (needVarBuffer())
        ofs << elementType()->usageName(CppParseName(element), scope()) << "* _varBuffer;" << endl;
    ofs << CppParseName(CorbaBoolean)()->name() << " _release;" << endl;

    // end sequence class
    ofs << endl;
    ofs.indent--;
    ofs.indent--;
    ofs << "};" << endl;
    ofs << endl;

/* TMP 9/2
    // begin sequence _var class
    ofs << "class " << localUsageName(CppParseName(var))
        << ": public iluTemplatableT_var<" << localName() << "> {" << endl;
    ofs.indent++;
    ofs << "public:" << endl;
    ofs.indent++;

    // left-side indexing operator
    ofs << endl;
    ofs << elementType()->usageName(CppParseName(element), scope()) << "&" << endl;
    ofs << "operator [] (" << CppParseName(CorbaULong)()->name() << " index) {" << endl;
    ofs.indent++;
    ofs << "return (*m_ptr)[index];" << endl;
    ofs.indent--;
    ofs << "};" << endl;

    // right-side indexing operator
    ofs << endl;
    ofs << "const " << elementType()->usageName(CppParseName(element), scope()) << "&" << endl;
    ofs << "operator [] (" << CppParseName(CorbaULong)()->name() << " index) const {" << endl;
    ofs.indent++;
    ofs << "return (*m_ptr)[index];" << endl;
    ofs.indent--;
    ofs << "};" << endl;

    // end sequence _var class
    ofs.indent--;
    ofs.indent--;
    ofs << "};" << endl;
    ofs << endl;
TMP 9/2 */

    return ofs;
}

CppParseStream(ofstream) &
CppGen(Sequence)::
_commonDefIOOperators (CppParseStream(ofstream) & ofs) {
    ofs << "iluBaseCall& operator+= (iluBaseCall&, "
        << "const " << name() << "&);" << endl;
    ofs << "iluBaseCall& operator<< (iluBaseCall&, "
        << "const " << name() << "&);" << endl;
    ofs << "iluBaseCall& operator>> (iluBaseCall&, "
        << name() << "&);" << endl;
    return ofs;
};

CppParseStream(ofstream) &
CppGen(Sequence)::
_commonImpl (CppParseStream(ofstream) & ofs) {

    static ReusableString maximum;
    if (limit() == 0)  // unbound
        maximum.strcpy("_maximum");
    else {
        maximum.reset();
        maximum.ucat(limit());
    };

    // default constructor
    ofs << name() << "::" << endl;
    ofs << localName() << " ()" << endl;
    ofs.indent++;
    if (limit() == 0) {  // unbounded
        ofs << ": _maximum(0), _length(0), _buffer(NULL), "
            << (needVarBuffer() ? "_varBuffer(NULL), " : "")
            << "_release(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ")" << endl;
    }
    else {
        ofs << ": _maximum(" << maximum.str << "), _length(0), "
            << "_release(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ")" << endl;
    };
    ofs.indent--;
    ofs << "{" << endl;
    if (limit() != 0) {  // bounded
        ofs.indent++;
        ofs << "_buffer = allocbuf(" << maximum.str << ");" << endl;
        if (needVarBuffer())
            ofs << "_varBuffer = new " << elementType()->usageName(CppParseName(element), scope())
            << "[" << maximum.str << "];" << endl;
        ofs.indent--;
    };
    ofs << "}" << endl;

    // max length constructor
    if (limit() == 0) {  // unbounded
        ofs << endl;
        ofs << name() << "::" << endl;
        ofs << localName() << " (" << CppParseName(CorbaULong)()->name() << " _max)" << endl;
        ofs.indent++;
        ofs << ": _maximum(_max), _length(0), _buffer(allocbuf(_max)), ";
        if (needVarBuffer()) {
// TMP 9/9            ofs << "_varBuffer(new " << dataElementType() << "[" << maximum.str << "]), ";
            ofs << "_varBuffer(new " << elementType()->usageName(CppParseName(element), scope())  // TMP 9/9
				<< "[" << maximum.str << "]), ";  // TMP 9/9: NEW
		};
        ofs << "_release(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ")" << endl;
        ofs.indent--;
        ofs << "{" << endl;
        ofs << "}" << endl;
    };

    // data buffer constructor
    ofs << endl;
    ofs << name() << "::" << endl;
    ofs << localName() << " (";
    if (limit() == 0)  // unbounded
        ofs << CppParseName(CorbaULong)()->name() << " _max, ";
    ofs << CppParseName(CorbaULong)()->name() << " _len, "
        << dataElementType() << "* _data, "
        << CppParseName(CorbaBoolean)()->name() << " release)" << endl;
    ofs.indent++;
    ofs << ": ";
    if (limit() == 0)  // unbounded
        ofs << "_maximum(_max), ";
    else
        ofs << "_maximum(" << maximum.str << "), ";
    ofs << "_length(_len), _buffer(_data), _release(release)" << endl;
    ofs.indent--;
    ofs << "{" << endl;
    ofs.indent++;
    if (limit() != 0) {  // bounded
        ofs << "if (_length > " << maximum.str << ") {" << endl;
        ofs.indent++;
        ofs << "// behavior undefined by CORBA 2.0 spec, but better safe that sorry !" << endl;
        ofs << CppParseName(CorbaUNKNOWN)()->name() << " _exception(0, "
            << CppParseName(CorbaCOMPLETED_NO)()->name() << ");" << endl;
        ofs << "throw _exception;" << endl;
        ofs.indent--;
        ofs << "};" << endl;
    };
    if (needVarBuffer()) {
        ofs << "_varBuffer = new " << elementType()->usageName(CppParseName(element), scope())
            << "[" << maximum.str << "];" << endl;
        ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = 0; _index < "
            << maximum.str << "; _index++) {" << endl;
        ofs.indent++;
        ofs << "_varBuffer[_index].iluSetRelease(release);" << endl;
        ofs << "_varBuffer[_index] = _data[_index];" << endl;
        ofs.indent--;
        ofs << "};" << endl;
    };
    ofs.indent--;
    ofs << "}" << endl;

    // copy constructor
    ofs << endl;
    ofs << name() << "::" << endl;
    ofs << localName() << " (const " << name(scope()) << "& _seq)" << endl;
    ofs.indent++;
    ofs << ": _maximum(_seq._maximum), _length(_seq._length), _release(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ")" << endl;
    ofs.indent--;
    ofs << "{" << endl;
    ofs.indent++;
    ofs << "_buffer = allocbuf(" << maximum.str << ");" << endl;
    if (needVarBuffer())
        ofs << "_varBuffer = new " << elementType()->usageName(CppParseName(element), scope())
        << "[" << maximum.str << "];" << endl;
    ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = 0; _index < _length; _index++) {" << endl;
    ofs.indent++;
    ofs << "_buffer[_index] = _seq._buffer[_index];" << endl;
    if (needVarBuffer())
        ofs << "_varBuffer[_index] = _seq._varBuffer[_index];" << endl;
    ofs.indent--;
    ofs << "};" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // destructor
    ofs << endl;
    ofs << name() << "::" << endl;
    ofs << "~" << localName() << " () {" << endl;
    ofs.indent++;
    ofs << "if (_buffer != NULL && _release)" << endl;
    ofs.indent++;
    ofs << "freebuf(_buffer);" << endl;
    ofs.indent--;
    if (needVarBuffer())
        ofs << "delete [] _varBuffer;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // assignment operator
    ofs << endl;
    ofs << name() << "&" << endl;
    ofs << name() << "::" << endl;
    ofs << "operator = (const " << localName() << "& _seq) {" << endl;
    ofs.indent++;
    ofs << "if (this == &_seq)" << endl;
    ofs.indent++;
    ofs << "return *this;" << endl;
    ofs.indent--;
    ofs << "if (_buffer != NULL && _release)" << endl;
    ofs.indent++;
    ofs << "freebuf(_buffer);" << endl;
    ofs.indent--;
    if (needVarBuffer())
        ofs << "delete [] _varBuffer;" << endl;
    ofs << "_maximum = _seq._maximum;" << endl;
    ofs << "_buffer = allocbuf(_maximum);" << endl;
    if (needVarBuffer())
        ofs << "_varBuffer = new " << elementType()->usageName(CppParseName(element), scope())
        << "[" << maximum.str << "];" << endl;
    ofs << "_release = " << CppGen_(Bool)::value(ILUCPP_TRUE) << ";" << endl;
    ofs << "_length = _seq._length;" << endl;
    ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = 0; _index < _length; _index++) {" << endl;
    ofs.indent++;
    ofs << "_buffer[_index] = _seq._buffer[_index];" << endl;
    if (needVarBuffer())
        ofs << "_varBuffer[_index] = _seq._varBuffer[_index];" << endl;
    ofs.indent--;
    ofs << "};" << endl;
    ofs << "return *this;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // maximum accessor
    ofs << endl;
    ofs << CppParseName(CorbaULong)()->name() << endl;
    ofs << name() << "::" << endl;
    ofs << "maximum () const {" << endl;
    ofs.indent++;
    ofs << "return _maximum;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // length accessor
    ofs << endl;
    ofs << CppParseName(CorbaULong)()->name() << endl;
    ofs << name() << "::" << endl;
    ofs << "length () const {" << endl;
    ofs.indent++;
    ofs << "return _length;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // begin set length function
    ofs << endl;
    ofs << "void" << endl;
    ofs << name() << "::" << endl;
    ofs << "length (" << CppParseName(CorbaULong)()->name() << " _len) {" << endl;
    ofs.indent++;

    // body of set length for unbounded sequences
    if (limit() == 0) {
        ofs << "if (_len <= _maximum)" << endl;
        ofs.indent++;
        ofs << "_length = _len;" << endl;
        ofs.indent--;
        ofs << "else {" << endl;
        ofs.indent++;
        ofs << dataElementType() << "* _oldBuffer = _buffer;" << endl;
        if (needVarBuffer())
            ofs << elementType()->usageName(CppParseName(element), scope()) << "* _oldVarBuffer = _varBuffer;" << endl;
        ofs << CppParseName(CorbaULong)()->name() << " _oldLength = _length;" << endl;
        ofs << CppParseName(CorbaBoolean)()->name() << " _oldRelease = _release;" << endl;
        ofs << "_release = " << CppGen_(Bool)::value(ILUCPP_TRUE) << ";" << endl;
        ofs << "_length = _len;" << endl;
        ofs << "_maximum = _len;" << endl;
        ofs << "_buffer = allocbuf(_length);" << endl;
        if (needVarBuffer())
            ofs << "_varBuffer = new " << elementType()->usageName(CppParseName(element), scope()) << "[_length];" << endl;
        ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = 0; _index < _oldLength; _index++) {" << endl;
        ofs.indent++;
        ofs << "_buffer[_index] = _oldBuffer[_index];" << endl;
        if (needVarBuffer())
            ofs << "_varBuffer[_index] = _oldVarBuffer[_index];" << endl;
        ofs.indent--;
        ofs << "};" << endl;
        ofs << "if (_buffer != NULL && _oldRelease) {" << endl;
        ofs.indent++;
        ofs << "freebuf(_oldBuffer);" << endl;
        if (needVarBuffer())
            ofs << "delete [] _varBuffer;" << endl;
        ofs.indent--;
        ofs << "};" << endl;
        ofs.indent--;
        ofs << "};" << endl;
    }

    // body of set length for bounded sequences
    else {
        ofs << "if (_len > _maximum) {" << endl;
        ofs.indent++;
        ofs << "// behavior undefined by CORBA 2.0 spec, but better safe that sorry !" << endl;
        ofs << CppParseName(CorbaUNKNOWN)()->name() << " _exception(0, "
            << CppParseName(CorbaCOMPLETED_NO)()->name() << ");" << endl;
        ofs << "throw _exception;" << endl;
        ofs.indent--;
        ofs << "}" << endl;
        if (needVarBuffer()) {
            ofs << "else {" << endl;
            ofs.indent++;
            ofs << "if (_len < _length && _release) {" << endl;
            ofs.indent++;
            ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = _len; _index < _length; _index++) {" << endl;
            ofs.indent++;
            ofs << "_varBuffer[_index] = NULL;" << endl;
            ofs.indent--;
            ofs << "};" << endl;
            ofs.indent--;
            ofs << "};" << endl;
            ofs << "_length = _len;" << endl;
            ofs.indent--;
            ofs << "};" << endl;
        };
    };

    // end of set length function
    ofs.indent--;
    ofs << "}" << endl;

    // left-side indexing operator
    ofs << endl;
    ofs << elementType()->usageName(CppParseName(element)) << "&" << endl;
    ofs << name() << "::" << endl;
    ofs << "operator [] (" << CppParseName(CorbaULong)()->name() << " _index) {" << endl;
    ofs.indent++;
    ofs << "if (_index >= _length) {" << endl;
    ofs.indent++;
    ofs << "// behavior undefined by CORBA 2.0 spec, but better safe that sorry !" << endl;
    ofs << CppParseName(CorbaUNKNOWN)()->name() << " _exception(0, "
        << CppParseName(CorbaCOMPLETED_NO)()->name() << ");" << endl;
    ofs << "throw _exception;" << endl;
    ofs.indent--;
    ofs << "};" << endl;
    if (needVarBuffer())
        ofs << "return _varBuffer[_index];" << endl;
    else
        ofs << "return _buffer[_index];" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // right-side indexing operator
    ofs << endl;
    ofs << "const " << elementType()->usageName(CppParseName(element)) << "&" << endl;
    ofs << name() << "::" << endl;
    ofs << "operator [] (" << CppParseName(CorbaULong)()->name() << " _index) const {" << endl;
    ofs.indent++;
    ofs << "if (_index >= _length) {" << endl;
    ofs.indent++;
    ofs << "// behavior undefined by CORBA 2.0 spec, but better safe that sorry !" << endl;
    ofs << CppParseName(CorbaUNKNOWN)()->name() << " _exception(0, "
        << CppParseName(CorbaCOMPLETED_NO)()->name() << ");" << endl;
    ofs << "throw _exception;" << endl;
    ofs.indent--;
    ofs << "};" << endl;
    if (needVarBuffer())
        ofs << "return _varBuffer[_index];" << endl;
    else
        ofs << "return _buffer[_index];" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // allocbuf function
    ofs << endl;
    ofs << dataElementType() << "*" << endl;
    ofs << name() << "::" << endl;
    ofs << "allocbuf (" << CppParseName(CorbaULong)()->name() << " num_elements) {" << endl;
    ofs.indent++;
    ofs << dataElementType() << "* _new_buff = (num_elements > 0 ? "
        << "(new " << dataElementType() << "[num_elements]) : NULL);" << endl;
    // NULL-out pointers
// TMP 7/7    if (elementType()->isPtr(CppParseName(element))) {
    if (elementType()->indirection(CppParseName(element)) != CppParse(direct)) {  // TMP 7/7: NEW
        ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = 0; _index < num_elements; _index++)" << endl;
        ofs.indent++;
        ofs << "_new_buff[_index] = NULL;" << endl;
        ofs.indent--;
    };
    ofs << "return _new_buff;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // freebuf function
    ofs << endl;
    ofs << "void" << endl;
    ofs << name() << "::" << endl;
    ofs << "freebuf (" << dataElementType() << "* _buf) {" << endl;
    ofs.indent++;
    ofs << "delete [] _buf;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // sizing, input, and output operations
    ofs << endl;
    outputIOOpImpl(CppGen_(size), ofs);
    ofs << endl;
    outputIOOpImpl(CppGen_(input), ofs);
    ofs << endl;
    outputIOOpImpl(CppGen_(output), ofs);

    // surrogate side cleanup function
    if (needsSurrogateSideCleanup()) {
        ofs << endl;
        ofs << "void" << endl;
        ofs << name() << "::" << endl;
        ofs << "_surrogateSideCleanup () const {" << endl;
        ofs.indent++;
        ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = 0; _index < _length; _index++)" << endl;
        ofs.indent++;
        if (needVarBuffer())
            ofs << "_varBuffer[_index].iluDeleteWrapper();" << endl;
        else
            ofs << "_buffer[_index].iluDeleteWrapper();" << endl;
        ofs.indent--;
        ofs.indent--;
        ofs << "}" << endl;
        ofs << endl;
    };

    return ofs;
}


void
CppGen(Sequence)::
outputIOOpImpl (CppGen_(IOOp) op, CppParseStream(ofstream)& ofs) const {

    // determine operation, and whether sequence is const or not
    const char * opStr;
    const char * constStr;
    switch (op) {
        case CppGen_(size):
            opStr = "+=";
            constStr = "const ";
            break;
        case CppGen_(input):
            opStr = ">>";
            constStr = "";
            break;
        default:  // CppGen::output
            opStr = "<<";
            constStr = "const ";
            break;
    };

    // begin function
    ofs << "iluBaseCall&" << endl;
    ofs << "operator " << opStr << " (iluBaseCall& _call, " << constStr << name() << "& _seq) {" << endl;
    ofs.indent++;

    // local variables
    if (op == CppGen_(input))
        ofs << "iluCardinal _seq_length;" << endl;
    else
        ofs << "iluCardinal _seq_length = _seq.length();" << endl;
    ofs << "iluSequenceWrapper _seq_wrapper(_seq_length);" << endl;

/* TMP 9/9
    // perform operation for sequence & each element
    ofs << "_call " << opStr << " _seq_wrapper;" << endl;
    if (op == CppGen_(input))
        ofs << "_seq.length(_seq_length);" << endl;
    ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = 0; _index < _seq_length; _index++)" << endl;
    ofs.indent++;
    ofs << "_call " << opStr << " _seq[_index];" << endl;
    ofs.indent--;
    ofs << "_call << iluEndSequence;" << endl;
TMP 9/9 */

	// perform operation on sequence wrapper  // TMP 9/9: NEW
    ofs << "_call " << opStr << " _seq_wrapper;" << endl;
    if (op == CppGen_(input))
        ofs << "_seq.length(_seq_length);" << endl;

	// begin for loop  // TMP 9/9: NEW
    ofs << "for (" << CppParseName(CorbaULong)()->name() << " _index = 0; _index < _seq_length; _index++) {" << endl;
    ofs.indent++;

	// perform operation on each element  // TMP 9/9: NEW
	{
		const CppGen_(Type) * eType = CppGen_(Type)::narrow(elementType());
		switch (op) {
		case CppGen_(size):
			eType->initialDeclsOutput(&element, ILUCPP_FALSE, ofs);
			eType->sizing(&element, ofs);
			break;
		case CppGen_(input):
			eType->initialDeclsInput(&element, ILUCPP_FALSE, ofs);
			eType->receive(&element, ofs);
			break;
		case CppGen_(output):
			eType->initialDeclsOutput(&element, ILUCPP_FALSE, ofs);
			eType->send(&element, ofs);
			break;
		default:  // shouldn't happen
			break;
		};
	};

	// end for loop  // TMP 9/9: NEW
	ofs.indent--;
	ofs << "};" << endl;

    // end function
    ofs << "_call << iluEndSequence;" << endl;  // TMP 9/9: NEW
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

}

void
CppGen(Sequence)::  // TMP 8/5: NEW
optionalCommonDefForward (const CppParseName(TypeName)* optional, CppParseStream(ofstream)& ofs) const {

    // typedef for optional
    ofs << "typedef " << name(optional->scope()) << "* " << optional->localName() << ";" << endl;

    // typedef for const_optional
    ofs << "typedef const " << name(optional->scope()) << "* "
        << optional->localUsageName(CppParseName(constRef)) << ";" << endl;

    // typedef for optional_var
    ofs << "typedef iluOptional" << (needsSurrogateSideCleanup() ? "WithCleanup" : "") << "MgrT<"
        << name(optional->scope()) << "> "
        << optional->localUsageName(CppParseName(var)) << "; " << endl;

}


/* TMP 6/14
int
CppGen(Exception)::
exceptionNum () {
    return _exceptionNum;
};
*/


CppParseStream(ofstream) &
CppGen(Exception)::
_commonDefIOOperators (CppParseStream(ofstream) & ofs) {
    ofs << "iluBaseCall& operator+= (iluBaseCall&, " << "const " << name() << "&);" << endl;
    ofs << "iluBaseCall& operator<< (iluBaseCall&, " << "const " << name() << "&);" << endl;
    ofs << "iluBaseCall& operator>> (iluBaseCall&, " << name() << "&);" << endl;
    return ofs;
};


CppParseStream(ofstream) &
CppGen(Exception)::
_commonImplIOOperators (CppParseStream(ofstream) & ofs) {

    const CppGen_(ExceptionValue) * val = CppGen_(ExceptionValue)::narrow(value());

    // Sizing operator
    ofs << "iluBaseCall&" << endl;
    ofs << "operator+= (iluBaseCall& _call, const " << name() << "& _exception) {" << endl;
    ofs.indent++;
    if (val != NULL)
        ofs << val->initialDeclsOutput();
// TMP 6/14    ofs << "_call.iluSizeExceptionMode(_ilu_nsconst_" << name(CppGen_(underscore_key)) << "_index + 1);" << endl;
    if (val != NULL)
        ofs << val->sizing();
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // Extraction (output) operator
    ofs << "iluBaseCall&" << endl;
    ofs << "operator<< (iluBaseCall& _call, const " << name() << "& _exception) {" << endl;
    ofs.indent++;
    if (val != NULL)
        ofs << val->initialDeclsOutput();
    ofs << "_call << iluSendExceptionMode;" << endl;
    if (val != NULL)
        ofs << val->send();
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // Insertion (input) operator
    ofs << "iluBaseCall&" << endl;
    ofs << "operator>> (iluBaseCall& _call, " << name() << "& _exception) {" << endl;
    ofs.indent++;
    if (val != NULL)
        ofs << val->initialDeclsInput();
    if (val != NULL)
        ofs << val->receive();
    ofs << "return _call;" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    return ofs;
};
