#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/repl/backtrac.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.4
 | File mod date:    1997.11.29 23:10:32
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  repl
 |
 | Purpose:          Apply backtrace support
 `------------------------------------------------------------------------|#

(define (arg-frame? x)
    (if (vector? x)
	(procedure? (vector-ref x 0))
	#f))

(define (suppress? argf)
  #f)

(define (apply-backtrace envt)
  (let ((port (current-output-port)))
    (let loop ((i 0) (s (get-dynamic-state-reg)))
      (if (pair? s)
	  (begin
	    (if (arg-frame? (car s))
		(if (not (suppress? (car s)))
		    (let* ((v (car s))
			   (n (vector-length v)))
		      (format port " [~d] : " i)
		      (write (vector-ref v 0) port)
		      (newline port)
		      (let loop ((j 1))
			(if (not (eq? j n))
			    (begin
			      (format port 
				      "      with [~d] = ~a\n"
				      (sub1 j)
				      (object->bounded-string 
				       59 
				       (vector-ref v j)))
			      (loop (add1 j)))))))
		(begin
		  (format port " (~d) : " i)
		  (display (object->bounded-string 68 (car s)) port)
		  (newline port)))
	    (loop (add1 i) (cdr s)))))))
