#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/tables/make.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.5
 | File mod date:    1997.11.29 23:10:34
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  tables
 |
 | Purpose:          initializers for <hash-table>'s
 `------------------------------------------------------------------------|#

(define-method initialize ((self <hash-table>))
  (set-bucket-class! self <table-bucket>)
  (set-directory! self (make-vector (shift-left 1 (directory-bits self))))
  self)

#|
(define $log2-tree '#(128 #(8 #(2 #(1 0 1)
				  #(4 2 3))
			      #(32 #(16 4 5)
			           #(64 6 7)))
			  #(2048 #(512 #(256 8 9)
			               #(1024 10 11))
				 #(8192 #(4096 12 13)
				        #(16384 14 15)))))
				   

(define (binary-search tree (value <fixnum>))
    (if (fixnum? tree)
	tree
	(let (((t <vector>) tree))
	    (if (<= value (vector-ref t 0))
		(binary-search (vector-ref t 1) value)
		(binary-search (vector-ref t 2) value)))))
|#

(define (log2 (n <fixnum>))
    (let loop (((i <fixnum>) 1) ((j <fixnum>) 0))
	(if (fixnum>=? i n)
	    j
	    (loop (shift-left i 1) (add1 j)))))

(define (capacity->directory-size cap)
    (if cap (log2 cap) 4))

(define (make-table eq-proc hash-proc . cap)
    (let ((initial-size (capacity->directory-size 
			    (if (null? cap) 
				#f 
				(car cap)))))
	(cond
	    ((and (eq? eq-proc string=?)
		  (eq? hash-proc string->hash))
		(make <string-table> directory-bits: initial-size))
	    ((and (eq? eq-proc string-ci=?)
		  (eq? hash-proc string-ci->hash))
		(make <string-ci-table> directory-bits: initial-size))
	    ((and (eq? eq-proc eq?)
		  (eq? hash-proc symbol->hash))
		(make <symbol-table> directory-bits: initial-size))
	    ((and (eq? eq-proc eq?)
		  (eq? hash-proc identity))
	        (make <integer-table> directory-bits: initial-size))
	    ((and (eq? eq-proc eq?)
		  (eq? hash-proc integer->hash))
	        (make <hash-integer-table> directory-bits: initial-size))
	    ((eq? eq-proc eq?)
		(make <eq-table> directory-bits: initial-size
				 table-hash-function: hash-proc))
	    (else
		(make <generic-table> directory-bits: initial-size
				      table-hash-function: hash-proc
				      table-equal-function: eq-proc)))))

;; convenience function

(define (make-symbol-table)
  (make <symbol-table>
	directory-bits: 4))

(define (make-string-table)
  (make <string-table>
	directory-bits: 4))

(define (table? thing)
    (instance? thing <table>))

(define-safe-glue (hash-table-copy (table <hash-table>))
{
  REG0 = hashtable_copy(table);
  RETURN1();
})
