
(define-rstore-glue (alloc-indirect-pages (ps <persistent-store>)
					  (n <raw-int>))
{
  REG0 = int2fx( ps_store->next_indirect_page );
  ps_store->next_indirect_page += n;
  RETURN1();
})

(define (alloc-indirect-page (self <persistent-store>))
  (let ((n (alloc-indirect-pages self 1)))
    (debug/rstore "allocating for use indirect page[~d]\n" n)
    n))

(define-rstore-glue (install-indirect-page (ps <persistent-store>) 
					   (page_num <raw-int>)
					   (vec <vector>))
{
  struct VMPageRecord *vmpr = ALLOC(struct VMPageRecord);

  vmpr->mem_address = PTR_TO_DATAPTR(vec);
  vmpr->ref.base_page_num = page_num;
  vmpr->ref.first = 1;
  vmpr->ref.indirect = 1;
  vmpr->ref.dirty = 0;
  vmpr->ref.loaded = 1;
  vmpr->ref.nth_page = 1;
  install_new_vmpr( ps_store, vmpr );
  RETURN0();
})

;;
;;  returns three values:
;;    [0] the page data as a <string>
;;    [1] the type id
;;    [2] the instance id
;;

(define-rstore-glue (read-indirect-page-data (ps <persistent-store>)
				      (rec_num <raw-int>))
 literals: ((& <string>))
{
  access_t a;
  UINT_32 hdr[2];

  lss_access( ps_store->lss, rec_num, &a );

  memcpy( hdr, a.addr, sizeof hdr );
  REG1 = int2fx( hdr[0] );
  REG2 = int2fx( hdr[1] );
  REG0 = alloc( a.bytes - sizeof hdr + 1, TLREF(0) );
  memcpy( PTR_TO_DATAPTR(REG0), 
	  ((char *)a.addr) + sizeof hdr, 
	  a.bytes - sizeof hdr );
  lss_release( ps_store->lss, &a );
  RETURN(3);
})

(define-rstore-glue (write-indirect-page-data (ps <persistent-store>)
				       (rec_num <raw-int>)
				       (type_id <raw-int>)
				       (instance_id <raw-int>)
				       data)
{
 char *p, temp[400];
 UINT_32 hdr[2];
 unsigned len = SIZEOF_PTR(data) + sizeof(UINT_32) * 2;

 if (STRING_P(data))
   len--;

 p = (len < 400) ? temp : (char *)malloc(len);
   
 hdr[0] = type_id;
 hdr[1] = instance_id;

 memcpy( p, hdr, sizeof hdr );
 memcpy( p + sizeof hdr, PTR_TO_DATAPTR(data), SIZEOF_PTR(data) );

 lss_write( ps_store->lss, rec_num, p, len );
 if (!(len < 400))
   free(p);
 RETURN0();
})

(define-glue (symbol-list->indirect-page symbols)
{
  REG0 = unswizzle_symbol_itemv( symbols );
  RETURN1();
})
