#|------------------------------------------------------------*-Scheme-*--|
 | File:    test/threads.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.5
 | File mod date:    1997.11.29 23:10:41
 | System build:     v0.7.2, 97.12.21
 |
 `------------------------------------------------------------------------|#

,(use threads)

(define *console-mbox* (make <mailbox>))

(define (tester n slp)
  (lambda ()
    (let loop ((i 0))
      (if (< i 10)
	  (begin
	    (send-message! *console-mbox*
			   (list "running ==> ~s (~d left)" 
				 n
				 (os-get-time-remaining)))
	    (thread-sleep slp)
	    (loop (+ i 1)))
	  (values n 'x n)))))


(define (console)
  (let loop ((n 0))
    (let ((m (receive-message! *console-mbox*)))
      (format #t "[~d] " n)
      (apply format #t m)
      (newline)
      (loop (+ n 1)))))

(define (test)
  (run-threads (make <thread>
		     thunk: (tester 'foo 300)
		     name: "foo")
	       (make <thread>
		     thunk: (tester 'bar 200)
		     name: "bar")
	       (make <thread>
		     name: "console"
		     thunk: console)))


;;;
;;;  a replacement implementation of `thread-sleep'
;;;

,(use syscalls)

(define (thread-sleep ms)
  (let ((t0 (time+interval (time) (seconds->interval (/ ms 1000)))))
    (let loop ()
      (if (time<? (time) t0)
	  (begin
	    (thread-yield)
	    (loop))))))

;;;

(test)
