/***********************************************************************/
/* COLOUR.C - Colour related functions                                 */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1997 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * PO Box 203                    Phone:                    +617 3802 0800
 * Bellara                       http://www.gu.edu.au/gext/the/markh.html
 * QLD 4507                      **** Maintainer PDCurses & REXX/SQL ****
 * Australia                     ************* Author of THE ************
 */

/*
$Id: colour.c 2.1 1995/06/24 16:28:39 MH Rel MH $
*/

#include <the.h>
#include <proto.h>

/*
 *                        attributes
 *             FILEAREA   CURLINE  BLOCK    CBLOCK
 *             CMDLINE    IDLINE   MSGLINE  ARROW
 *             PREFIX     PENDING  SCALE    TOFEOF
 *             CTOFEOF    TABLINE  SHADOW   STATAREA
 *             DIVIDER    RESERVED NONDISP  HIGHLIGHT
 *             CHIGHLIGHT SLK      GAP
 */

#ifdef A_COLOR
 static chtype the_fore[ATTR_MAX] =
              {COLOR_WHITE,COLOR_WHITE,COLOR_BLUE,COLOR_RED,
               COLOR_BLACK,COLOR_BLUE,COLOR_RED,COLOR_BLACK,
               COLOR_BLACK,COLOR_RED,COLOR_YELLOW,COLOR_WHITE,
               COLOR_WHITE,COLOR_YELLOW,COLOR_RED,COLOR_BLUE,
               COLOR_RED,COLOR_WHITE,COLOR_MAGENTA,COLOR_WHITE,
               COLOR_YELLOW,COLOR_BLACK,COLOR_BLACK};
 static chtype the_back[ATTR_MAX] =
              {COLOR_BLUE,COLOR_BLUE,COLOR_WHITE,COLOR_WHITE,
               COLOR_CYAN,COLOR_WHITE,COLOR_WHITE,COLOR_CYAN,
               COLOR_CYAN,COLOR_WHITE,COLOR_BLUE,COLOR_BLUE,
               COLOR_BLUE,COLOR_BLUE,COLOR_WHITE,COLOR_WHITE,
               COLOR_WHITE,COLOR_BLACK,COLOR_CYAN,COLOR_CYAN,
               COLOR_CYAN,COLOR_CYAN,COLOR_CYAN};
 static chtype the_mod[ATTR_MAX] =
              {A_NORMAL,A_BOLD,  A_NORMAL,A_NORMAL,
               A_NORMAL,A_NORMAL,A_NORMAL,A_NORMAL,
               A_NORMAL,A_NORMAL,A_BOLD,  A_BOLD,
               A_BOLD,  A_BOLD,  A_NORMAL,A_NORMAL,
               A_NORMAL,A_NORMAL,A_BLINK, A_BOLD,
               A_BOLD,  A_BOLD,  A_NORMAL};
 static chtype kedit_fore[ATTR_MAX] =
              {COLOR_CYAN,COLOR_YELLOW,COLOR_CYAN,COLOR_YELLOW,
               COLOR_YELLOW,COLOR_YELLOW,COLOR_YELLOW,COLOR_YELLOW,
               COLOR_YELLOW,COLOR_WHITE,COLOR_YELLOW,COLOR_CYAN,
               COLOR_YELLOW,COLOR_YELLOW,COLOR_YELLOW,COLOR_YELLOW,
               COLOR_CYAN,COLOR_YELLOW,COLOR_MAGENTA,COLOR_WHITE,
               COLOR_YELLOW,COLOR_BLACK,COLOR_CYAN};
 static chtype kedit_back[ATTR_MAX] =
              {COLOR_BLUE,COLOR_BLUE,COLOR_WHITE,COLOR_WHITE,
               COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,
               COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,
               COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,COLOR_BLUE,
               COLOR_BLUE,COLOR_BLUE,COLOR_CYAN,COLOR_CYAN,
               COLOR_CYAN,COLOR_CYAN,COLOR_BLUE};
 static chtype kedit_mod[ATTR_MAX]  =
              {A_BOLD,  A_BOLD,  A_BOLD,  A_BOLD,
               A_BOLD,  A_BOLD,  A_BOLD,  A_BOLD,
               A_NORMAL,A_BOLD,  A_BOLD,  A_BOLD,
               A_BOLD,  A_BOLD,  A_NORMAL,A_BOLD,
               A_BOLD,  A_BOLD,  A_BLINK, A_BOLD,
               A_BOLD,  A_BOLD,  A_BOLD};
 static chtype xedit_fore[ATTR_MAX] =
              {COLOR_GREEN, COLOR_CYAN, COLOR_BLACK,COLOR_CYAN,
               COLOR_YELLOW,COLOR_CYAN, COLOR_RED,  COLOR_CYAN,
               COLOR_GREEN, COLOR_GREEN,COLOR_CYAN, COLOR_GREEN,
               COLOR_GREEN, COLOR_GREEN,COLOR_GREEN,COLOR_CYAN,
               COLOR_GREEN, COLOR_GREEN,COLOR_MAGENTA,COLOR_WHITE,
               COLOR_YELLOW,COLOR_BLACK,COLOR_GREEN};
 static chtype xedit_back[ATTR_MAX] =
              {COLOR_BLACK,COLOR_BLACK,COLOR_GREEN,COLOR_GREEN,
               COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,
               COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,
               COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,COLOR_BLACK,
               COLOR_BLACK,COLOR_BLACK,COLOR_CYAN,COLOR_CYAN,
               COLOR_CYAN,COLOR_GREEN,COLOR_BLACK};
 static chtype xedit_mod[ATTR_MAX]  =
              {A_NORMAL,A_NORMAL,A_NORMAL,A_BOLD,
               A_NORMAL,A_NORMAL,A_BOLD,  A_NORMAL,
               A_NORMAL,A_BOLD,  A_NORMAL,A_NORMAL,
               A_BOLD,  A_BOLD,  A_NORMAL,A_NORMAL,
               A_BOLD,  A_BOLD,  A_BLINK, A_BOLD,
               A_BOLD,  A_BOLD,  A_NORMAL};
#else
 static chtype the_fore[ATTR_MAX]   = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype the_back[ATTR_MAX]   = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype the_mod[ATTR_MAX]    = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype kedit_fore[ATTR_MAX] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype kedit_back[ATTR_MAX] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype kedit_mod[ATTR_MAX]  = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype xedit_fore[ATTR_MAX] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype xedit_back[ATTR_MAX] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 static chtype xedit_mod[ATTR_MAX]  = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
#endif
 static chtype the_mono[ATTR_MAX] =
              {A_NORMAL,A_BOLD,A_REVERSE,A_BOLD|A_REVERSE,
               A_BOLD,A_REVERSE,A_BLINK,A_BOLD,
               A_REVERSE,A_BOLD|A_REVERSE,A_BOLD,A_BOLD,
               A_BOLD,A_BOLD,A_BOLD,A_REVERSE,
               A_BOLD,A_BOLD,A_BLINK|A_REVERSE,A_REVERSE,
               A_BOLD|A_REVERSE,A_BOLD|A_REVERSE,A_REVERSE};
                                                        
 static chtype kedit_mono[ATTR_MAX] =
              {A_NORMAL,A_BOLD,  A_REVERSE,A_REVERSE|A_BOLD,
               A_NORMAL,A_NORMAL,A_BOLD,  A_BOLD,
               A_NORMAL,A_BOLD,  A_NORMAL,A_NORMAL,
               A_BOLD,  A_NORMAL,A_NORMAL,A_BOLD,
               A_NORMAL,A_NORMAL,A_BLINK|A_REVERSE,A_REVERSE,
               A_BOLD|A_REVERSE,A_BOLD|A_REVERSE,A_NORMAL};
 static chtype xedit_mono[ATTR_MAX] =
              {A_NORMAL,A_BOLD,  A_REVERSE,A_BOLD|A_REVERSE,
               A_NORMAL,A_BOLD,  A_BOLD,  A_BOLD,
               A_NORMAL,A_BOLD,  A_BOLD,  A_NORMAL,
               A_BOLD,  A_BOLD,  A_NORMAL,A_BOLD,
               A_BOLD,  A_BOLD,  A_BLINK|A_REVERSE,A_REVERSE,
               A_BOLD|A_REVERSE,A_BOLD|A_REVERSE,A_NORMAL};

 struct attributes
 {
  CHARTYPE *attrib;
  short attrib_min_len;
  chtype actual_attrib;
  chtype colour_modifier;
  bool attrib_modifier;
  bool attrib_allowed_on_mono;
 };
 typedef struct attributes ATTRIBS;
#define NO_ATTRIBS 21
 static ATTRIBS valid_attribs[NO_ATTRIBS] =
 {
  {(CHARTYPE *)"black",3,COLOR_BLACK,0,FALSE,TRUE},
  {(CHARTYPE *)"white",1,COLOR_WHITE,A_BOLD,FALSE,TRUE},
  {(CHARTYPE *)"grey",3,COLOR_WHITE,0,FALSE,FALSE},
  {(CHARTYPE *)"gray",3,COLOR_WHITE,0,FALSE,FALSE},
  {(CHARTYPE *)"blue",3,COLOR_BLUE,0,FALSE,FALSE},
  {(CHARTYPE *)"green",1,COLOR_GREEN,0,FALSE,FALSE},
  {(CHARTYPE *)"cyan",1,COLOR_CYAN,0,FALSE,FALSE},
  {(CHARTYPE *)"red",3,COLOR_RED,0,FALSE,FALSE},
  {(CHARTYPE *)"magenta",1,COLOR_MAGENTA,0,FALSE,FALSE},
  {(CHARTYPE *)"pink",1,COLOR_MAGENTA,A_BOLD,FALSE,FALSE},
  {(CHARTYPE *)"brown",1,COLOR_YELLOW,0,FALSE,FALSE},
  {(CHARTYPE *)"yellow",1,COLOR_YELLOW,A_BOLD,FALSE,FALSE},
  {(CHARTYPE *)"turquoise",1,COLOR_CYAN,0,FALSE,FALSE},
  {(CHARTYPE *)"normal",3,A_NORMAL,0,TRUE,TRUE},
  {(CHARTYPE *)"blink",3,A_BLINK,0,TRUE,TRUE},
  {(CHARTYPE *)"bold",2,A_BOLD,0,TRUE,TRUE},
  {(CHARTYPE *)"bright",3,A_BOLD,0,TRUE,TRUE},
  {(CHARTYPE *)"high",1,A_BOLD,0,TRUE,TRUE},
  {(CHARTYPE *)"reverse",3,A_REVERSE,0,TRUE,TRUE},
  {(CHARTYPE *)"underline",1,A_UNDERLINE,0,TRUE,TRUE},
  {(CHARTYPE *)",",1,8,0,FALSE,TRUE},
 };

/***********************************************************************/
#ifdef HAVE_PROTO
short parse_colours(CHARTYPE *attrib,COLOUR_ATTR *pattr,CHARTYPE **rem,bool spare,bool *any_colours)
#else
short parse_colours(attrib,pattr,rem,spare,any_colours)
CHARTYPE *attrib;
COLOUR_ATTR *pattr;
CHARTYPE **rem;
bool spare;
bool *any_colours;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern bool colour_support;
/*--------------------------- local data ------------------------------*/
 register short i=0;
 short num_colours=0;
 chtype mono=pattr->mono;
 chtype specified_mod=0L;
 chtype fg=FOREFROMPAIR(pattr->pair);
 chtype bg=BACKFROMPAIR(pattr->pair);
 CHARTYPE *string=NULL;
 CHARTYPE *p=NULL,*oldp=NULL;
 bool found=FALSE,any_found=FALSE;
 bool spare_pos=FALSE;
 int offset=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("colour.c:  parse_colours");
#endif
/*---------------------------------------------------------------------*/
/* Get a copy of the passed string and wreck it rather than the passed */
/* string.                                                             */
/*---------------------------------------------------------------------*/
 if ((string = (CHARTYPE *)my_strdup(attrib)) == NULL)
   {
    display_error(30,(CHARTYPE *)"",FALSE);
#ifdef TRACE
    trace_return();
#endif
    return(RC_OUT_OF_MEMORY);
   }
 oldp = string;
 p = (CHARTYPE *)strtok((DEFCHAR *)string," \t");
 while(p != NULL)
   {
    found = FALSE;
    for (i=0;i<NO_ATTRIBS;i++)
       {
        if (equal(valid_attribs[i].attrib,p,valid_attribs[i].attrib_min_len))
          {
           any_found = found = TRUE;
           if (!valid_attribs[i].attrib_allowed_on_mono
           &&  !colour_support)
             {
              display_error(61,(CHARTYPE *)p,FALSE);
              (*the_free)(string);
#ifdef TRACE
              trace_return();
#endif
              return(RC_INVALID_OPERAND);
             }
           if (valid_attribs[i].attrib_modifier)
             {
              if (colour_support)
                 specified_mod = (valid_attribs[i].actual_attrib==A_NORMAL)?A_NORMAL:specified_mod | valid_attribs[i].actual_attrib;
              else
                 mono = (valid_attribs[i].actual_attrib==A_NORMAL)?A_NORMAL:mono | valid_attribs[i].actual_attrib;
              offset = p-oldp+strlen((DEFCHAR *)p)+1;
              break;
             }
           else
             {
              switch(num_colours)
                {
                 case 0:
                      if (!colour_support
                      &&  valid_attribs[i].actual_attrib != COLOR_WHITE)
                        {
                         display_error(61,(CHARTYPE *)p,FALSE);
                         (*the_free)(string);
#ifdef TRACE
                         trace_return();
#endif
                         return(RC_INVALID_OPERAND);
                        }
                      if (valid_attribs[i].actual_attrib != 8)
                        {
                         fg = valid_attribs[i].actual_attrib;
                         specified_mod |= valid_attribs[i].colour_modifier;
                        }
                      num_colours++;
                      offset = p-oldp+strlen((DEFCHAR *)p)+1;
                      break;
                 case 1:
                      if (!colour_support
                      &&  valid_attribs[i].actual_attrib != COLOR_BLACK)
                        {
                         display_error(61,(CHARTYPE *)p,FALSE);
                         (*the_free)(string);
#ifdef TRACE
                         trace_return();
#endif
                         return(RC_INVALID_OPERAND);
                        }
                      if (valid_attribs[i].actual_attrib != 8)
                        {
                         bg = valid_attribs[i].actual_attrib;
                        }
                      num_colours++;
                      offset = p-oldp+strlen((DEFCHAR *)p)+1;
                      break;
                 default:
                      if (spare)
                        {
                         spare_pos = TRUE;
                         *rem = (CHARTYPE *)attrib+offset;
                         break;
                        }
                      display_error(1,(CHARTYPE *)p,FALSE);
                      (*the_free)(string);
#ifdef TRACE
                      trace_return();
#endif
                      return(RC_INVALID_OPERAND);
                      break;
                }
              if (spare_pos)
                 break;
             }
           break;
          }
       }
    if (spare_pos && found)
       break;
    if (!found)
      {
       if (equal((CHARTYPE *)"on",p,2)
       && num_colours == 1)
          ;
       else
         {
          if (spare)
            {
             *rem = (CHARTYPE *)attrib+offset;
             break;
            }
          display_error(1,(CHARTYPE *)p,FALSE);
          (*the_free)(string);
#ifdef TRACE
          trace_return();
#endif
          return(RC_INVALID_OPERAND);
         }
      }
    p = (CHARTYPE *)strtok(NULL," \t");
   }

 if (num_colours == 0)
   pattr->pair = ATTR2PAIR(COLOR_WHITE,COLOR_BLACK);
 else
   pattr->pair = ATTR2PAIR(fg,bg);
 pattr->mod = specified_mod;
 pattr->mono = mono;
 *any_colours = any_found;
 (*the_free)(string);
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/***********************************************************************/
#ifdef HAVE_PROTO
chtype set_colour(COLOUR_ATTR *attr)
#else
chtype set_colour(attr)
COLOUR_ATTR *attr;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool colour_support;
/*--------------------------- local data ------------------------------*/
 chtype color=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("colour.c:  set_colour");
#endif

 color = attr->mono;
#ifdef A_COLOR
 if (colour_support)
    color = (attr->pair) ? COLOR_PAIR(attr->pair) | attr->mod : attr->mod;
#endif

#ifdef TRACE
 trace_return();
#endif
 return(color);
}
/***********************************************************************/
#ifdef HAVE_PROTO
void set_up_default_colours(FILE_DETAILS *fd,COLOUR_ATTR *attr,int colour_num)
#else
void set_up_default_colours(fd,attr,colour_num)
FILE_DETAILS *fd;
COLOUR_ATTR *attr;
int colour_num;
#endif
/***********************************************************************/
/* This function is called as part of reading in a new file.           */
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern short compatible_look;
/*--------------------------- local data ------------------------------*/
 register short i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("colour.c:  set_up_default_colours");
#endif
/*---------------------------------------------------------------------*/
/* Set up default colours.                                             */
/*---------------------------------------------------------------------*/
 switch(compatible_look)
   {
    case COMPAT_THE:
         if (colour_num == ATTR_MAX)
           {
            for (i=0;i<ATTR_MAX;i++)
              {
               fd->attr[i].pair = ATTR2PAIR(the_fore[i],the_back[i]);
               fd->attr[i].mod = the_mod[i];
               fd->attr[i].mono = the_mono[i];
              }
           }
         else
           {
            attr->pair = ATTR2PAIR(the_fore[colour_num],the_back[colour_num]);
            attr->mod = the_mod[colour_num];
            attr->mono = the_mono[colour_num];
           }
         break;
    case COMPAT_XEDIT:
         if (colour_num == ATTR_MAX)
           {
            for (i=0;i<ATTR_MAX;i++)
              {
               fd->attr[i].pair = ATTR2PAIR(xedit_fore[i],xedit_back[i]);
               fd->attr[i].mod = xedit_mod[i];
               fd->attr[i].mono = xedit_mono[i];
              }
           }
         else
           {
            attr->pair = ATTR2PAIR(xedit_fore[colour_num],xedit_back[colour_num]);
            attr->mod = xedit_mod[colour_num];
            attr->mono = xedit_mono[colour_num];
           }
         break;
    case COMPAT_KEDIT:
         if (colour_num == ATTR_MAX)
           {
            for (i=0;i<ATTR_MAX;i++)
              {
               fd->attr[i].pair = ATTR2PAIR(kedit_fore[i],kedit_back[i]);
               fd->attr[i].mod = kedit_mod[i];
               fd->attr[i].mono = kedit_mono[i];
              }
           }
         else
           {
            attr->pair = ATTR2PAIR(kedit_fore[colour_num],kedit_back[colour_num]);
            attr->mod = kedit_mod[colour_num];
            attr->mono = kedit_mono[colour_num];
           }
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef HAVE_PROTO
CHARTYPE *get_colour_strings(COLOUR_ATTR *attr)
#else
CHARTYPE *get_colour_strings(attr)
COLOUR_ATTR *attr;
#endif
/***********************************************************************/
/* This function returns a pointer to an allocated block of memory with*/
/* textual descriptions of the colours associated with the attr.       */
/* The caller is responsible for freeing up the allocated memory.      */
/***********************************************************************/
{
#define GET_MOD 0
#define GET_FG  1
#define GET_BG  2
/*------------------------- external data -----------------------------*/
 extern bool colour_support;
/*--------------------------- local data ------------------------------*/
 register int i=0,j=0;
 CHARTYPE *attr_string=NULL;
 int fg=FOREFROMPAIR(attr->pair),bg=BACKFROMPAIR(attr->pair);
 chtype mod=attr->mono;
 int start_with=0;
 bool colour_only=FALSE;
 chtype match_value=0L;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("colour.c:  get_colour_strings");
#endif

 start_with = GET_MOD;
#ifdef A_COLOR
 if (colour_support)
   {
    start_with = GET_MOD;
    mod = attr->mod;
   }
#endif
 attr_string = (CHARTYPE *)(*the_malloc)(sizeof(CHARTYPE)*70);
 if (attr_string == (CHARTYPE *)NULL)
   {
    display_error(30,(CHARTYPE *)"",FALSE);
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
 strcpy((DEFCHAR *)attr_string,"");
 for (j=start_with;j<3;j++)
   {
    switch(j)
      {
       case GET_FG:
            colour_only = TRUE;
            match_value = (chtype)fg;
            break;
       case GET_BG:
            strcat((DEFCHAR *)attr_string,"on ");
            colour_only = TRUE;
            match_value = (chtype)bg;
            break;
       default:
            colour_only = FALSE;
            match_value = mod;
            break;
      }
    for (i=0;i<NO_ATTRIBS;i++)
      {
       if (colour_only)
         {
          if (!valid_attribs[i].attrib_modifier
          &&  match_value == (chtype)valid_attribs[i].actual_attrib)
            {
             strcat((DEFCHAR *)attr_string,(DEFCHAR *)valid_attribs[i].attrib);
             strcat((DEFCHAR *)attr_string," ");
             break;
            }
         }
       else
         {
          if (valid_attribs[i].attrib_modifier
          &&  (match_value & valid_attribs[i].actual_attrib))
            {
             strcat((DEFCHAR *)attr_string,(DEFCHAR *)valid_attribs[i].attrib);
             strcat((DEFCHAR *)attr_string," ");
             break;
            }
         }
      }
   }
#ifdef TRACE
 trace_return();
#endif
 return(attr_string);
}
