#ifndef CONVERT_PATH
#  define CONVERT_PATH "/usr/local/bin"
#endif

#ifndef NETPBM_PATH
#  define NETPBM_PATH  "/usr/local/bin"
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <time.h>                                                            
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/time.h>
#include <sys/types.h>

#ifdef _HAVE_STRING_H
#include <string.h>
#elif _HAVE_STRINGS_H
#include <strings.h>
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/extensions/XShm.h>
#include <X11/extensions/shape.h>
#include <X11/cursorfont.h>

#ifdef HAVE_LIBJPEG
#include <jpeglib.h>
#endif
#ifdef HAVE_LIBPNG
#include <png.h>
#endif
#ifdef HAVE_LIBTIFF
#include <tiffio.h>
#endif
#ifdef HAVE_LIBGIF
#include <gif_lib.h>
#endif

#define BYTE_ORD_24_RGB 0
#define BYTE_ORD_24_RBG 1
#define BYTE_ORD_24_BRG 2
#define BYTE_ORD_24_BGR 3
#define BYTE_ORD_24_GRB 4
#define BYTE_ORD_24_GBR 5


void dirty_pixmaps(ImlibData *id, ImlibImage *im);
void dirty_images(ImlibData *id, ImlibImage *im);
void find_pixmap(ImlibData *id, ImlibImage *im, int width, int height, Pixmap *pmap, Pixmap *mask);
ImlibImage *find_image(ImlibData *id, char *file);
void free_pixmappmap(ImlibData *id, Pixmap pmap);
void free_image(ImlibData *id, ImlibImage *im);
void flush_image(ImlibData *id, ImlibImage *im);
void add_image(ImlibData *id, ImlibImage *im, char *file);
void add_pixmap(ImlibData *id, ImlibImage *im, int width, int height, XImage *xim, XImage *sxim);
void clean_caches(ImlibData *id);
void nullify_image(ImlibData *id, ImlibImage *im);

void _SplitID(ImlibData *id, char *file, char *d);
void _GetExtension(ImlibData *id, char *file, char *ext);
#ifdef HAVE_LIBJPEG
unsigned char *_LoadJPEG(ImlibData *id, FILE *f, int *w, int *h);
#endif /* HAVE_LIBJPEG */
#ifdef HAVE_LIBPNG
unsigned char *_LoadPNG(ImlibData *id, FILE *f, int *w, int *h, int *t);
#endif /* HAVE_LIBPNG */
#ifdef HAVE_LIBTIFF
unsigned char *_LoadTIFF(ImlibData *id, char *f, int *w, int *h, int *t);
#endif /* HAVE_LIBTIFF */
#ifdef HAVE_LIBGIF
unsigned char *_LoadGIF(ImlibData *id, char *f, int *w, int *h, int *t);
#endif /* HAVE_LIBGIF */
unsigned char *_LoadXPM(ImlibData *id, char *f, int *w, int *h, int *t);
unsigned char *_LoadPPM(ImlibData *id, FILE *f, int *w, int *h);
int ispnm(char *file);
int isjpeg(char *file);
int ispng(char *file);
int istiff(char *file);
int iseim(char *file);
int isgif(char *file);
int isxpm(char *file);

void calc_map_tables(ImlibData *id, ImlibImage *im);

void _PaletteAlloc(ImlibData *id, int num, int *cols);

#define FAST_RGB(r,g,b) fast_rgb[(r<<10)+(g<<5)+(b)]
#define FAST_ERR(r,g,b) fast_err[(r<<10)+(g<<5)+(b)]
#define FAST_ERG(r,g,b) fast_erg[(r<<10)+(g<<5)+(b)]
#define FAST_ERB(r,g,b) fast_erb[(r<<10)+(g<<5)+(b)]
