// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  ASCLoader.h

  Creation: SR, February 9th, 1996

  Revision:
    Stephane Rehel
    April 27 1997
*/

#ifndef __ASCLoader_h
#define __ASCLoader_h

#include <stdio.h>

#ifndef __Vector_h
#include "tools/Vector.h"
#endif

#ifndef __OString_h
#include "tools/OString.h"
#endif

#ifndef __Array1_h
#include "tools/Array1.h"
#endif

class MLImporter;
class MLScene;

/////////////////////////////////////////////////////////////////////////////

class ASCLoader
{
private:
  MLImporter* importer;
  MLScene* scene;

  FILE* file;
  OString filename;
  int lineN;

public:
  ASCLoader( MLImporter* _importer );

  virtual ~ASCLoader();

  IBOOL init();
  IBOOL load();

private:
  char* getLine();
  char* getNewLine();
  IBOOL findObject( OString& name );
  IBOOL readVertexList( Array1<Point>& vertices );
  IBOOL readFaceList( const OString& object_name,
                      const Array1<Point>& vertices, int nFaces );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __ASCLoader_h
