// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  TmplEColored.h

  Stephane Rehel

  October 19 1997
*/

#ifndef __TmplEColored_h
#define __TmplEColored_h

#ifndef __TmplEngine_h
#include "tmpl/TmplEngine.h"
#endif

class MLCanvasPopup;
class MLCanvasButton;
class TmplCanvas;
class MLEvent;
class MLXORRectAction;
class TmplCommand;

/////////////////////////////////////////////////////////////////////////////

class TmplEColored: public TmplEngine
{
protected:
  double r, g, b;

  MLCanvasButton* displayTypeButton;

  MLCanvasPopup* optionsPopup;

  int options_popup_wire_front;

public:
  TmplEColored( TmplCanvas* _canvas,
              double _r = .3,
              double _g = .3,
              double _b = .3 );

  virtual ~TmplEColored();

protected:
  // return IFALSE if window is unmapped, etc.
  IBOOL _back_draw();

public:
  virtual void draw();

  virtual void refreshScreen( unsigned what );

  virtual void leaveMode( MLMode* mm );

protected:
  virtual IBOOL handleAction( MLAction* action );

  virtual void write( MLWFileBlock& block );
  virtual void read( MLRFileBlock& block );

  virtual void resetAll();

public:
  virtual void updatePopupsFlags();
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __TmplEColored_h
