


AVCALL(3)                                               AVCALL(3)


NNAAMMEE
       avcall  - build a C argument list incrementally and call a
       C function on it.

SSYYNNOOPPSSIISS
       ##iinncclluuddee <<aavvccaallll..hh>>

       aavv__aalliisstt _a_l_i_s_t;;

       aavv__ssttaarrtt___t_y_p_e((_a_l_i_s_t,, _&_f_u_n_c [[,, _r_e_t_u_r_n___t_y_p_e],, _&_r_e_t_u_r_n___v_a_l_u_e
       ]));;

       aavv___t_y_p_e((_a_l_i_s_t,, [_a_r_g___t_y_p_e,,] _v_a_l_u_e));;

       aavv__ccaallll((_a_l_i_s_t));;

DDEESSCCRRIIPPTTIIOONN
       This  set  of macros builds an argument list for a C func-
       tion and  calls  the  function  on  it.  It  significantly
       reduces  the  amount  of `glue' code required for parsers,
       debuggers, imbedded interpreters, C extensions to applica-
       tion  programs  and  other situations where collections of
       functions need to be called on  lists  of  externally-sup-
       plied arguments.

       Function  calling  conventions differ considerably on dif-
       ferent machines and _a_v_c_a_l_l attempts to provide some degree
       of isolation from such architecture dependencies.

       The  interface  is  like  ssttddaarrgg(3) in reverse. All of the
       macros return 0 for success, < 0 for failure (e.g.,  argu-
       ment list overflow or type-not-supported).

       (1)    ##iinncclluuddee <<aavvccaallll..hh>>
              and declare the argument list structure
              aavv__aalliisstt _a_l_i_s_t;;

       (2)    Set  any  special  flags.  This is architecture and
              compiler dependent.  Compiler options  that  affect
              passing  conventions  may  need  to  be  flagged by
              ##ddeeffiinnees before the ##iinncclluuddee <<aavvccaallll..hh>>  statement.
              However,  the  _c_o_n_f_i_g_u_r_e  script should have deter-
              mined which ##ddeeffiinnees are needed and put them at the
              top of aavvccaallll..hh.

       (3)    Initialize  the alist with the function address and
              return value pointer (if any). There is a  separate
              macro   for   each  simple  return  type  ([u]char,
              [u]short, [u]int, [u]long, [u]longlong, float, dou-
              ble,  where  `u'  indicates `unsigned'). The macros
              for  functions  returning  structures  or  pointers
              require an explicit type argument.

       E.g.,



                           29 June 1997                         1





AVCALL(3)                                               AVCALL(3)


       aavv__ssttaarrtt__iinntt ((_a_l_i_s_t,, _&_f_u_n_c,, _&_i_n_t___r_e_t_u_r_n));;

       aavv__ssttaarrtt__ddoouubbllee ((_a_l_i_s_t,, _&_f_u_n_c,, _&_d_o_u_b_l_e___r_e_t_u_r_n));;

       aavv__ssttaarrtt__vvooiidd ((_a_l_i_s_t,, _&_f_u_n_c));;

       aavv__ssttaarrtt__ssttrruucctt ((_a_l_i_s_t,, _&_f_u_n_c,, _s_t_r_u_c_t___t_y_p_e,, _s_p_l_i_t_t_a_b_l_e,,
                        _&_s_t_r_u_c_t___r_e_t_u_r_n));;

       aavv__ssttaarrtt__ppttrr ((_a_l_i_s_t,, _&_f_u_n_c,, _p_o_i_n_t_e_r___t_y_p_e,,
                     _&_p_o_i_n_t_e_r___r_e_t_u_r_n));;

       The  _s_p_l_i_t_t_a_b_l_e flag specifies whether the _s_t_r_u_c_t___t_y_p_e can
       be returned in registers such that every struct field fits
       entirely  in a single register. This needs to be specified
       for structs of size 2*sizeof(long). For structs of size <=
       sizeof(long),  _s_p_l_i_t_t_a_b_l_e  is ignored and assumed to be 1.
       For  structs  of  size  >  2*sizeof(long),  _s_p_l_i_t_t_a_b_l_e  is
       ignored  and  assumed to be 0. There are some handy macros
       for this:
       aavv__wwoorrdd__sspplliittttaabbllee__11 ((_t_y_p_e_1))
       aavv__wwoorrdd__sspplliittttaabbllee__22 ((_t_y_p_e_1,, _t_y_p_e_2))
       aavv__wwoorrdd__sspplliittttaabbllee__33 ((_t_y_p_e_1,, _t_y_p_e_2,, _t_y_p_e_3))
       aavv__wwoorrdd__sspplliittttaabbllee__44 ((_t_y_p_e_1,, _t_y_p_e_2,, _t_y_p_e_3,, _t_y_p_e_4))
       For a struct with three slots
       ssttrruucctt {{ _t_y_p_e_1 _i_d_1;; _t_y_p_e_2 _i_d_2;; _t_y_p_e_3 _i_d_3;; }}
       you can specify _s_p_l_i_t_t_a_b_l_e as aavv__wwoorrdd__sspplliittttaabbllee__33 ((_t_y_p_e_1,,
       _t_y_p_e_2,, _t_y_p_e_3)) .

       (4)    Push  the  arguments on to the list in order. Again
              there is a macro for each simple built-in type, and
              the  macros  for  structure  and  pointer arguments
              require an extra type argument:

       aavv__iinntt ((_a_l_i_s_t,, _i_n_t___v_a_l_u_e));;

       aavv__ddoouubbllee ((_a_l_i_s_t,, _d_o_u_b_l_e___v_a_l_u_e));;

       aavv__ssttrruucctt ((_a_l_i_s_t,, _s_t_r_u_c_t___o_r___u_n_i_o_n___t_y_p_e,, _s_t_r_u_c_t___v_a_l_u_e));;

       aavv__ppttrr ((_a_l_i_s_t,, _p_o_i_n_t_e_r___t_y_p_e,, _p_o_i_n_t_e_r___v_a_l_u_e));;

       (5)    Call the function, set the return value,  and  tidy
              up:

       aavv__ccaallll ((_a_l_i_s_t));;


NNOOTTEESS
       (1)  Functions  whose  first declaration is in Kernighan &
       Ritchie style (i.e., without a typed argument  list)  MUST
       use default K&R C expression promotions (char and short to
       int, float to double) whether they are compiled by  a  K&R
       or  an  ANSI compiler, because the true argument types may



                           29 June 1997                         2





AVCALL(3)                                               AVCALL(3)


       not be known at the call point. Such  functions  typically
       back-convert  their  arguments  to  the  declared types on
       function entry. (In fact, the only  way  to  pass  a  true
       char,  short  or  float  in  K&R C is by an explicit cast:
       ffuunncc((((cchhaarr))cc,,((ffllooaatt))ff)) ).  Similarly, some  K&R  compilers
       (such as Sun cc on the sparc) actually return a float as a
       double.

       Hence, for arguments of functions declared  in  K&R  style
       you  should  use  aavv__iinntt(())  and  aavv__ddoouubbllee(())  rather  than
       aavv__cchhaarr(()),, aavv__sshhoorrtt(()) or aavv__ffllooaatt(())..  If  you  use  a  K&R
       compiler,  the  avcall  header files may be able to detect
       this and define aavv__ffllooaatt(()),, etc, appropriately,  but  with
       an  ANSI  compiler  there  is no way _a_v_c_a_l_l can know how a
       function was declared, so you have to correct the argument
       types yourself.

       (2)  The  explicit  type  arguments of the aavv__ssttrruucctt(()) and
       aavv__ppttrr(()) macros are  typically  used  to  calculate  size,
       alignment,  and passing conventions.  This may not be suf-
       ficient for  some  machines  with  unusual  structure  and
       pointer  handling: in this case additional aavv__ssttaarrtt___t_y_p_e(())
       and aavv___t_y_p_e(()) macros may be defined.

       (3) The macros aavv__ssttaarrtt__lloonngglloonngg(()),  aavv__ssttaarrtt__uulloonngglloonngg(()),
       aavv__lloonngglloonngg(())  and  aavv__uulloonngglloonngg(()) work only if the C com-
       piler has a working lloonngg lloonngg 64-bit integer type.


SSEEEE AALLSSOO
       ssttddaarrgg(3), vvaarraarrggss(3).


BBUUGGSS
       The current implementations have been tested on  a  selec-
       tion  of  common  cases  but there are probably still many
       bugs.

       There are typically built-in limits on  the  size  of  the
       argument-list,  which  may  also  include  the size of any
       structure arguments.

       The decision whether a struct is to be returned in  regis-
       ters  or  in  memory  considers only the struct's size and
       alignment. This is inaccurate: for example, gcc  on  m68k-
       next  returns  ssttrruucctt  {{  cchhaarr  aa,,bb,,cc;;  }} in registers and
       ssttrruucctt {{ cchhaarr aa[[33]];; }} in memory, although both types  have
       the same size and the same alignment.


PPOORRTTIINNGG AAVVCCAALLLL
       Ports,  bug-fixes,  and  suggestions are most welcome. The
       macros required for argument pushing  are  pretty  grungy,
       but  it does seem to be possible to port avcall to a range



                           29 June 1997                         3





AVCALL(3)                                               AVCALL(3)


       of machines. Ports to non-standard or non-32-bit  machines
       are  especially  welcome  so we can sort the interface out
       before it's too late.

       Knowledge about argument passing conventions can be  found
       in  the  gcc source, file gcc-2.6.3/config/_c_p_u/_c_p_u.h, sec-
       tion "Stack layout; function entry, exit and calling."

       Some of the grunge is usually handled by a C  or  assembly
       level  glue  routine  that  actually pushes the arguments,
       calls the function and unpacks any return value.  This  is
       called __builtin_avcall(). A precompiled assembler version
       for people without gcc is also made available. The routine
       should  ideally  have flags for the passing conventions of
       other compilers.

       Many of the current routines waste a lot  of  stack  space
       and generally do hairy things to stack frames - a bit more
       assembly code would probably help things along quite a bit
       here.


AAUUTTHHOORR
       Bill Triggs <bill@robots.oxford.ac.uk>.


AACCKKNNOOWWLLEEDDGGEEMMEENNTTSS
       Some initial ideas were stolen from the C interface to the
       Zelk extensions to Oliver Laumann's Elk scheme interpreter
       by  J.P.Lewis,  NEC  C&C Research, <zilla@ccrl.nj.nec.com>
       (for    Sun4    &    SGI),    and    Roy    Featherstone's
       <roy@robots.oxford.ac.uk> personal C interface library for
       Sun[34] & SGI.  I also  looked  at  the  machine-dependent
       parts  of  the  GCC and GDB distributions, and put the gcc
       asm() extensions to good use. Thanks guys!

       This work was partly supported by EC-ESPRIT Basic Research
       Action SECOND.



















                           29 June 1997                         4


