""" Demonstration of the Pmw EntryField megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create and pack the EntryFields.
	self._any = Pmw.EntryField(parent,
		labelpos = 'w',
		label_text = 'Any:',
		command = self.execute)
	self._real = Pmw.EntryField(parent,
		labelpos = 'w',
		value = '+2.9979e+8',
		label_text = 'Real:',
		validate = 'real',
		modifiedcommand = self.changed)
	self._odd = Pmw.EntryField(parent,
		labelpos = 'w',
		label_text = 'Odd length:',
		value = 'ABC',
		validate = self.custom_validate)

	entries = (self._any, self._real, self._odd)

	for entry in entries:
	    entry.pack(fill='x', expand=1, padx=10, pady=5)
	Pmw.alignlabels(entries)

	self._any.component('entry').focus_set()

    def changed(self):
	print 'Text changed, value is', self._real.get()

    def execute(self):
	print 'Return pressed, value is', self._any.get()

    # This implements a custom validation routine.  It simply checks
    # if the string is of odd length.
    def custom_validate(self, text):
	print 'text:', text
	if len(text) % 2 == 0:
	  return -1
	else:
	  return 1

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw EntryField demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
