"""
Module             PmwGroup.py

author             Case Roole <cjr@bound.xs4all.nl>
"""

import string
import sys
import Tkinter
import Pmw

def aligngrouptags(groups):
    "Set the 'ringunits' of the groups to one value."

    maxunit = max( map( lambda x: x.ringunit, groups ) )
    for group in groups:
	group.setringunit(maxunit)

class Group( Pmw.MegaWidget ):
    def __init__(self, parent = None, **kw):

        # Define the megawidget options.
	INITOPT = Pmw.INITOPT
        optiondefs = (
	    ('ring_borderwidth', 2,         None),
	    ('ring_relief',      'groove',  None),
	    ('ringpadx',         2,         INITOPT),
	    ('ringpady',         2,         INITOPT),
	    )
        self.defineoptions(kw, optiondefs)

        # Initialise the base class (after defining the options).
        Pmw.MegaWidget.__init__(self, parent)

        # Create the components.
        interior = Pmw.MegaWidget.interior(self)
	self.oldInterior = interior

	self._ring = self.createcomponent(
	    'ring', 
	    (), None,
	    Tkinter.Frame, (interior,), 
	    )

	self._groupChildSite = self.createcomponent(
	    'groupchildsite',
	    (), None,
	    Tkinter.Frame, (self._ring,)
	    )

        unit = self.ringunit = self.createtag(self.component('hull'))

	padx = self['ringpadx']
	pady = self['ringpady']
	self._ring.grid(column = 1, row = 1, sticky = 'nsew')
	interior.grid_columnconfigure(1, weight = 1)
	interior.grid_columnconfigure(0, minsize = padx)
	interior.grid_columnconfigure(2, minsize = padx)
	interior.grid_rowconfigure(1, weight = 1)
	interior.grid_rowconfigure(0, minsize = unit)
	interior.grid_rowconfigure(2, minsize = pady)

	self._groupChildSite.grid(column = 1, row = 1, sticky = 'nsew')
	self._ring.grid_columnconfigure(1, weight = 1)
	self._ring.grid_columnconfigure(0, minsize = padx)
	self._ring.grid_columnconfigure(2, minsize = padx)
	self._ring.grid_rowconfigure(1, weight = 1)
	self._ring.grid_rowconfigure(0, minsize = unit)
	self._ring.grid_rowconfigure(2, minsize = pady)

	#self._ring.pack(padx=self['ringpadx'],
	#	pady=unit, expand=1,fill='both')
	#self._groupChildSite.pack(padx=self['ringpadx'],
	#	pady=unit, expand=1,fill='both')
						    
        # Check keywords and initialise options.
        self.initialiseoptions(Group)

    def interior(self):
        return self._groupChildSite

    def createtag(self, parent ):

        self.tag = self.createcomponent(
	    'tag',
	    (), None,
	    Tkinter.Label, (parent,),
	    )

	if self.tag is None:
	    return self['ringpady']

	unit = self.tag.winfo_reqheight()/2
	self.tag.place(x=unit,y=unit,anchor='w')
	return unit

    def setringunit(self,unit):
	self.ringunit = unit

	self.oldInterior.grid_rowconfigure(0, minsize = unit)
	self._ring.grid_rowconfigure(0, minsize = unit)
	#self._ring.pack(pady=unit)
	#self._groupChildSite.pack(pady=unit)

	self.tag.place(x=unit,y=unit,anchor='w')

