/*
 * bltList.h --
 *
 * Copyright 1993-1997 Bell Labs Innovations for Lucent Technologies.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that the
 * copyright notice and warranty disclaimer appear in supporting documentation,
 * and that the names of Lucent Technologies any of their entities not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Lucent Technologies disclaims all warranties with regard to this software,
 * including all implied warranties of merchantability and fitness.  In no event
 * shall Lucent Technologies be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of use,
 * data or profits, whether in an action of contract, negligence or other
 * tortuous action, arising out of or in connection with the use or performance
 * of this software.  
 */
#ifndef _BLT_LIST_H
#define _BLT_LIST_H

typedef struct Blt_List Blt_List;

/*
 * A Blt_ListItem is the container structure for the Blt_List.
 */
typedef struct Blt_ListItem {
    struct Blt_ListItem *prevPtr;	/* Link to the previous item */
    struct Blt_ListItem *nextPtr;	/* Link to the next item */
    ClientData clientData;		/* Pointer to the data object */
    struct Blt_List *listPtr;		/* List to eventually insert item */
    union {                             /* Key has one of these forms: */
        char *oneWordValue;             /* One-word value for key. */
        int words[1];                   /* Multiple integer words for key.
                                         * The actual size will be as large
                                         * as necessary for this table's
                                         * keys. */
        char string[4];                 /* String for key.  The actual size
                                         * will be as large as needed to hold
                                         * the key. */
    } key;                              /* MUST BE LAST FIELD IN RECORD!! */
} Blt_ListItem;

typedef Blt_ListItem *(Blt_ListFindProc) _ANSI_ARGS_((Blt_List *listPtr, 
      char *key));

/*
 * A Blt_List is a doubly chained list structure.
 */
struct Blt_List {
    Blt_ListItem *headPtr;	/* Pointer to first element in list */
    Blt_ListItem *tailPtr;	/* Pointer to last element in list */
    int numEntries;		/* Number of elements in list */
    int type;			/* Type of keys in list */
    Blt_ListFindProc *findProc;
};

EXTERN void Blt_InitList _ANSI_ARGS_((Blt_List *listPtr, int type));
EXTERN Blt_List *Blt_CreateList _ANSI_ARGS_((int type));
EXTERN void Blt_ListDestroy _ANSI_ARGS_((Blt_List *listPtr));
EXTERN Blt_ListItem *Blt_ListNewItem _ANSI_ARGS_((Blt_List *listPtr, char *key));
EXTERN Blt_ListItem *Blt_ListAppend _ANSI_ARGS_((Blt_List *listPtr, char *key, 
	ClientData clientData));
EXTERN void Blt_ListReset _ANSI_ARGS_((Blt_List *listPtr));
EXTERN void Blt_ListLinkAfter _ANSI_ARGS_((Blt_List *listPtr, Blt_ListItem *itemPtr,
	Blt_ListItem *afterPtr));
EXTERN void Blt_ListLinkBefore _ANSI_ARGS_((Blt_List *listPtr, 
	Blt_ListItem *itemPtr, Blt_ListItem *beforePtr));
EXTERN void Blt_ListUnlinkItem _ANSI_ARGS_((Blt_ListItem *itemPtr));
EXTERN Blt_ListItem *Blt_ListFind _ANSI_ARGS_((Blt_List *listPtr, char *name));
EXTERN void Blt_ListDeleteItem _ANSI_ARGS_((Blt_ListItem *itemPtr));
EXTERN void Blt_ListDelete _ANSI_ARGS_((Blt_List *listPtr, char *name));

#define Blt_ListGetLength(listPtr)	((listPtr)->numEntries)
#define Blt_ListFirstItem(listPtr)	((listPtr)->headPtr)
#define Blt_ListLastItem(listPtr)	((listPtr)->tailPtr)
#define Blt_ListPrevItem(itemPtr)	((itemPtr)->prevPtr)
#define Blt_ListNextItem(itemPtr) 	((itemPtr)->nextPtr)
#define Blt_ListGetKey(itemPtr)	\
	((itemPtr->listPtr->type == TCL_STRING_KEYS) \
	 ? (itemPtr)->key.string : (itemPtr)->key.oneWordValue)
#define Blt_ListGetValue(itemPtr)  	((itemPtr)->clientData)
#define Blt_ListSetValue(itemPtr, valuePtr) \
	((itemPtr)->clientData = (ClientData)(valuePtr))
#define Blt_ListAppendItem(listPtr, itemPtr) \
	(Blt_ListLinkBefore((listPtr), (itemPtr), (Blt_ListItem *)NULL))
#define Blt_ListPrependItem(listPtr, itemPtr) \
	(Blt_ListLinkAfter((listPtr), (itemPtr), (Blt_ListItem *)NULL))

#endif /* _BLT_LIST_H */


