# $Id: mk-0th.awk,v 1.3 1996/12/01 00:27:23 tom Exp $
################################################################################
# Copyright 1996 by Thomas E. Dickey <dickey@clark.net>                        #
# All Rights Reserved.                                                         #
#                                                                              #
# Permission to use, copy, modify, and distribute this software and its        #
# documentation for any purpose and without fee is hereby granted, provided    #
# that the above copyright notice appear in all copies and that both that      #
# copyright notice and this permission notice appear in supporting             #
# documentation, and that the name of the above listed copyright holder(s) not #
# be used in advertising or publicity pertaining to distribution of the        #
# software without specific, written prior permission. THE ABOVE LISTED        #
# COPYRIGHT HOLDER(S) DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,    #
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT #
# SHALL THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE FOR ANY SPECIAL,        #
# INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM   #
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE   #
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    #
# PERFORMANCE OF THIS SOFTWARE.                                                #
################################################################################
# Generate list of sources for a library, together with lint/lintlib rules
#
# Variables:
#	name (library name, e.g., "ncurses", "panel", "forms", "menus")
#
BEGIN	{
		print  ""
		print  "# generated by mk-0th.awk"
		print  ""
		found = 0;
	}
	!/^#/ {
		if ( $2 == "lib" )
		{
			if ( found == 0 )
			{
				printf "C_SRC ="
				found = 1
			}
			printf " \\\n\t%s/%s.c", $3, $1
		}
	}
END	{
		print  ""
		if ( found != 0 )
		{
			print  ""
			printf "# Producing llib-l%s is time-consuming, so there's no direct-dependency for\n", name
			print  "# it in the lintlib rule.  We'll only remove in the cleanest setup."
			print  "clean ::"
			printf "\trm -f llib-l%s.*\n", name
			print  ""
			print  "realclean ::"
			printf "\trm -f llib-l%s\n", name
			print  ""
			printf "llib-l%s : $(C_SRC)\n", name
			printf "\tcproto -a -l -DLINT $(CPPFLAGS) $(C_SRC) >$@\n"
			print  ""
			print  "lintlib :"
			printf "\t$(srcdir)/../misc/makellib %s $(CPPFLAGS)", name
			print ""
			print "lint :"
			print "\t$(LINT) $(LINT_OPTS) $(CPPFLAGS) $(C_SRC) $(LINT_LIBS)"
		}
		else
		{
			print  "lintlib :"
			print  "\t@echo no action needed"
		}
	}
