/*********************************************************************
 *   Copyright 1996, UCAR/Unidata
 *   See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *   $Id: error.c,v 1.3 1996/07/16 23:06:51 hld Exp $
 *********************************************************************/

#include <stdio.h>
#include <stdarg.h>

extern int  nfails;             /* number of failures in specific test */
extern int  max_nmpt;		/* max. number of messages per test */

/*
 * Use for logging error conditions
 */
void
error(const char *fmt, ...)
{
    va_list args ;

    va_start(args, fmt) ;
    if (nfails <= max_nmpt)
	(void) vfprintf(stderr,fmt,args) ;
    va_end(args) ;
}

/*
 * Use for general printing (other than error conditions)
 * This also currently goes to stderr, but this could change
 */
void
print(const char *fmt, ...)
{
    va_list args ;

    va_start(args, fmt) ;
    (void) vfprintf(stderr,fmt,args) ;
    va_end(args) ;
}

/*
 * Called by macro IF
 */
int
ifFail(const int expr, const int line, const char *file)
{
    if (expr) {
	++nfails;
	error("\n\tFAILURE at line %d of %s: ", line, file);
    }
    return expr;
}
