/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@sdsu.edu>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * $Id: file_read.c,v 2.1 1997/01/05 18:41:39 papowell Exp $
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

/*
 * Read a line from a descriptor.  Read the line one byte at a time,
 * looking for a newline.  We store the newline in the buffer,
 * then follow it with a null (the same as fgets(3)).
 * We return the number of characters up to, but not including,
 * the null (the same as strlen(3)).
 */

int
file_readline(fd, ptr, maxlen)
	int    fd;
	char   *ptr;
	int    maxlen;
{
    int  n, rc = 0;

    for( n = 0; n < maxlen && (rc = read(fd,&ptr[n],1)) > 0; n++ ){
		if( ptr[n] == '\n' || ptr[n] == '\r' ){
			n++;
			break;
		}
	}
	ptr[n] = 0;
	if( n == 0 && rc < 0 ){
		n = rc;
	}
    return(n);
}

