/***

packet.c - routines to open the raw socket, read socket data and
           adjust the initial packet pointer
           
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997, 1998

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***/

#include <curses.h>
#include <panel.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <unistd.h>
#include <net/if_arp.h>
#include <linux/if_packet.h>
#include "if_ether.h"
#include "deskman.h"
#include "error.h"

void open_socket(int *fd)
{
    int dummy;

    *fd = socket(PF_INET, SOCK_PACKET, htons(ETH_P_ALL));

    if (fd < 0) {
	errbox("Unable to open raw socket", ANYKEY_MSG, &dummy);
	return;
    }
}

void adjustpacket(char *tpacket, unsigned short family, char **packet,
		  int *readlen)
{
    switch (family) {
    case ARPHRD_ETHER:
    case ARPHRD_LOOPBACK:
	*packet = tpacket + ETH_HLEN;
	*readlen -= ETH_HLEN;
	break;
    case ARPHRD_SLIP:
    case ARPHRD_PPP:
    case ARPHRD_CSLIP:
    case ARPHRD_SLIP6:
    case ARPHRD_CSLIP6:
    case ARPHRD_ADAPT:
	*packet = tpacket;
	break;
    default:
	*packet = (char *) NULL;	/* return a NULL packet to signal */
	break;			/* an unrecognized link protocol */
    }				/* to the caller.  Hopefully, this */
}				/* switch statement will grow. */

void getpacket(int fd, char *buf, struct sockaddr_pkt *fromaddr,
	       int *ch, int *br, unsigned long timeout, WINDOW * win)
{
    int fromlen;
    fd_set set;
    struct timeval tv;
    struct timeval *ptv;

    FD_ZERO(&set);
    FD_SET(0, &set);
    FD_SET(fd, &set);

    if (timeout > 0) {
	tv.tv_sec = timeout;
	tv.tv_usec = 0;
	ptv = &tv;
    } else
	ptv = NULL;

    select(fd + 1, &set, 0, 0, ptv);

    *br = 0;
    *ch = ERR;

    if (FD_ISSET(fd, &set)) {
	fromlen = sizeof(struct sockaddr_pkt);
	*br = recvfrom(fd, buf, 8192, 0,
		       (struct sockaddr *) fromaddr, &fromlen);
    }
    if (FD_ISSET(0, &set)) {
	*ch = wgetch(win);
    }
}
