/*
 * Copyright (c) 1997 Adrian Sun (asun@zoology.washington.edu)
 * All rights reserved. See COPYRIGHT.
 */

#include <stdio.h>
#include <atalk/dsi.h>
#include <netatalk/endian.h>

/* this assumes that the reply follows right after the command, saving
 * on a couple assignments. specifically, command, requestID, and
 * reserved field are assumed to already be set. the noreply field is
 * used to prevent a reply (as one may already have been sent). it's
 * a one-shot toggle. */
int dsi_cmdreply(DSI *dsi, int err)
{
  /* don't do anything if noreply is set. used by dsi_read. */
  if (dsi->noreply) {
    dsi->noreply = 0;
    return 1;
  }

  dsi->header.dsi_flags = DSIFL_REPLY;
  /*dsi->header.dsi_command = DSIFUNC_CMD;*/
  dsi->header.dsi_len = htonl(dsi->datalen);
  dsi->header.dsi_code = htonl(err);

  return dsi->proto_send(dsi, dsi->data, dsi->datalen);
}
