/*
 * Copyright (c) 1997 Adrian Sun (asun@zoology.washington.edu)
 * All rights reserved. See COPYRIGHT.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>

#include <atalk/dsi.h>

#ifndef min
#define min(a,b)   ((a) < (b) ? (a) : (b))
#endif

/* streaming i/o for afp_read. this is all from the perspective of the
 * client. it basically does the reverse of dsi_write. on first entry,
 * it will send off the header plus whatever is in its command
 * buffer. it returns the amount of stuff still to be read
 * (constrained by the buffer size). */
size_t dsi_readinit(DSI *dsi, void *buf, const size_t buflen,
		    const size_t size)
{
  dsi->noreply = 1; /* we will handle our own replies */
  dsi->header.dsi_flags = DSIFL_REPLY;
  /*dsi->header.dsi_command = DSIFUNC_CMD;*/
  dsi->header.dsi_len = htonl(size);

  sigaction(dsi->signals.ignore, &dsi->signals.act, &dsi->signals.save);
  sigprocmask(SIG_BLOCK, &dsi->signals.block, NULL);
  if (dsi->proto_send(dsi, buf, buflen))
    dsi->datasize = size - buflen;
  
  return min(dsi->datasize, buflen);
}

void dsi_readdone(DSI *dsi)
{
  sigprocmask(SIG_UNBLOCK, &dsi->signals.block, NULL);
  sigaction(dsi->signals.ignore, &dsi->signals.save, NULL);
}

/* send off the data */
size_t dsi_read(DSI *dsi, void *buf, const size_t buflen)
{
  dsi->datasize -= dsi->proto_raw_write(dsi, buf, buflen);
  return min(dsi->datasize, buflen);
}
