/*
 *  qftp
 *  Copyright (C) 1997,1998 Peter Strand
 *  Distributed under the GNU Pulic Licence
 */


#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>

#include "conf.h"
#include "txtif.h"
#include "flist.h"
#include "ftpconn.h"

#if __GLIBC__ < 2
typedef __sighandler_t sig_t;
#endif

#define NCPROMPT "qftp> "
#define PROMPTF "%s:%s%%%% "


TxtIF::TxtIF()
{
}

TxtIF::TxtIF(FtpConn *nftp, Conf &nconf)
{
	char *p, tmp[256];
	ftp = nftp;
	gconf.opts = nconf.opts;
	opts.force = opts.cont = opts.longl = opts.anon = 0;
	strcpy(anonuser, "ftp");
	if (gethostname(tmp, 256) == -1)
		strcpy(tmp, "foo.bar");
	sprintf(anonpass, "%s@%s", (p = getenv("LOGNAME"))?p:"unknown", tmp);
	strcpy(prompt, NCPROMPT);
}

void TxtIF::go()
{
	char buf[512];
	char *p, *t, *f[100];
	int i, n;
	do {

		printf(prompt);
		fflush(stdout);
		if (!fgets(buf, 512, stdin))
			exit(0);
		buf[strlen(buf) - 1] = 0;
		p = buf;

		while (isspace(*p))
			p++;
		i = lookup(p);
		n = procargs(buf, f);
		switch (i) {
		case 0: Open(n, f); break;
		case 1: Cd(n, f); break;
		case 2: List(n, f); break;
		case 3: LongList(n, f); break;
		case 4: Close(n, f); break;
		case 5: Quote(n, f); break;
		case 6: Get(n, f); break;
		case 7: Put(n, f); break;
		case 8: LCd(n, f); break;
		case 9: Help(n, f); break;
		case 10: View(n, f); break;
		case 11: Set(n, f); break;
		case 12: Khelp(n, f); break;
		default: break;
		}
		
	} while(1);
}

void TrStat(int n)
{
	static int count;
	if (n == -1)
		count = 0;
	else
		count += n;
	printf("\r%10lu bytes transferred", count);
	fflush(stdout);

}

int TxtIF::Set(int n, char *a[])
{
	char *p;
	int i = 0;
	if (n > 1) {
		Conf conf(gconf, n, a, "bzfclas:nrqu:BZFCLASNRQU");
		gconf.opts = conf.opts;
	} else {
		gconf.print();
	}
}

int TxtIF::View(int n, char *a[])
{
	int i, pid, fd[2];
	char *p, c, *pager, pg[256], *z;
	FILE *fp;
	sig_t sigh;
	Conf conf(gconf, n, a, "zZ");

	if (!(pager = getenv("PAGER")))
		pager = PAGER;
	
	while (p = a[optind++]) {
		sigh = signal(SIGPIPE, SIG_IGN);
		pg[0] = 0;
		z = strrchr(p, '.') + 1;
		if (conf.opts.proc && (!strcmp(z, "gz") || !strcmp(z, "Z")))
			strcat(pg, "gzip -dc|");
		strcat(pg, pager);
		fp = popen(pg, "w");
		ftp->Get(p, fileno(fp));
		pclose(fp);
		signal(SIGPIPE, sigh);
	}
}

int TxtIF::LCd(int n, char *a[])
{
	char buf[512];
	chdir(a[1]);
	printf("Local directory now: %s\n", getcwd(buf, 512));
}

int TxtIF::Help(int n, char *a[])
{
	ftp->Cmd("HELP", a[1]);
	printf(ftp->GetMsg());
}



int TxtIF::Get(int n, char *a[])
{
	char *p;
	FileInf fi;
	Conf conf(gconf, n, a, "bcfrBCFR");
	
	while (p = a[optind++]) {
		if (*p == '#')
			if (curList.GetFileAt(fi, atoi(&p[1])))
				p = fi.name;
		Get(conf, p);
	}
}

int TxtIF::Get(Conf &conf, char *p, FtpConn *nftp = NULL)
{
	FtpConn *cftp = (nftp)?nftp:ftp;
	int fd;
	char tmp[100];
	
	if (conf.opts.bg) {
		if (!fork()) {
			FtpConn nftp;
			nftp.Connect(ftp->GetHost());
			nftp.Login(user, pass);
			nftp.Quote("type i");
			nftp.Cd(ftp->GetCwd());
			conf.opts.bg = 0;
			conf.opts.quiet = 1;
			Get(conf, p, &nftp);
			exit(0);
		} else
			return 0;
	}
	if (conf.opts.rec) {
		if (cftp->Cd(p) < 300) {
			mkdir(p, 0777);
			chdir(p);
			FileList fl;
			FileInf fi;
			cftp->List(fl);
			fl.Reset();
			while (fl.GetFile(fi))
					Get(conf, fi.name, cftp);
			chdir("..");
			cftp->Cd("..");
		}
	} 
	if (conf.opts.cont) {
		struct stat st;
		if (stat(p, &st))
			st.st_size = 0;
		fd = open(p, O_CREAT | O_APPEND | O_WRONLY, 0666);
		if (st.st_size) {
			sprintf(tmp, "%d", st.st_size);
			ftp->Cmd("REST", tmp);
		}
	} else {
		if (conf.opts.force)
			fd = open(p, O_CREAT | O_WRONLY, 0666);
		else {
			if ((fd = open(p, O_CREAT | O_EXCL | O_WRONLY, 0666)) == -1) {
				perror(p);
				return 1;
			}
		}
	}
	cftp->Get(p, fd, (conf.opts.quiet)?NULL:TrStat);
	putchar('\n');
	close(fd);
	return 0;
}

int TxtIF::Put(int n, char *a[])
{

	char c, *p;
	int fd;
	Conf conf(gconf, n, a, "cf");
	
	while (p = a[optind++]) {
		fd = open(p, O_RDONLY);
		ftp->Put(p, fd, TrStat);
		putchar('\n');
		close(fd);
	}
}

int TxtIF::Quote(int n, char *a[])
{
	char c, *p, tmp[200];
	int i;
	tmp[0] = 0;
	i = 1;
	if (i < n) {
		do {
			strcat(tmp, a[i++]);
			if (i < n)
				strcat(tmp, " ");
		} while  (i < n);
		ftp->Quote(tmp);
		printf(ftp->GetMsg());
	}
}

int TxtIF::Open(int n, char *a[])
{
	char *p1, *p2;
  	char c, *p, conn = 0;
	int i;

	Conf conf(gconf, n, a, "ans:u:");
	pass[0] = 0;
	p1 = strchr(conf.opts.user, ':');
	if (p1) {
		strncpy(user, conf.opts.user, p1 - conf.opts.user);
		user[p1 - conf.opts.user] = 0;
		p1++;
		if (*p1)
			strcpy(pass, p1);
	} else 
		strcpy(user, conf.opts.user);
	if (!(p = a[optind]))
		return 1;
	ftp->Close();
	while (conf.opts.retry-- + 1 && !conn) {
		if (ftp->Connect(p)) {
			p1 = (char *)ftp->GetError();
			if (!p1)
				p1 = ftp->GetMsg();
			fprintf(stderr, "%s\n", p1);
			sleep(conf.opts.retrsl);
			ftp->Close();
			continue;
		}
		printf(ftp->GetMsg());
		if (conf.opts.anon) {
			strcpy(user, anonuser);
			strcpy(pass, anonpass);
		} else if ((!*user || !*pass) || conf.opts.noinf){
			printf("%s(%s): ", ftp->GetHost(), (p1 = getenv("LOGNAME"))?p1:"ftp");
			fflush(stdout);
			if (!fgets(user, 512, stdin) || user[0] == '\n')
				strcpy(user, p1);
			p2 = getpass("password: ");
			strcpy(pass, p2);
		}
		if (ftp->Login(user, pass)) {
			p1 = (char *)ftp->GetError();
			if (!p1)
				p1  = ftp->GetMsg();
			fprintf(stderr, "%s\n", p1);
			sleep(conf.opts.retrsl);
			continue;
		}
		conn = 1;
	}
	if (!conn)
		return 1;
	printf(ftp->GetMsg());
	ftp->Quote("TYPE I");
	sprintf(prompt, PROMPTF, ftp->GetHost(), ftp->GetCwd());
	return 0;
}

int TxtIF::Close(int n, char *a[])
{
	ftp->Close();
	sprintf(prompt, NCPROMPT);
}


int TxtIF::List(int n, char *a[])
{
	char *p, tmp[256];
	int i;
	FileList fl;
	FileInf fi;
	Conf conf(gconf, n, a, "l");
	
	
	tmp[0] = 0;
	i = 1;
	if (i < n)
		do {
			strcat(tmp, a[i++]);
			if (i < n)
				strcat(tmp, " ");
		} while (i < n);
	i = 1;
	if (conf.opts.longl)
		i = ftp->LongList(fl, tmp);
	else
		i = ftp->List(fl, tmp);
	if (i == -1 && !conf.opts.quiet)
		printf(ftp->GetMsg());
	fl.Reset();
	i = 1;
	while (fl.GetFile(fi)) {
		if (conf.opts.longl)
			printf("%3d %s %8lu %s\n", i, fi.date, fi.size, fi.name);
		else
			printf("%3d %s\n", i, fi.name);
		curList.AddFile(fi);
		i++;
	}
}

int TxtIF::LongList(int n, char *a[])
{
	a[n] = "-l";
	return List(n + 1, a);
}

int TxtIF::Cd(int n, char *a[])
{
  	char *p;

	if (ftp->Cd(a[1]?a[1]:a[0]) < 300)
		sprintf(prompt, PROMPTF, ftp->GetHost(), ftp->GetCwd());
}

int TxtIF::lookup(char *s)
{
	int i;
	char *p;
	if (isalpha(s[1])) {
		if ((p = strchr(s, ' ')))
			i = p - s;
		else
			i = strlen(s);
		if (i <= 4 && !strncmp(s, "open", i))
			return 0;
		if (i <= 2 && !strncmp(s, "cd", i))
			return 1;
		if (i <= 2 && !strncmp(s, "ls", i))
			return 2;
		if (i <= 3 && !strncmp(s, "dir", i))
			return 3;
		if (i <= 5 && !strncmp(s, "close", i))
			return 4;
		if (i <= 5 && !strncmp(s, "quote", i))
			return 5;
		if (i <= 3 && !strncmp(s, "get", i))
			return 6;
		if (i <= 3 && !strncmp(s, "put", i))
			return 7;
		if (i <= 3 && !strncmp(s, "lcd", i))
			return 8;
		if (i <= 4 && !strncmp(s, "help", i))
			return 9;
		if (i <= 4 && !strncmp(s, "view", i))
			return 10;
		if (i <= 3 && !strncmp(s, "set", i))
			return 11;
		if (i <= 4 && !strncmp(s, "keys", i))
			return 12;
		return 1;
	} else {
		switch(*s) {
		case 'o': return 0;
		case 'c': return 1;
		case 'l': return 2;
		case 'd': return 3;
		case 'x': return 4;
		case 'Q': return 5;
		case 'g': return 6;
		case 'p': return 7;
		case 'C': return 8;
		case 'h': return 9;
		case 'v': return 10;
		case 's': return 11;
		case '?': return 12;
		default: return 1;
		}
	}
	return -1;
}


int TxtIF::Khelp(int n, char *a[]) 
{
	printf("Commands:\n");
	printf("  ?  keys \n");
	printf("  C  lcd \n");
	printf("  Q  quote \n");
	printf("  c  cd \n");
	printf("  d  dir \n");
	printf("  g  get [-bBcCfFrR]\n");
	printf("  h  help \n");
	printf("  l  ls [-lL]\n");
	printf("  o  open [-aAnNSU] [-s <retries>:<sleep>] [-u <user>:<password>]\n");
	printf("  p  put \n");
	printf("  s  set [<option>]\n");
	printf("  v  view [-zZ] \n");
	printf("  x  close \n");
	printf("Options:\n");
	printf("  b  Background downloading\n");
	printf("  z  Decompress files before viewing\n");
	printf("  f  Force overwrite\n");
	printf("  c  Continuation (reget)\n");
	printf("  l  Long listing\n");
	printf("  a  Anonymous login\n");
	printf("  s  Number of retries and time to sleep between\n");
	printf("  n  Don't use host and user info\n");
	printf("  r  Recursive get\n");
	printf("  q  Quiet operation\n");
	printf("  u  Default user and password\n");
}

int TxtIF::procargs(char *s, char *f[])
{
       char *p;
        int i = 0, j;
        p = s;

        while (*p) {
                f[i++] = p;
                while (*p && !isspace(*p))
                        p++;
                if (!*p)
                        break;
                *p++ = 0;
                while (*p && isspace(*p))
                        p++;
	}
        *p++ = 0;
        *p = 0;
        f[i] = 0;
	for (j = i;j < 100;j++)
		f[j] = 0;
        return i;
}

