/*  VER 023   TAB P   $Id: statistics.c,v 1.2 1997/08/14 13:39:46 src Exp $
 *
 *  an NNTP news exchange client
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "statistics.h"

/*
 *  neither lies nor damned lies
 */
void	    
statistics(time_t starttime,time_t endtime)
{
    FILE *f;
    long total;

    progtitle("statistics");

    total = endtime-starttime;

    if (duplicate_articles || missing_articles || failed_articles) {
	log_msg(L_INFO,"posting errors: %d duplicate, %d missing, %d failed article%s",
			   duplicate_articles, 
			   missing_articles, 
			   failed_articles,
			   failed_articles==1 ? "":"s");
    }
    if (bounced_articles) {
	log_msg(L_INFO,"bounced %d article%s",
			   bounced_articles, bounced_articles==1 ? "":"s");
    }
    if (unavailable_groups) {
	log_msg(L_INFO,"%d group%s were not available from this server",
			   unavailable_groups, unavailable_groups==1 ? "":"s");
    }
    if (unseen_groups) {
	log_msg(L_INFO,"fetched %d group%s never seen before",
			   unseen_groups, unseen_groups==1 ? "":"s");
    }
    if (already_articles || history_articles || mfilter_articles) {
	if (mfilter || mfilter_articles) {
	    log_msg(L_INFO,"%ld article%s already in spool, %ld fetched already, %ld filtered",
			   history_articles, history_articles==1 ? "":"s",
			   already_articles,   
			   mfilter_articles);  
	} else {
	    log_msg(L_INFO,"%ld article%s already in spool, %ld fetched already",
			   history_articles, history_articles==1 ? "":"s",
			   already_articles);  
	}
    }
    if (fetch_aborted) {
	log_msg(L_INFO,"article fetch aborted");
    }

    /* transfer speed statistics */
    if (gross_bytecount > 0) {
	log_msg(L_INFO,
	"posted %ld, fetched %d article%s in %ld group%s at %ld net cps",
			   posted_articles,
			   fetched_articles, fetched_articles==1 ? "":"s",
			   fetched_groups, fetched_groups==1 ? "":"s", 
			   net_bytecount / (total==0 ? 1 : total));
    }

    if (statfile) {
	long t = starttime;
	if (!(f = fopen(statfile,"a"))) {
	    log_msg(L_ERRno,"can't append to \"%s\"",statfile);
	    return;
	}

	if (ftell(f) == 0L) {
	    fprintf(f,
	    "# post fetc dupl alre hist miss grps ua-g us-g grossbyt netbytes totaltim fail\n");
	}
	fprintf(f,     
	    "T %s %s",
	       fetch_aborted ? "Ab":"OK", 
		  asctime(localtime(&starttime))+4); /* skip "Day " */
	fprintf(f,
   "N %4ld %4ld %4ld %4ld %4ld %4ld %4ld %4ld %4ld %8ld %8ld %8ld %4ld %4ld\n",
      posted_articles,
	   fetched_articles,
		duplicate_articles,
		     already_articles,
			  history_articles,
			       missing_articles,
				    fetched_groups,
					 unavailable_groups,
					      unseen_groups,
						   gross_bytecount,
							net_bytecount,
							     total,	     
						       /* new in version 0.7 */
							     failed_articles,
							     bounced_articles);
	if (mfilter || mfilter_articles)
	    fprintf(f,"F %4ld\n",
			 mfilter_articles);
	fclose(f);
    }
}   
