# Main-module of X-CD-Roast
# 23.1.96 T. Niederreiter

# some handy defines:
set XCDR_VERSION "0.96d"
set VERSION $XCDR_VERSION
set SUB_VERSION ""
set RELEASE_DATE "09 May 1998"

# this variable should be set from the configure-script via
# the ET-Wrapper.  
if { [info exists LIBDIRPREFIX] == 0 } {
	# if not set then use the default value
	set LIBDIRPREFIX "/usr/local"
}

set LIBDIR "$LIBDIRPREFIX/lib/xcdroast-$VERSION"
 
# add some important paths to search-path
set env(PATH) "$env(PATH):/sbin:/usr/sbin"

# hide the root-window
wm withdraw .

# save argument-list
set roast_arguments $argv

# scan arguments

# show help
set tmpidx [lsearch $roast_arguments "--help"]
set tmpidx2 [lsearch $roast_arguments "-?"]
if { $tmpidx != -1 || $tmpidx2 != -1 } {
	puts "X-CD-Roast Version $XCDR_VERSION"
	puts "Usage: $argv0 \[Options\]"
	puts "Options:"
	puts "    -scanscsi num  : scan for 0 <= num <= 64 scsi devices (default 16)"
	puts "    -scanide num   : scan for 0 <= ide <= 8 ide devices (default 8)"
	puts "    -configdir dir : directory where to save config-data (default ~/.xcdroast)"
	puts "    -libdir dir    : library-directory (default $LIBDIR)"
	puts "    -display host  : redirect display to host"
	puts "    -debug level   : enable debug-mode (level >=1)"
	exit
}	

# default scan-range for ide devices
set scanide_number 8 
set tmpidx [lsearch $roast_arguments "-scanide"]
if { $tmpidx != -1 } {

	set scanide_number [lindex $roast_arguments [expr $tmpidx + 1]]

	if { $scanide_number < 0 || $scanide_number > 8 } {
		puts "Error: Argument \"-scanide\" accepts only values 0 - 8"
		exit
	}
}

# default scan-range for scsi devices
set scanscsi_number 16
set tmpidx [lsearch $roast_arguments "-scanscsi"]
if { $tmpidx != -1 } {

	set scanscsi_number [lindex $roast_arguments [expr $tmpidx + 1]]

	if { $scanscsi_number < 0 || $scanscsi_number > 64 } {
		puts "Error: Argument \"-scanscsi\" accepts only values 0 - 64"
		exit
	}
}

# set $HOME/.xcdroast as default configuration-dir
set CONFDIR "[glob ~/]/.xcdroast"

# set config-directory
set tmpidx [lsearch $roast_arguments "-configdir"]
if { $tmpidx != -1 } {
	set CONFDIR  [lindex $roast_arguments [expr $tmpidx + 1]]
}	


# set lib-directory
set tmpidx [lsearch $roast_arguments "-libdir"]
if { $tmpidx != -1 } {
	set LIBDIR  [lindex $roast_arguments [expr $tmpidx + 1]]
}	

# set quick-load (dont show logo in main-screen)
set QUICKLOAD 0
set tmpidx [lsearch $roast_arguments "-quickload"]
if { $tmpidx != -1 } {
	set QUICKLOAD 1
}	

# set debug-level
set DEBUG 0
set tmpidx [lsearch $roast_arguments "-debug"]
if { $tmpidx != -1 } {
	set DEBUG [lindex $roast_arguments [expr $tmpidx + 1]] 
}	
if { $DEBUG == "" } { set DEBUG 1 }
#-----------------------------------------------------

# Check if LIBDIR is found
if { [file isdirectory $LIBDIR] == 0 } {
	puts "Error: Library-Directory \"$LIBDIR\" not found."
	exit
}

# Check if CONFDIR is found
if { [file isdirectory $CONFDIR] == 0 } {
	# create confdir if it does not exists
	exec mkdir $CONFDIR
	chownfile $CONFDIR
}

# Check if /dev/sr* devices are there
if { [catch { glob "/dev/sr*" }] != 0 } {
	puts "Error: No /dev/sr-Devices found."
	puts "Please create first the devices. Run \"./MAKEDEVICES.sh\""
	puts "in the xcdroast-$VERSION directory."
	exit
}

# Check if /dev/sg* devices are there
set nrsgdev 0
set nrsgdev2 0
catch { set nrsgdev [llength [glob "/dev/sg\[0-9\]"]] }
catch { set nrsgdev2 [llength [glob "/dev/sg1\[0-5\]"]] }
if { [expr $nrsgdev + $nrsgdev2] < 16 } {
	puts "Error: Some or all Generic-SCSI-Devices are missing."
	puts "Please create first the devices. Run \"./MAKEDEVICES.sh\""
	puts "in the xcdroast-$VERSION directory."
	exit
}


# Check if user is root (effective user id - so that suid-bit works)
set userid [geteuid]
if { $userid != "0" } {
        Msg_NoRoot .noroot .
        exit
}

# Prepare some variables

createglobalvars
init_paths

# Do access the sg-devices to force the kernel to load the 
# sg-module if available.
if { $scanscsi_number > 0 } {

	# dummy call to load module
	scsiinq -s 1

	# Check if sg-module is loaded
	if { [checksgmodule] != 0 } {
		set stat [Msg_NoSGFound .nosg .]
		if { $stat == 1 } {
			exit
		}
	}
}

# Process Hardware-Detection

getscsidevices
getidedevices
getdiskinfo
getcddrives
getpartinfo

# Check if cdrecord scsi-kernel-patch is installed (and needed)
if { [checkscsipatch] != 0 } {
	set stat [Msg_NoScsiPatch .nosptch .]
	if { $stat == 1 } {
		exit
	}
}

# Load configuration-file
if { [loadcfgfile $CONFDIR/$CFGFILE] != 0 } {
	Msg_ConfFileNotFound .dlg . 
	set forcesetup 1		
}

# Check if loaded configuration-file was from a different 
# program-version.
if { $VERSION != $XCDR_VERSION } {
	Msg_ConfFileWrongVersion .dlg . $VERSION $XCDR_VERSION
	set XCDR_VERSION $VERSION
	set XCDR_DISCLAIMERDONTSHOWAGAIN 0
	set forcesetup 1
}

# Check if scsisetup has changed
set scsistatus [checkscsisetup]
if { $forcesetup !=1 && $scsistatus != 0 } {
	Msg_ScsiSetupWarning .dlg . $scsistatus
	set forcesetup 1
}


# Check if the binaries are there
if { [catch { glob $CDRECORD }] != 0 } {
       puts "Error: Installation-Error - Not all binaries found."
       puts "Please install X-CD-Roast correctly."
       exit
}

# output versions
if { $DEBUG > 0 } {
	puts "Debug: Starting X-CD-Roast $VERSION - $SUB_VERSION"
	puts "Debug: Version TCL=$tcl_patchLevel, TK=$tk_patchLevel, Tix=$tix_patchLevel"

}

MkMainWindow .root

log . "started"

# set endian
setEndianorder

