#define IPCTST
#undef IPCTST
/* -------------------------------------------------------------------- */
/*        semshm.c                                                      */
/* -------------------------------------------------------------------- */
/*               int seminstall(key,amount)                             */
/*               int semrequest(semid,semnum)                           */
/*               int semrelease(semid,semnum)                           */
/* -------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#if defined (HAVE_UNISTD_H) && (HAVE_UNISTD_H == 1)
#include <sys/types.h>
#include <unistd.h>
#endif
#include <errno.h>
#if defined(HAVE_SEMCTL) && (HAVE_SEMCTL == 1)
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#endif
#if defined(HAVE_SHMAT) && (HAVE_SHMAT == 1)
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#endif
#include "interface.h"
#include "ringbuff.h"
#include "semshm.h"

#ifdef DEBUG_SHM
char *start_of_shm;
char *end_of_shm;
#endif

#if defined(HAVE_SEMCTL) && (HAVE_SEMCTL == 1)
int sem_id;
/*-----------------------------------------------------------------*/
static int seminstall(key_t key, int amount)
{
  int           ret_val;
  int           semflag;

  semflag = IPC_CREAT | 0600;
#ifdef IPCTST
  fprintf(stderr,"seminstall: key: %d, #sems %d, flags %4x\n",
          key,amount,semflag);
#endif
  ret_val = semget(key,amount,semflag);
  if ( ret_val == -1 )
  {
    fprintf(stderr,"semget: (Key %lx, #%d) failed: ",
            (long)key,amount);
    perror("");
  }
  return ret_val;
}

/*-----------------------------------------------------------------*/
int semrequest(int semid, int semnum, int amount)
{
  struct sembuf sops[1];
  int    ret_val;

  if (amount != 1) return 0;

#ifdef IPCTST
  fprintf(stderr,"pid %d, ReQuest id:num %d:%d\n",getpid(),semid,semnum);
#endif
  sops[0].sem_op  = -1;
  sops[0].sem_num = (short) semnum;
  sops[0].sem_flg = 0;

  do {
    errno = 0;
    ret_val = semop(semid,sops,1);
    if (ret_val == -1 && errno != EAGAIN && errno != EINTR)
      {
	fprintf(stderr,"Request Sema %d(%d) failed: ",semid,semnum);
	perror("");
      }
  } while (errno == EAGAIN || errno == EINTR);
  return(ret_val);
}

/*-----------------------------------------------------------------*/
int semrelease(int semid, int semnum, int amount)
{
  struct sembuf sops[1];
  int    ret_val;

#ifdef IPCTST
  fprintf(stderr,"%d RL %d:%d\n",getpid(),semid,semnum);
#endif
  sops[0].sem_op  = amount;
  sops[0].sem_num = (short) semnum;
  sops[0].sem_flg = 0;
  ret_val = semop(semid,sops,1);
  if ( ret_val == -1 && errno != EAGAIN)
  {
    fprintf(stderr,"Release Sema %d(%d) failed: ",semid,semnum);
    perror("");
  }
  return(ret_val);
}
#else
  /* use pipes */
int pipefdp2c[2];
int pipefdc2p[2];

void init_pipes(void)
{
  if (pipe(pipefdp2c) < 0) {
    perror("cannot create pipe parent to child");
    exit(1);
  }
  if (pipe(pipefdc2p) < 0) {
    perror("cannot create pipe child to parent");
    exit(1);
  }
}

void init_parent(void)
{
  close(pipefdp2c[0]);
  close(pipefdc2p[1]);

  drop_all_buffers();
}

void init_child(void)
{
  close(pipefdp2c[1]);
  close(pipefdc2p[0]);
}

int semrequest(int dummy, int semnum, int amount)
{
  int semdummy;

  if (amount != 1) return 0;

  if (semnum == 0) 
    return read(pipefdp2c[0], &semdummy, 1) != 1;
  else
    return read(pipefdc2p[0], &semdummy, 1) != 1;
}

int semrelease(int dummy, int semnum, int amount)
{
  if (semnum == 0) 
    return write(pipefdp2c[1], "12345678901234567890", amount) != amount;
  else
    return write(pipefdc2p[1], "12345678901234567890", amount) != amount;
}

#endif

#if defined(HAVE_SHMAT) && (HAVE_SHMAT == 1)
int shm_id;
/* request a shared memory block */
static int shm_request(key_t key, unsigned int size, unsigned char **memptr)
{
  int   ret_val;
  int   shmflag;
  int   SHMEM_ID;
  int    cmd;
  struct shmid_ds buf;

  shmflag = IPC_CREAT | 0600;
  ret_val = shmget(key,(int)size,shmflag);
  if ( ret_val == -1 )
  {
    perror("shmget");
    return -1;
  }

  SHMEM_ID = ret_val;
  cmd = IPC_STAT;
  ret_val = shmctl(SHMEM_ID,cmd,&buf);
#ifdef IPCTST
  fprintf(stderr, "%d: shmctl STAT= %d, SHM_ID: %d, key %ld cuid %d cgid %d mode %3o size %d\n",
          getpid(),ret_val,SHMEM_ID,
          (long) buf.shm_perm.key,buf.shm_perm.cuid,buf.shm_perm.cgid,
          buf.shm_perm.mode,buf.shm_segsz);
#endif

  *memptr = (unsigned char *) shmat(SHMEM_ID, NULL, 0);
  if (*memptr == (unsigned char *) -1) {
    *memptr = NULL;
    return -1;
  }
#ifdef DEBUG_SHM
  start_of_shm = *memptr;
  end_of_shm = (char *)(*memptr) + size;

  fprintf(stderr, "Shared memory from %p to %p (%u bytes)\n", start_of_shm, end_of_shm, size);
#endif
  return SHMEM_ID;
}
#endif

/* release semaphores and shared memory */
void free_semshm(void)
{
  int   mycmd;
#if defined(HAVE_SEMCTL) && (HAVE_SEMCTL == 1)
  union my_semun myarg;

  mycmd = IPC_RMID;
  semctl(sem_id,0,mycmd,myarg);
#endif
#if defined(HAVE_SHMAT) && (HAVE_SHMAT == 1)
  mycmd = IPC_RMID;
  shmctl(shm_id,mycmd,0L);
#endif
}

void *request_shm_sem(unsigned amount_of_sh_mem, unsigned char **pointer)
{
#if defined(HAVE_SEMCTL) && (HAVE_SEMCTL == 1)
    /* install semaphores for double buffer usage */
    sem_id = seminstall(IPC_PRIVATE,2);
    if ( sem_id == -1 ) {
      perror("seminstall");
      exit(1);
    }

#if 0
    {
        int   mycmd;
        union my_semun myarg;

        mycmd = IPC_RMID;
        semctl(sem_id,0,mycmd,myarg);
    }
#endif
#endif

#if defined(HAVE_SHMAT) && (HAVE_SHMAT == 1)
    /* request a doublebuffer for cdda sector audio data */
    shm_id = shm_request(IPC_PRIVATE, amount_of_sh_mem, pointer);
    if ( shm_id == -1 ) {
	perror("sem_request");
	exit(1);
    }

#if 0
    {
        int   mycmd;

        mycmd = IPC_RMID;
        shmctl(shm_id,mycmd,0L);
    }
#endif
    return *pointer;
#else
    return NULL;
#endif
}
