;; $Id: dbdivis.dsl 1.3 1998/02/19 17:59:12 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================= DIVISIONS ==============================

(define ($division$) 
  (make sequence
    (make simple-page-sequence
      page-number-restart?: (book-start?)
      page-number-format: ($page-number-format$)
      use: para-style ;; set defaults for text in this simple page sequence
      left-header:   ($left-header$)
      center-header: ($center-header$)
      right-header:  ($right-header$)
      left-footer:   ($left-footer$)
      center-footer: ($center-footer$)
      right-footer:  ($right-footer$)
      input-whitespace-treatment: 'collapse
      quadding: %default-quadding%
      ($division-title$))
    (process-children)))

(define ($division-title$)
  (let* ((info (cond
		((equal? (gi) "SET")
		 (select-elements (children (current-node)) "SETINFO"))
		((equal? (gi) "BOOK")
		 (select-elements (children (current-node)) "BOOKINFO"))
		(else 
		 (select-elements (children (current-node)) "DOCINFO"))))
	 (exp-children (expand-children (children info) '("BOOKBIBLIO" 
							  "BIBLIOMISC"
							  "BIBLIOSET")))
	 (parent-titles (select-elements (children (current-node)) "TITLE"))
	 (info-titles   (select-elements exp-children "TITLE"))
	 (titles        (if (node-list-empty? parent-titles)
			    info-titles
			    parent-titles))
	 (subtitles     (select-elements exp-children "SUBTITLE")))
    (make sequence
      (with-mode division-title-mode
	(make sequence
	  (process-node-list titles)
	  (process-node-list subtitles)))
      (make paragraph
	space-after: (* (HSIZE 5) %head-after-factor% 4)
	(literal " ")))))

(mode division-title-mode
  (element TITLE
    (let ((division (ancestor-member (current-node) division-element-list)))
      (make paragraph
	font-family-name: %title-font-family%
	font-weight: 'bold
	font-size: (HSIZE 5)
	line-spacing: (* (HSIZE 5) %line-spacing-factor%)
	space-before: (* (HSIZE 5) %head-before-factor%)
	quadding: %division-title-quadding%
	keep-with-next?: #t
	(if (string=? (element-label division) "")
	    (empty-sosofo)
	    (literal (element-label division) 
		     (gentext-label-title-sep (gi division))))
	(process-children))))

  (element SUBTITLE
    (make paragraph
      font-family-name: %title-font-family%
      font-weight: 'bold
      font-size: (HSIZE 4)
      line-spacing: (* (HSIZE 4) %line-spacing-factor%)
      space-before: (* (HSIZE 4) %head-before-factor%)
      quadding: %division-subtitle-quadding%
      keep-with-next?: #t
      (process-children)))
)

(element SET ($division$))
(element (SET TITLE) (empty-sosofo))

(element BOOK 
  ;; Handle two cases:
  ;;   If there's a BOOKINFO, just process children.  BOOKINFO will handle
  ;;      generation of a title page and/or a TOC (see dbttlpg.dsl and 
  ;;      dbinfo.dsl)
  ;;   If there's no BOOKINFO, generate a simple page sequence containing
  ;;      the TOC, if a TOC is desired
  (let ((booktitle (select-elements (children (current-node)) "TITLE"))
	(bookinfo  (select-elements (children (current-node)) "BOOKINFO"))
	(dedication (select-elements (children (current-node)) "DEDICATION")))
    (make sequence
      (if %generate-titlepage%
	  (if (node-list-empty? bookinfo)
	      (if (node-list-empty? booktitle)
		  (empty-sosofo)
		  (with-mode simple-book-title-mode
		    (process-node-list booktitle)))
	      (with-mode complex-book-title-mode
		(process-node-list bookinfo)))
	  (empty-sosofo))

      (if (node-list-empty? dedication)
	  (empty-sosofo)
	  (with-mode dedication-page-mode
	    (process-node-list dedication)))

      (if (not %generate-toc-in-front%)
	  (process-children)
	  (empty-sosofo))

      (if %generate-toc%
	  (make simple-page-sequence
	    page-number-restart?: #t
	    page-number-format: ($page-number-format$ "TOC")
	    use: para-style ;; set defaults for text in this simp. pg sequence
	    left-header:   ($left-header$ "TOC")
	    center-header: ($center-header$ "TOC")
	    right-header:  ($right-header$ "TOC")
	    left-footer:   ($left-footer$ "TOC")
	    center-footer: ($center-footer$ "TOC")
	    right-footer:  ($right-footer$ "TOC")
	    input-whitespace-treatment: 'collapse
	    (build-toc (current-node)
		       (toc-depth (current-node))))
	  (empty-sosofo))
	    
      (let loop ((gilist %generate-lot-list%))
	(if (null? gilist)
	    (empty-sosofo)
	    (if (and %generate-toc-in-front%
		     (not (node-list-empty? 
			   (select-elements (descendants (current-node))
					    (car gilist)))))
		(make simple-page-sequence
		  page-number-format: ($page-number-format$ "LOT")
		  use: para-style ;; set defaults for text in this sequence
		  left-header:   ($left-header$ "LOT")
		  center-header: ($center-header$ "LOT")
		  right-header:  ($right-header$ "LOT")
		  left-footer:   ($left-footer$ "LOT")
		  center-footer: ($center-footer$ "LOT")
		  right-footer:  ($right-footer$ "LOT")
		  input-whitespace-treatment: 'collapse
		  (build-lot (current-node) (car gilist))
		  (loop (cdr gilist)))
		(loop (cdr gilist)))))

      (if %generate-toc-in-front%
	  (process-children)
	  (empty-sosofo)))))

;; If the book title is present, then:
;;   If there's a BOOKINFO, we will have used that to make the title page,
;;      so ignore the BOOK TITLE
;;   Otherwise, generate a $divtitlepage$ with the BOOK TITLE if 
;;      %generate-titlepage% is true.
;;
(element (BOOK TITLE) (empty-sosofo))

(mode simple-book-title-mode
  (element TITLE
    (make simple-page-sequence
      page-number-restart?: (book-start?)
      input-whitespace-treatment: 'collapse
      use: para-style ;; set defaults for text in this simple page sequence
      (make paragraph
	font-family-name: %title-font-family%
	font-weight: 'bold
	font-size: (HSIZE 5)
	line-spacing: (* (HSIZE 5) %line-spacing-factor%)
	space-before: (* (HSIZE 5) %head-before-factor%)
	space-after: (* (HSIZE 5) %head-after-factor% 4)
	quadding: %division-title-quadding%
	keep-with-next?: #t
	(process-children)))))

(mode complex-book-title-mode
  (element BOOKINFO 
    ;; If a titlepage is desired, produce it
    ;; If a TOC is desired, produce it after the title page
    ;; If a titlepage is not desired, but a TOC is, 
    (let* ((exp-children (expand-children (children (current-node))
					  '("BOOKBIBLIO" 
					    "BIBLIOMISC"
					    "BIBLIOSET")))
	   (parent-titles (select-elements 
			   (children (parent (current-node))) "TITLE"))
	   (info-titles   (select-elements 
			   exp-children "TITLE"))
	   (titles        (if (node-list-empty? parent-titles)
			      info-titles
			      parent-titles))
	   (subtitles     (select-elements exp-children "SUBTITLE")))
      (if %generate-titlepage%
	  (make simple-page-sequence
	    input-whitespace-treatment: 'collapse
	    use: para-style ;; set defaults for text in this simp pg sequence
	    (with-mode titlepage-recto-mode 
	      (make sequence
		(process-node-list titles)
		(process-node-list subtitles)

		(make paragraph
		  space-after: (* (HSIZE 5) %head-after-factor% 8)
		  (literal " "))

		(if (node-list-empty? 
		     (select-elements 
		      (descendants (current-node)) "AUTHORGROUP"))
		    (process-first-descendant "AUTHOR")
		    (process-first-descendant "AUTHORGROUP"))

		(make paragraph
		  break-before: 'page
		  (literal "")
		  (empty-sosofo))))

	    (with-mode titlepage-verso-mode
	      (make sequence
		($verso-titles$ titles subtitles)
		(process-children))))
	  (empty-sosofo)))))

(element PART ($division$))
(element (PART TITLE) (empty-sosofo))

(element PARTINTRO (process-children))

(element (PARTINTRO TITLE)
  (let* ((hlevel 1)
	 (hs (HSIZE (- 4 hlevel))))
    (make paragraph
      font-family-name: %title-font-family%
      font-weight:  (if (< hlevel 5) 'bold 'medium)
      font-posture: (if (< hlevel 5) 'upright 'italic)
      font-size: hs
      line-spacing: (* hs %line-spacing-factor%)
      space-before: (* hs %head-before-factor%)
      space-after: (* hs %head-after-factor%)
      start-indent: (if (< hlevel 3)
			0pt
			%body-start-indent%)
      first-line-start-indent: 0pt
      quadding: %section-title-quadding%
      keep-with-next?: #t
      (process-children))))
