;; $Id: dbparam.dsl 1.9 1998/02/19 17:59:12 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; === Book intro, for dsl2man ==========================================

<![CDATA[
;; BOOKINFO
;; <bookinfo>
;; <title>DocBook Print Parameters</title>
;; <subtitle>Part of the Modular DocBook Stylesheet distribution</subtitle>
;; <author><firstname>Norman</firstname><surname>Walsh</surname>
;; <affiliation><orgname>ArborText, Inc.</orgname></affiliation>
;; </author>
;; <edition>Reference version 1.06</edition>
;; <copyright><year>1997</year><year>1998</year>
;; <holder>Norman Walsh</holder></copyright>
;; <legalnotice>
;; <para>
;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;; EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
;; OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
;; NONINFRINGEMENT.  IN NO EVENT SHALL NORMAN WALSH OR ANY OTHER
;; CONTRIBUTOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
;; WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;; OTHER DEALINGS IN THE SOFTWARE.
;; </para>
;; </legalnotice>
;; <legalnotice>
;; <para>
;; Please direct all questions, bug reports, or suggestions for changes
;; to Norman Walsh, &lt;<literal>norm@berkshire.net</literal>&gt;.
;; </para>
;; <para>
;; See <ulink url="http://www.berkshire.net/~norm/dsssl/">http://www.berkshire.net/~norm/dsssl/</ulink> for more information.</para>
;; </legalnotice>
;; </bookinfo>
;; /BOOKINFO
]]>

;; ------------------------------ Parameters ------------------------------

(define %visual-acuity%
  ;; REFENTRY
  ;; PURP General measure of document text size
  ;; DESC
  ;; This parameter controls the general size of the text in the document.
  ;; Several other values (body font size and margins) have default values that
  ;; vary depending on the setting of '%visual-acuity%'. There
  ;; are three legal values: 'normal', 
  ;; the normal, standard document size (10pt body text);
  ;; 'presbyopic', 
  ;; a slightly more generous size (12pt body text); and
  ;; 'large-type',
  ;; quite large (24pt body text).
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  ;; "presbyopic"
  ;; "large-type"
  "normal")

(define %paper-type%
  ;; REFENTRY
  ;; PURP Name of paper type
  ;; DESC
  ;; The paper type value identifies the sort of paper in use, for example, 
  ;; 'A4' or 'USletter'. Setting the paper type is an
  ;; easy shortcut for setting the correct paper height and width.
  ;; 
  ;; As distributed, only 'A4' and 'USletter' are supported.  You can add
  ;; additional paper types by updating 'page-width' and 'page-height'.
  ;; If you do, please pass along your updates. 
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  ;; "A4"
  "USletter")

;; Select characteristics of the text on the printed page.  Margins,
;; line spacing, indents, etc.
;;

(define %line-spacing-factor% 
  ;; REFENTRY
  ;; PURP Factor used to calculate leading
  ;; DESC
  ;; The leading is calculated by multiplying the current font size by the 
  ;; '%line-spacing-factor%'. For example, if the font size is 10pt and
  ;; the '%line-spacing-factor%' is 1.1, then the text will be
  ;; printed "10-on-11".
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  1.1)

(define %head-before-factor% 
  ;; REFENTRY
  ;; PURP Factor used to calculate space above a title
  ;; DESC
  ;; The space before a title is calculated by multiplying the font size
  ;; used in the title by the '%head-before-factor%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  0.75)

(define %head-after-factor% 
  ;; REFENTRY
  ;; PURP Factor used to calculate space below a title
  ;; DESC
  ;; The space after a title is calculated by multiplying the font size used
  ;; in the title by the '%head-after-factor%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  0.5)

(define %body-start-indent% 
  ;; REFENTRY
  ;; PURP Default indent of body text
  ;; DESC
  ;; The default indent of body text. Some elements may have more or less
  ;; indentation.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  4pi)

(define %para-sep% 
  ;; REFENTRY
  ;; PURP Distance between paragraphs
  ;; DESC
  ;; The '%para-sep%' is the distance between the last line
  ;; of one paragraph and the first line of the next.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (/ %bf-size% 2.0))

(define %block-sep% 
  ;; REFENTRY
  ;; PURP Distance between block-elements
  ;; DESC
  ;; The '%block-sep%' is the vertical distance between
  ;; block elements (figures, tables, etc.)
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (* %para-sep% 2.0))

(define %hsize-bump-factor% 
  ;; REFENTRY
  ;; PURP Font scaling factor
  ;; DESC
  ;; Internally, the stylesheet refers to font sizes in purely relative
  ;; terms. This is done by defining a scaled set of fonts 
  ;; (sizes 1, 2, 3, etc.)
  ;; based at the default text font size (e.g. 10pt). The '%hsize-bump-factor%'
  ;; describes the ratio between scaled sizes. The default is 1.2.
  ;;
  ;; Each hsize is '%hsize-bump-factor%' times larger than
  ;; the previous hsize. For example, if the base size is 10pt, and 
  ;; '%hsize-bump-factor%'
  ;; 1.2, hsize 1 is 12pt, hsize 2 is 14.4pt, hsize 3 is 17.28pt, etc.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  1.2)

(define %ss-size-factor% 
  ;; REFENTRY
  ;; PURP Super/subscript scaling factor
  ;; DESC
  ;; When text is set as a subscript or superscript, the font size of the
  ;; text is multiplied by '%ss-size-factor%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  0.6)

(define %ss-shift-factor%
  ;; REFENTRY
  ;; PURP Super/subscript shift factor
  ;; DESC
  ;; When text is set as a subscript or superscript, it is set above or below
  ;; the baseline by a factor of the current font size and '%ss-shift-factor%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  0.4)

(define %smaller-size-factor% 
  ;; REFENTRY
  ;; PURP Smaller font scaling factor
  ;; DESC
  ;; In environments that are usually set with a slightly smaller font size,
  ;; for example block quotations, the stylesheet calculates the smaller font
  ;; size by muliplying the current font size by '%smaller-size-factor%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  0.9)

(define %verbatim-size-factor% 
  ;; REFENTRY
  ;; PURP Verbatim font scaling factor
  ;; DESC
  ;; When a monospace font is selected, the current font size is multiplied
  ;; by the '%verbatim-size-factor%'. If '%verbatim-size-factor%'
  ;; is '#f', no scaling is performed (Well, that's not precisely true. 
  ;; In '$verbatim-display$'
  ;; environments, the font size is calculated with respect to the longest line
  ;; in the display, if '%verbatim-size-factor%' is '#f').
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  0.9)

(define %verbatim-default-width% 
  ;; REFENTRY
  ;; PURP Default width of verbatim environments
  ;; DESC
  ;; If no WIDTH attribute is specified on verbatim environments, 
  ;; '%verbatim-default-width%' is the default.  Note: this width only
  ;; comes into play if '%verbatim-size-factor%' is '#f'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  80)

(define %default-quadding%   
  ;; REFENTRY
  ;; PURP The default quadding
  ;; DESC
  ;; The default quadding ('start', 'center', 'justify',
  ;; or 'end').
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'start)

(define %division-title-quadding% 
  ;; REFENTRY
  ;; PURP Division title quadding
  ;; DESC
  ;; The quadding of division-level titles ('Set', 'Book', and 'Part').
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'center)

(define %division-subtitle-quadding% 
  ;; REFENTRY
  ;; PURP Division subtitle quadding
  ;; DESC
  ;; The quadding of division-level subtitles ('Set', 'Book', and 'Part').
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'center)

(define %component-title-quadding% 
  ;; REFENTRY
  ;; PURP Component title quadding
  ;; DESC
  ;; The quadding of component-level titles ('Chapter',
  ;; 'Appendix', 'Glossary', etc.).
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'start)

(define %component-subtitle-quadding% 
  ;; REFENTRY
  ;; PURP Component subtitle quadding
  ;; DESC
  ;; The quadding of component-level subtitles ('Chapter',
  ;; 'Appendix', 'Glossary', etc.).
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'start)

(define %section-title-quadding% 
  ;; REFENTRY
  ;; PURP Section title quadding
  ;; DESC
  ;; The quadding of section-level titles.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'start)

(define %section-subtitle-quadding% 
  ;; REFENTRY
  ;; PURP Section subtitle quadding
  ;; DESC
  ;; The quadding of section-level subtitles.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'start)

(define %title-font-family% 
  ;; REFENTRY
  ;; PURP The font family used in titles
  ;; DESC
  ;; The name of the font family used in titles (Arial by default).
  ;;
  ;; The values used here are system dependent (you have
  ;; to have the fonts you select) and backend dependent (the backend has
  ;; to know how to use them). 
  ;;
  ;; The values here work for the RTF backend under MS Windows.  YMMV.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  "Arial")

(define %body-font-family% 
  ;; REFENTRY
  ;; PURP The font family used in body text
  ;; DESC
  ;; The name of the font family used in body text 
  ;; (Times New Roman by default).
  ;;
  ;; The values used here are system dependent (you have
  ;; to have the fonts you select) and backend dependent (the backend has
  ;; to know how to use them). 
  ;;
  ;; The values here work for the RTF backend under MS Windows.  YMMV.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  "Times New Roman")

(define %mono-font-family% 
  ;; REFENTRY
  ;; PURP The font family used in verbatim environments
  ;; DESC
  ;; The name of the font family used in verbatim environments (Courier New
  ;; by default).
  ;;
  ;; The values used here are system dependent (you have
  ;; to have the fonts you select) and backend dependent (the backend has
  ;; to know how to use them). 
  ;;
  ;; The values here work for the RTF backend under MS Windows.  YMMV.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  "Courier New")

(define %admon-font-family% 
  ;; REFENTRY
  ;; PURP The font family used in admonitions
  ;; DESC
  ;; The name of the font family used for body text in admonitions (Arial
  ;; by default).
  ;;
  ;; The values used here are system dependent (you have
  ;; to have the fonts you select) and backend dependent (the backend has
  ;; to know how to use them). 
  ;;
  ;; The values here work for the RTF backend under MS Windows.  YMMV.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  "Arial")

(define %guilabel-font-family%
  ;; REFENTRY
  ;; PURP The font family used in GUI labels
  ;; DESC
  ;; The name of the font family used for text that represents text on a
  ;; GUI (e.g., text in 'GUILabel', 'GUIMenu',
  ;; etc.). (Arial by default).
  ;;
  ;; The values used here are system dependent (you have
  ;; to have the fonts you select) and backend dependent (the backend has
  ;; to know how to use them). 
  ;;
  ;; The values here work for the RTF backend under MS Windows.  YMMV.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  "Arial")

(define %refentry-name-font-family%
  ;; REFENTRY
  ;; PURP The font family used in RefName
  ;; DESC
  ;; The name of the font family used in 'RefEntry'
  ;; 'RefName's.
  ;;
  ;; If '%refentry-function%' is true, defaults to
  ;; '%mono-font-family%', otherwise defaults to '%body-font-family%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (if %refentry-function%
      %mono-font-family%
      %body-font-family%))

;; Page number restart - define to #t if page numbering should be
;; restarted when a new $component$ is started, define to #f if not.
;;
(define %page-number-restart% 
  ;; REFENTRY
  ;; PURP Restart page numbers in each component?
  ;; DESC
  ;; If true, page numbers are restarted at the beginning of each 
  ;; component-level
  ;; element ('Chapter', 'Appendix',
  ;; 'Bibliography', etc.).
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %refentry-new-page% 
  ;; REFENTRY
  ;; PURP 'RefEntry' starts on new page?
  ;; DESC
  ;; If true, each 'RefEntry' begins on a new page.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %refentry-keep% 
  ;; REFENTRY
  ;; PURP Keep RefEntrys together?
  ;; DESC
  ;; Refentry keep indicates how the stylesheet should
  ;; attempt to keep each RefEntry.  Common values are '#t', for the
  ;; smallest possible area, 'page' for the same page, and '#f' to ignore
  ;; this characteristic.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %refentry-generate-name% 
  ;; REFENTRY
  ;; PURP Output NAME header before 'RefName'(s)?
  ;; DESC
  ;; If true, a "NAME" section title is output before the list
  ;; of 'RefName's.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %refentry-function% 
  ;; REFENTRY
  ;; PURP Are 'RefEntry's functions?
  ;; DESC
  ;; If true, 'RefEntry's are assumed to describe functions.
  ;; If 'RefEntry's are functions, "'()'"
  ;; is output after each 'RefName'
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

;; I don't really think I've got the ANSI/KandR styles right.  Actually,
;; I'm not sure I remember exactly what each is.  The second edition
;; of KandR uses what I thought was ANSI style...

(define %funcsynopsis-style% 
  ;; REFENTRY
  ;; PURP What style of 'FuncSynopsis' should be generated?
  ;; DESC
  ;; If '%funcsynopsis-style%' is 'ansi',
  ;; ANSI-style function synopses are generated for a 'FuncSynopsis',
  ;; otherwise K<![CDATA[&]]>R-style function synopses are generated.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'ansi)

(define %ansi-funcsynopsis-indent% 
  ;; REFENTRY
  ;; PURP Indent-depth in ANSI-style function synopses
  ;; DESC
  ;; If the '%funcsynopsis-style%' is 'ansi',
  ;; '%ansi-funcsynopsis-indent%' specifies the amount by which parameter
  ;; definitions should be indented under the function prototype.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  1pi)

(define %default-simplesect-level% 
  ;; REFENTRY
  ;; PURP Default section level for 'SimpleSect's.
  ;; DESC
  ;; If 'SimpleSect's appear inside other section-level
  ;; elements, they are rendered at the appropriate section level, but if they
  ;; appear in a component-level element, they are rendered at 
  ;; '%default-simplesect-level%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  4)

(define %generate-titlepage% 
  ;; REFENTRY
  ;; PURP Should a book title page be produced?
  ;; DESC
  ;; If true, a title page will be generated for each 'Book'.
  ;; This parameter has no meaning except when 'Book's are formatted.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %generate-toc% 
  ;; REFENTRY
  ;; PURP Should a Table of Contents be produced?
  ;; DESC
  ;; If true, a Table of Contents will be generated for each 'Book'.
  ;; This parameter has no meaning except when 'Book's
  ;; are formatted.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %generate-lot-list%
  ;; REFENTRY
  ;; PURP Should a List of Titles be produced?
  ;; DESC
  ;; If true, a List of Titles will be produced for each 'Book'.
  ;; This parameter has no meaning except when 'Book's are formatted.
  ;;
  ;; The elements that appear in a List of Titles ('Figure's,
  ;; 'Table's, etc.), are controlled by '%generate-lot-list%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (list "TABLE" "FIGURE" "EXAMPLE" "EQUATION"))

(define %two-side% 
  ;; REFENTRY
  ;; PURP Is two-sided output being produced?
  ;; DESC
  ;; If '%two-side%' is true, headers and footers are alternated
  ;; so that the "outer" and "inner" headers will be correctly
  ;; placed in the bound document.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %writing-mode%
  ;; REFENTRY
  ;; PURP The writing mode
  ;; DESC
  ;; The writing mode is either 'left-to-right', or 
  ;; 'right-to-left'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'left-to-right)

(define %chap-app-running-heads% 
  ;; REFENTRY
  ;; PURP Generate running headers and footers on chapter-level elements?
  ;; DESC
  ;; If true, running headers and footers are produced on chapter-level 
  ;; elements.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %section-autolabel% 
  ;; REFENTRY
  ;; PURP Are sections enumerated?
  ;; DESC
  ;; If true, unlabeled sections will be enumerated.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %chapter-autolabel% 
  ;; REFENTRY
  ;; PURP Are chapters enumerated?
  ;; DESC
  ;; If true, chapters will be enumerated.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %chap-app-running-head-autolabel% 
  ;; REFENTRY
  ;; PURP Put chapter labels in running heads?
  ;; DESC
  ;; If true, running heads on 'Chapter's and 
  ;; 'Appendix'es will include an automatic label.
  ;; 
  ;; In other words, if a 'Chapter' has no 'Label' attribute,
  ;; and '%chap-app-running-head-autolabel%'
  ;; is true, running heads will include the automatic label for the
  ;; 'Chapter'. If '%chap-app-running-head-autolabel%'
  ;; is false, only the 'Title' (or 'TitleAbbrev')
  ;; will appear in the running head.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

;; Should line numbers be printed on linespecific things?
;;
(define %number-synopsis-lines% 
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'Synopsis'?
  ;; DESC
  ;; If true, lines in each 'Synopsis' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%', 
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-funcsynopsisinfo-lines% 
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'FuncSynopsisInfo'?
  ;; DESC
  ;; If true, lines in each 'FuncSynopsisInfo' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-literallayout-lines% 
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'LiteralLayout'?
  ;; DESC
  ;; If true, lines in each 'LiteralLayout' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-address-lines% 
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'Address'?
  ;; DESC
  ;; If true, lines in each 'Address' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-programlisting-lines%
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'ProgramListing'?
  ;; DESC
  ;; If true, lines in each 'ProgramListing' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-screen-lines%
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'Screen'?
  ;; DESC
  ;; If true, lines in each 'Screen' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %linenumber-mod% 
  ;; REFENTRY
  ;; PURP Controls line-number frequency in enumerated environments.
  ;; DESC
  ;; Every '%linenumber-mod%' line will be enumerated.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  5)

(define %linenumber-length% 
  ;; REFENTRY
  ;; PURP Width of line numbers in enumerated environments
  ;; DESC
  ;; Line numbers will be padded to '%linenumber-length%'
  ;; characters.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  3)

(define %linenumber-padchar% 
  ;; REFENTRY
  ;; PURP Pad character in line numbers
  ;; DESC
  ;; Line numbers will be padded (on the left) with '%linenumber-padchar%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  " ")

(define ($linenumber-space$) 
  ;; REFENTRY
  ;; PURP Returns the sosofo which separates line numbers from the text
  ;; DESC
  ;; The sosofo returned by '($linenumber-space$)' is placed
  ;; between the line number and the corresponding line in 
  ;; enumerated environments.
  ;;
  ;; Note: '%linenumber-padchar%'s are separated from lines
  ;; that are not enumerated (because they don't match '%linenumber-mod%').
  ;; In other words, '($linenumber-space$)' occurs
  ;; on every line.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (literal " "))

(define %callout-fancy-bug% 
  ;; REFENTRY
  ;; PURP Use fancy callout bugs?
  ;; DESC
  ;; If true, fancy callout bugs will be used. Otherwise, simple ones are
  ;; used. Fancy callout bugs may require the RTF backend.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %callout-default-col% 
  ;; REFENTRY
  ;; PURP Default column for callouts
  ;; DESC
  ;; If the coordinates of a callout include only a line number, the callout
  ;; bug will appear in column '%callout-default-col%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  60)

(define %simplelist-column-width% 
  ;; REFENTRY
  ;; PURP Width of columns in tabular simple lists
  ;; DESC
  ;; If set to '#f', the table will span the entire
  ;; page width.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %block-start-indent% 
  ;; REFENTRY
  ;; PURP Extra start-indent for block-elements
  ;; DESC
  ;; Block elements (tables, figures, verbatim environments, etc.) will
  ;; be indented by the specified amount.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  0pt)

(define %graphic-default-extension% 
  ;; REFENTRY
  ;; PURP Default extension for graphic FILEREFs
  ;; DESC
  ;; The '%graphic-default-extension%' will be
  ;; added to the end of all 'fileref' filenames on
  ;; 'Graphic's if they do not end in one of the
  ;; '%graphic-extensions%'.  Set this to '#f'
  ;; to turn off this feature.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %graphic-extensions% 
  ;; REFENTRY
  ;; PURP List of graphic filename extensions
  ;; DESC
  ;; The list of extensions which may appear on a 'fileref'
  ;; on a 'Graphic' which are indicative of graphic formats.
  ;;
  ;; Filenames that end in one of these extensions will not have
  ;; the '%graphic-default-extension%' added to them.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  '("eps" "epsf" "gif" "tif" "tiff" "jpg" "jpeg"))

(define %table-element-list% 
  ;; REFENTRY
  ;; PURP List of table element names
  ;; DESC
  ;; The list of table elements in the DTD.  
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  '("TABLE" "INFORMALTABLE"))

;;
;; ----------------------------------------------------------------------
;;
;; The following parameters are generated from/depend on selections made
;; above.
;;

(define %bf-size%
  (case %visual-acuity%
	(("normal") 10pt)
	(("presbyopic") 12pt)
	(("large-type") 24pt)))
(define-unit em %bf-size%)

(define %page-width%
  (case %paper-type%
	(("A4") 210mm)
	(("USletter") 8.5in)))

(define %page-height%
  (case %paper-type%
	(("A4") 297mm)
	(("USletter") 11in)))

(define %left-margin% 6pi)
(define %right-margin% 6pi)

(define %text-width% (- %page-width% (+ %left-margin% %right-margin%)))
(define %body-width% (- %text-width% %body-start-indent%))

;;
;; ----------------------------------------------------------------------
;;
;; Declare initial values; perhaps more should be done this way...
;;

(declare-initial-value writing-mode 	%writing-mode%)

(declare-initial-value left-margin 	6pi)
(declare-initial-value right-margin 	6pi)
(declare-initial-value top-margin	(if (equal? %visual-acuity% "large-type") 7.5pi 6pi))
(declare-initial-value bottom-margin	(if (equal? %visual-acuity% "large-type") 9.5pi 8pi))
(declare-initial-value header-margin	(if (equal? %visual-acuity% "large-type") 5.5pi 4pi))
(declare-initial-value footer-margin	3pi)

(declare-initial-value page-width	%page-width%)
(declare-initial-value page-height	%page-height%)
