#ifndef ___ARENA_CMDLINE_H___
#  define ___ARENA_CMDLINE_H___

typedef enum { CLA_NO, CLA_REQUIRED, CLA_OPTIONAL } CLArg;

typedef enum { CLO_UNKNOWN, CLO_HELP, CLO_LARGE, CLO_GIANT, CLO_EMAIL,
	       CLO_FONTSIZE, CLO_COLOUR, CLO_COLOUR888, CLO_COLOUR232,
	       CLO_MONO, CLO_URL, CLO_VERSION, CLO_STYLE,
	       CLO_GREY, CLO_CM, CLO_NOCM, CLO_GAMMA, CLO_CACHE,
	       CLO_NOCACHE, CLO_LENS, CLO_PRINTER, CLO_EDITOR, CLO_USAGE,
	       CLO_GEOMETRY, CLO_LT, CLO_CT, CLO_DEBUG, CLO_ICON,
	       CLO_BADFLAGS, CLO_DISPLAY, CLO_NOSTYLE, CLO_NOMAILCAP,
	       CLO_PLAIN, CLO_XMAILER, CLO_SBARTHICK, CLO_FLYBY, CLO_NOFLYBY,
	       CLO_HISTORY } CLOpt;

typedef struct _cmdls
{
 char *name;
 CLArg arg;               /* 0 = NO,  1 = Required, 2 = optional          */
 CLOpt option;            /* Option Number... Note: Multiple switches     */
 char *text;              /* e.g. "[-editor cmd]"                         */
 char *help;              /* e.g. "Display this text" during --usage      */
} CLSwitch;

typedef struct _cmdopttable
{
 char *name;
 long val;
} CLOptTable;

/* We always need to know where the NO Args switch of URL is located in the
 * tabel below.  I have purposely made it the very first [0].  It would be
 * nice to just ASSUME that forever, but here is the way out of it!
 */
#define CMDLSwitchURL 0

/* Complete list of valid switch arguments that Arena will accept.
 * If text is defined, it will allow that switch to be shown during -usage(s).
 * If help is defined, it will show during --help.
 */
CLSwitch CMDLSwitchDefs[] =
  {
   { "-URLNOSWITCH",         /* dummy so we can return arg not a switch      */
     CLA_NO,                 /* change the value of CMDLSwitchURL #defined   */
     CLO_URL,                /* just above!                                  */
     NULL,
     NULL },

   { "-url",                /* url specified via option                      */
     CLA_REQUIRED,
     CLO_URL,
     "[-url URL]",
     NULL },
   { "--url",
     CLA_REQUIRED,
     CLO_URL,
     "[--url URL]",
     N_("Specifies initial document") },
      
   { "-h",                          /* Switch value                          */
     CLA_NO,                        /* Does it have value following?         */
     CLO_HELP,                      /* NUMBER of what option returned to you */
     "[(--help | -help)]",          /* String to display during --usage      */
     NULL },                        /* String to display during --help       */
   { "-help",
     CLA_NO,
     CLO_HELP,                      /* The help text was above               */
     NULL,                          /* Not displayed during --usage          */
     NULL },                        /* Not displayed!                        */
   { "--help",                      /* HELP                                  */
     CLA_NO,
     CLO_HELP,
     NULL,                          /* Still not displayed!                  */
     N_("Display this command line help text.") }, /* YES... during --help   */

   { "--usage",                CLA_NO,            CLO_USAGE,
     "[--usage]",
     N_("Display this command line usage usage text.") },

   { "-v",                     CLA_NO,            CLO_VERSION,
     "[-v]",
     NULL },
   { "--version",              CLA_NO,            CLO_VERSION,
     "[--version]",
     N_("Display "BANNER" version.") },
   
   { "--font-size",            CLA_REQUIRED,      CLO_FONTSIZE,
     "[--fontsize (large|giant)]",
     N_("Specify the font size.") },
   { "-large",                 CLA_NO,            CLO_LARGE,
     "[-large]",
     N_("Specify LARGE font") },
   { "-giant",                 CLA_NO,            CLO_GIANT,
     "[-giant]",
     N_("Specify GIANT font") },

#ifdef ARENA_FLYBY_HELP
   { "--noflyby-hints",        CLA_NO,            CLO_NOFLYBY,
     NULL,
     NULL },
   { "--flyby-hints",          CLA_REQUIRED,      CLO_FLYBY,
     "[--flyby-hints (none|hint|terse|verbose)]",
     N_("Controls fly by help text output.") },
#endif

   { "--color",                CLA_REQUIRED,      CLO_COLOUR,
     "[--color (true|dither|mono|grey)]",
     N_("Specify the type of colour setup desired") },
   { "--colour",               CLA_REQUIRED,      CLO_COLOUR,
     NULL,
     NULL },

   { "-color",                 CLA_NO,            CLO_COLOUR888,
     "[-color]",
     N_("True colour mode.") },
   { "-color8",                CLA_NO,            CLO_COLOUR232,
     "[-color8]",
     N_("232 dither mode.") },
   { "-mono",                  CLA_NO,            CLO_MONO,
     "[-mono]",
     N_("Monochrome mode.") },
   { "-grey",                  CLA_NO,            CLO_GREY,
     "[-grey]",
     N_("Greyscale mode.") },
   { "-gray",                  CLA_NO,            CLO_GREY,
     NULL,
     NULL },
   
   
   { "--color-map",            CLA_NO,            CLO_CM,
     "[--[no-]color-map]",
     NULL },
   { "-cm",                    CLA_NO,            CLO_CM,
     "[-[no]cm]",
     N_("Use a separate colourmap.") },
   { "-nocm",                  CLA_NO,            CLO_NOCM,
     NULL,
     NULL },
   { "--no-color-map",         CLA_NO,            CLO_NOCM,
     NULL,
     NULL },
   { "--nocolor-map",          CLA_NO,            CLO_NOCM,
     NULL,
     NULL },
   { "--no-colour-map",        CLA_NO,            CLO_NOCM,
     NULL,
     NULL },   

   { "-gamma",                 CLA_REQUIRED,      CLO_GAMMA,
     "[-gamma correction]",
     NULL },
   { "--gamma",                CLA_REQUIRED,      CLO_GAMMA,
     "[--gamma correction]",
     N_("Set the gamma correction factor.") },
   

   /* As an example...
    * Note that -cache and --persistent-cache take care of showing the
    * user ALL the options [-no]cache [path]] and
    * [--[no]-persistent-cache [path]].  The other entries below these two
    * are there to take care of spelling, and the actual NO- option matching.
    */
   { "-cache",                 CLA_REQUIRED,      CLO_CACHE,
     "[-[no]cache [path]]",
     NULL },
   { "--persistent-cache",     CLA_REQUIRED,      CLO_CACHE,
     "[--[no-]persistent-cache [path]]",
     N_("Specify path of persistent cache.\n          " \
     "Default ~/.Arena/cache/\n          " \
     "Or, specifying no caching to be done") },
   { "-nocache",               CLA_NO,            CLO_NOCACHE,
     NULL,
     NULL },
   { "-no-cache",              CLA_NO,            CLO_NOCACHE,
     NULL,
     NULL },
   { "--nopersistent-cache",   CLA_NO,            CLO_NOCACHE,
     NULL,
     NULL },
   { "--no-persistent-cache",  CLA_NO,            CLO_NOCACHE,
     NULL,
     NULL },
   
   
   { "-nostyle",               CLA_NO,            CLO_NOSTYLE,
     "[-nostyle]",
     NULL },
   { "--no-style-sheets",      CLA_NO,            CLO_NOSTYLE,
     "[--no-style-sheets]",
     N_("Do NOT take the <STYLE> tag into account when redering pages.") },

   /* This is here to test the input of VERY long argument values */
   { "--STYLE-TESTING-OPTION", CLA_REQUIRED,      CLO_STYLE,
     NULL,
     NULL },
   
   
   { "-display",               CLA_REQUIRED,      CLO_DISPLAY,
     "[-display X11-display]",
     NULL },
   { "--display",              CLA_REQUIRED,      CLO_DISPLAY,
     "[--display X11-display]",
     N_("To open Arena on a display other than $(DISPLAY)") },
   
   
   { "-geometry",              CLA_REQUIRED,      CLO_GEOMETRY,
     "[-geometry +X+Y]",
     NULL },
   { "--geometry",             CLA_REQUIRED,      CLO_GEOMETRY,
     "[--geometry +X+Y]",
     N_("Crippled window geometry") },
   
   
   { "-lens",                  CLA_REQUIRED,      CLO_LENS,
     "[-lens XFactor]",
     NULL },
   { "--magstep",              CLA_REQUIRED,      CLO_LENS,
     "[--magstep XFactor]",
     NULL },
   { "--magnification",        CLA_REQUIRED,      CLO_LENS,
     "[--magnification XFactor]",
     N_("Set the magnification factor for font selection.") },
   
   { "--history",             CLA_REQUIRED,       CLO_HISTORY,
     "[--history (none|delete|semi|chain)]",
     N_("Specify history mechanism used") },
   
   { "-icon",                  CLA_REQUIRED,      CLO_ICON,
     "[-icon file.gif]",
     NULL },
   { "--application-icon",     CLA_REQUIRED,      CLO_ICON,
     "[--application-icon file.gif]",
     N_("Replace the default icon in upper right corner") },


   { "-plain",                 CLA_NO,           CLO_PLAIN,
     NULL,
     NULL },
   { "--plain",                CLA_NO,           CLO_PLAIN,
     NULL,
     NULL },


   { "-badflags",              CLA_REQUIRED,     CLO_BADFLAGS,
     "[-badflags #]", 
     NULL },
   { "--maximum-badflags",     CLA_REQUIRED,     CLO_BADFLAGS,
     "[--maximum-badflags #]",
     N_("Maximum number of HTML bad flags to report.") },
   
   
   { "-editor",                CLA_REQUIRED,     CLO_EDITOR,
     "[-editor cmd]",
     NULL },
   { "--edit-command",         CLA_REQUIRED,     CLO_EDITOR,
     "[--edit-command cmd]",
     N_("Set external editor command, e.g. \"xterm -e vi\".") },
   
   
   { "-printer",               CLA_REQUIRED,     CLO_PRINTER,
     "[-printer cmd]",
     NULL },
   { "--print-command",        CLA_REQUIRED,     CLO_PRINTER,
     "[--print-command cmd]",
     N_("Set printer command, e.g. \"lpr -Ppr1\".") },

   { "-email",                 CLA_REQUIRED,     CLO_EMAIL,
     "[-email address]",
     NULL },
   { "--e-mail-address",       CLA_REQUIRED,     CLO_EMAIL,
     "[--e-mail-address address]",
     N_("Specify return mail address.") },
   { "--email-address",        CLA_REQUIRED,     CLO_EMAIL,
     NULL,
     NULL },
   
   { "-nomailcap",             CLA_REQUIRED,     CLO_XMAILER,
     "[-nomailcap]",
     NULL },
   { "--no-mailcap",           CLA_REQUIRED,     CLO_XMAILER,
     "[--no-mailcap]",
     N_("Do NOT load any mailcap files.") },
   
   /* Maybe setup up later to "run an external mail program (e.g. elm...?)"
   { "-m",                     CLA_REQUIRED,     CLO_XMAILER,
     "[-m cmd]",
     NULL },
   { "--external-mail",        CLA_REQUIRED,     CLO_XMAILER,
     "[--external-mail cmd]",
     N_("Path and command of external mail command.") },
     BUT NOT DONE AT THIS TIME.... NOT SURE WE WANT ARENA TO DO "EVERYTHING" */

   { "-debug",                 CLA_NO,           CLO_DEBUG,
     "[-debug]",
     N_("Turn on debugging output.") },
   { "--debug",                CLA_OPTIONAL,     CLO_DEBUG,
     "[--debug [client-trace-value]]",
     N_("Turn on Arena debug tracing output.") },

   { "-ct",                    CLA_REQUIRED,     CLO_CT,
     NULL, 
     NULL },
   { "--client-trace",         CLA_REQUIRED,     CLO_CT,
     NULL,
     NULL },
   
   { "-lt",                    CLA_OPTIONAL,     CLO_LT,
     "[-lt [W3C-Flags]]",
     NULL },
   { "--libwww-trace",         CLA_OPTIONAL,     CLO_LT,
     "[--libwww-trace [W3C-Flags]]",
     N_("Specifies the W3C debugging trace flags.") },

   { "--scrollbar-thickness",  CLA_REQUIRED,     CLO_SBARTHICK,
     "[--scrollbar-thickness pixels]",
     N_("Specify thickness of scrollbars in pixels.") },

   { "--flyby",                CLA_REQUIRED,     CLO_FLYBY,
     "[--flyby none|hint|terse|verbose]",
     N_("Specify `fly by tips' verbosity level.") },

   { NULL,     /* This entry for loop ending test only! */
     CLA_NO,
     CLO_UNKNOWN,
     NULL,
     NULL}
  };

#endif	/* ___ARENA_CMDLINE_H___ */
