/*
 * Error printing tools.	QingLong.14-12-96
 */


#include "arena.h"
#include "types.h"
#include "util.h"
#include "editor.h"	/* For `Arena_RecordError' */

#ifdef ARENA_DEBUG	/* QingLong.24-01-97 */
#  include "debug.h"
#endif

#define ARENA_PREFIX          " "BANNER": "
#define ARENA_PREFIX_LENGTH   (BANNER_LENGTH + 3)

/*
 * Stylization of error printing. QingLong.14-12-96.
 * For simpler internationalizations... glk.3.11.97
 * Small fix to allow output_format to NOT have to have a leading <SPACE>
 */
#ifdef __STDC__
int Arena_PrintError(char* output_format, ...)
# else
int Arena_PrintError(output_format, va_alist)
     char* output_format;
     va_dcl
#endif
{
 int ret;
 va_list args;

 ret = fprintf(stderr, ARENA_PREFIX);

 if (output_format[0] != ' ')
   ret += fprintf(stderr, " ");

 va_start(args, output_format);
 ret += vfprintf(stderr, output_format, args);
 va_end(args);

 return ret;
}


/*
 * Arena_RecordError records position and nature of error to
 * generate listing and (if debugging) prints a pointer value
 * along with supplied string (nature of error).
 */
void Arena_RecordError(Doc* theCurrentDoc, char* p, char* s)
{
 BadFlag* h = NULL;

 if (theCurrentDoc == NULL || p == NULL) return;
 if (Arena_StrLen(s) <= 0) return;

 if (theCurrentDoc->bad_flags == NULL)
   theCurrentDoc->bad_flags = HTList_new();

 if ((h = (BadFlag*)Arena_CAlloc(sizeof(BadFlag), 1, False)) == NULL)
   return;

 /* Store the postion of the NEXT char in the buffer...
  * This simplifies the "length" calculations later.
  */
 h->p = p + 1;

 /* ALLOCATE the error text message... This is why we cannot
  * use the HTList freeing, removal... etc.
  * Replaced a calloc() and strndup() to the h->error_text. LEAKAGE!
  */
 h->error_text = NULL;
 StrAllocCopy(h->error_text, s);

 /* append this object to TAIL of our list!  By using _append here, we can
  * use the _nextObject() to "walk" the list in the correct order!
  * DO NOT use HTList_delete, _remove, etc with this object... These objects
  * cannot be Free() only... They have pointers that must ALSO be Free().
  * Use delete_Document_bad_flags() only!!!!
  */
 HTList_appendObject(theCurrentDoc->bad_flags, (void*)h);

#ifdef ARENA_DEBUG	/* QingLong.16-12-96 */
 if (BADFLAG_TRACE) Arena_DebugPrint(" %s "POINTER_FORMAT"\n", s, p);
#endif
}
