#ifndef ___ARENA_MENU_H___
#  define ___ARENA_MENU_H___


/*
 * Type definitions.
 */

typedef struct MenuRoot
{
  struct MenuItem *first;    /* first item in menu */
  struct MenuItem *last;     /* last item in menu */
  char *name;		     /* name of root, title */
  int x;
  int y;
  int x_root;
  int y_root;
  unsigned int w;	     /* width of the menu */
  unsigned int h;	     /* height of the menu,  */
  unsigned int items;	     /* number of items in the menu */
  unsigned int y_offset;     /* where initial item begins (below separator)*/
} MenuRoot;


typedef struct MenuItem
{
  struct MenuItem *next;    /* next menu item */
  char *label;		    /* the character string displayed on left*/
  char *url;                /* url if action is GOTO */
  int  action;		    /* action to be performed */
  unsigned int item_pos;    /* item number of this menu */ 
  int x;		    /* x coordinate for item*/
  int y;		    /* y coordinate for item */
  short state;		    /* state, ACTIVE_BUTTON or INACTIVE_BUTTON */
  unsigned int strlen;	    /* strlen(item) */
#ifdef SUB_MENUS
  struct MenuRoot *menu;    /* sub-menu */
#endif
} MenuItem;


/*
 * Functions.
 */

void initPopup(XFontStruct *pf);
void Popup(GC gc, ViewWindow view_window, int x, int y);


#endif	/* ifndef ___ARENA_MENU_H___ */
