/*
 * W3C lamers have provided no methods!
 */
#include "arena.h"
#include "types.h"
#include "HTAnchor.h"
#include "HTAncMan.h"

char* HTChildAnchor_tag (HTChildAnchor* theChildAnchor)
{
 char* thetag = NULL;

 if (theChildAnchor == NULL) return thetag;
 if (theChildAnchor->tag == NULL) return thetag;
 if (*theChildAnchor->tag == 0) return thetag;

 StrAllocCopy(thetag, theChildAnchor->tag);
 return thetag;
}

/* Child anchors that get loaded without the "parent" being loaded first!
 * We end up with urls including the #tag.  That's ok until we get a different
 * child for the same document.  Then the doc->url is still the same as before!
 * So, get an HTAnchor_address(), but remove ANY #tags.
 */
char *HTAnchor_basicAddress(HTAnchor* me)
{
 char *url = NULL;

 if (me)
    if (me->parent->address)
      StrAllocCopy(url, me->parent->address);
 return url;
}

/* Fix up a simple routine to see if this anchor is a ChildAnchor*
 * Seem to be doing it all over the place, so simplify!
 */
Bool HTAnchor_isChild(HTAnchor* me)
{
 HTChildAnchor* cme = (HTChildAnchor*)me;

 if (me)
   if ((HTAnchor*)HTAnchor_parent(me) != (HTAnchor*)me)
     if ( cme->tag && *cme->tag)
       return 1;

 return 0;
}
