// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        arrays.h
//
// Purpose:     interface to dynamic array declarations
//
// Created:     22 Mar 96   Michael Pichler
//
// Changed:      4 Jun 96   Michael Pichler
//
// $Id: arrays.h,v 1.4 1997/02/25 16:59:31 mpichler Exp $
//
//</file>

// note: implementation of IntArray::set_value contained in wrlpick.C


#ifndef harmony_scene_arrays_h
#define harmony_scene_arrays_h


#include <hyperg/utils/fields.h>


// dynamic integer array

Fieldsdeclare(Int__Array, int)


class IntArray: public Int__Array
{
  public:
    IntArray (int len = 4)   // pre-allocate space for 4 integers (count is 0)
    : Int__Array (len)  { }  // (reduces memory fragmentation)

    void set_value (int index, int value);
    // set value of index'th field; array will be enlarged if necessary;
    // contents between previous end and new index is undefined

    void set_count (int count)          // set count (no. of field items)
    { count_ = count; }                 //   to new number (cut off trailing garbage)

    // among the inherited public methods of Field:
    // void free ();
    // void append (int value);
    // int count () const;
    // const int* data () const;
    // ostream& operator << (...)  (for debugging)

}; // IntArray


#endif
