// -*- C++ -*-
//<copyright>
//
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:     nonmodaldlg.h
//
// Purpose:
//
// Created:  17.11.94   Gaisbauer Mansuet Juergen
//
// $Id: nonmodaldlg.h,v 1.1 1996/05/21 07:28:22 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: nonmodaldlg.h,v $
// Revision 1.1  1996/05/21 07:28:22  bmarsch
// Initial revision
//

#ifndef __nonmodaldlg_h__
#define __nonmodaldlg_h__

#include <InterViews/dialog.h>
#include <InterViews/window.h>

class Glyph;
class Style;


//<class>
//
// Name: NonModalDialog
//
// Purpose: Non modal dialog
//
// Public Interface:
//
//  - NonModalDialog(Glyph* g, Style* s)
//  - virtual ~NonModalDialog();
//
//  - void dismiss(boolean accept)
//    called if the dialog is dismissed. accept contains how the dialog
//    is close (cancel / ok)
//
//  - void postForAlignedNM(Window* w, float xalign, float yalign)
//    maps the non modal dialog aligned to the window w.
//
//  - void postForNM(Window* w)
//    maps the non modal dialog centered according to the window w.
//
//  - void postAtAlignedNM(Coord x, Coord y, float x_align, float y_align)
//    maps the the dialog aligned to point (x,y)
//
// Description:
//
//</class>

class NonModalDialog : public Dialog {
public:
  NonModalDialog(Glyph* g, Style* s);
  virtual ~NonModalDialog();

  virtual void dismiss(boolean accept);

  boolean post_for(Window* w);
  boolean post_for_aligned(Window* w, float xalign, float yalign);
  virtual boolean post_at_aligned(
    Coord x, Coord y, float x_align, float y_align
  );

  boolean isMapped();

protected:
  TransientWindow* win_;
};

inline boolean NonModalDialog::post_for(Window* w) {
  return post_for_aligned(w, 0.5, 0.5);
}

inline boolean NonModalDialog::post_for_aligned(Window* w, float xalign, float yalign) {
  Coord x = w ? w->left() + 0.5 * w->width() : 0;
  Coord y = w ? w->bottom() + 0.5 * w->height() : 0;
  return post_at_aligned(x, y, xalign, yalign);
}

inline boolean NonModalDialog::isMapped() {
  return win_ ? win_->is_mapped() : false;
}

#endif
