/*
     WWW-SQL - parses HTML files and inserts information from MySQL databases
    Copyright (C) 1997  James Henstridge <james@daa.com.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 *   cmds.c
 * This file contains the code that does variable expansion, and picks which
 * commands to execute.
 */

#include <stdio.h>
#include <string.h>
#include "cmds.h"
#include "cgi.h"
#include "if.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* variable expansion code */
char *sqlEscape(char *str) {
  char *buf, *ret;
  int len, i, j;

  len = strlen(str);
  buf = xmalloc(len * 2 + 1); /* worst case */
  memset(buf, 0, len * 2 + 1);
  for (i=j=0; str[i] != '\0'; i++,j++)
    if (strchr("'\"\\", str[i])) {
      buf[j] = '\\';
      j++;
      buf[j] = str[i];
    } else if (str[i] == '\n') {
      buf[j] = '\\';
      j++;
      buf[j] = 'n';
    } else if (str[i] == '\t') {
      buf[j] = '\\';
      j++;
      buf[j] = 't';
    } else if (str[i] == '\r') {
      buf[j] = '\\';
      j++;
      buf[j] = 'r';
    } else if (str[i] == '\b') {
      buf[j] = '\\';
      j++;
      buf[j] = 'b';
    } else
      buf[j] = str[i];
  ret = xstrdup(buf);
  free(buf);
  return ret;
}

char *htmlEscape(char *str) {
  char *buf, *ret;
  int len, i, j;

  len = strlen(str);
  buf = xmalloc(6 * len + 1);
  memset(buf, 0, 6 * len + 1);
  for (i=j=0; str[i]; i++,j++)
    if (str[i] == '&') {
      strcpy(&buf[j], "&amp;");
      j += 4;
    } else if (str[i] == '>') {
      strcpy(&buf[j], "&gt;");
      j += 3;
    } else if (str[i] == '<') {
      strcpy(&buf[j], "&lt;");
      j += 3;
    } else if (str[i] == '"') {
      strcpy(&buf[j], "&quot;");
      j += 5;
    } else
      buf[j] = str[i];
  ret = xstrdup(buf);
  free(buf);
  return ret;
}

/* this function should be defined in the database specific functions file */
char *substField(char *imp, int *toklen);

char *substVars(char *s) {
  static char buf[6144];  /* static for speed */
  char *val, *val2;
  int i, j, k, len;
  VAR *var;
  enum {NORMAL, CGI_ESCAPE, SQL_ESCAPE, HTML_ESCAPE} esc_flag;

  len = strlen(s);
  bzero(buf, sizeof(buf));
  for (i=0,j=0; i<len && j < 6143; i++) {
    esc_flag = NORMAL;
    switch (s[i]) {
      case '\\':
        switch(s[i+1]) {
          case 'n': buf[j] = '\n'; break;
          case 't': buf[j] = '\t'; break;
          case '$':
          case '@':
          case '#':
          case '?':
          case '~':
          case '\\': buf[j] = s[i+1]; break;
          default:  buf[j] = '\\'; i--; break;
        }
        i++; j++; break;

      case '#':
        esc_flag = CGI_ESCAPE;  /* fall through to the next */
      case '?':
        if (esc_flag == NORMAL) esc_flag = SQL_ESCAPE;
      case '~':
        if (esc_flag == NORMAL) esc_flag = HTML_ESCAPE;
      case '$':
      case '@':
        val = NULL;
        for (var = firstVar; var != NULL; var = var->next)
          if (!strncmp(s+i+1, var->name, strlen(var->name))) {
            i+= strlen(var->name);
            val = var->value;
          }
	if (val == NULL) {
	  val = substField(&s[i+1], &k);
	  if (val != NULL)
	    i+= k;
	}
        if (val == NULL) {
          buf[j] = s[i];
          j++;
        } else {
          switch (esc_flag) {
            case CGI_ESCAPE:
              val2 = escape_string(val);
              strcpy(&buf[j], val2);
              j += strlen(val2);
              free(val2);
              break;
            case SQL_ESCAPE:
              val2 = sqlEscape(val);
              strcpy(&buf[j], val2);
              j += strlen(val2);
              free(val2);
              break;
            case HTML_ESCAPE:
              val2 = htmlEscape(val);
              strcpy(&buf[j], val2);
              j += strlen(val2);
              free(val2);
              break;
            case NORMAL:
              strcpy(&buf[j], val);
                  j += strlen(val);
          }
        }
        break;

      default:
        buf[j] = s[i];
        j++;
        break;
    }
  }
  return xstrdup(buf);
}


extern commands other_funcs, db_funcs, if_funcs;

#ifdef RECURSIVE
/* variable saying if any expansions have been done */
extern int dirty;
#endif

/* This function is the callback for the scanner */
void executeSql(int argc, char *argv[]) {
  int i;

#define pickCmd(cmds) \
          for (i = 0; cmds[i].name != NULL; i++) \
	    if (!strcasecmp(argv[0], cmds[i].name)) \
	      return cmds[i].func(argc-1, argv+1)
  if (argc < 1) return;

#ifdef RECURSIVE
  /* code to allow recursive parsing of output */
  dirty = 1;
#endif

  pickCmd(if_funcs);
  if (checkIf) {
    pickCmd(other_funcs);
    pickCmd(db_funcs);
    /* else */
    fprintf(yyout, "<p><b>Unknown command:</b> ");
    for (i=0;i<argc;i++) fprintf(yyout, "%s ", argv[i]);
    fprintf(yyout, "</p>\n");
  }

#undef pickCmd
}
