/*
 *--------------------------------*-C-*---------------------------------
 * File:        xdefaults.h
 *
 * Copyright (c) 1994 R. Nation <nation@rocket.sanders.lockheed.com>
 * Copyright (c) 1997 Mj Olesen <olesen@me.QueensU.CA>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License version
 *  2 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */

#ifndef _XDEFAULTS_H
#define _XDEFAULTS_H

/*{{{ includes */
#include <X11/Xfuncproto.h>
#include <X11/Intrinsic.h>	/* Xlib, Xutil, Xresource, Xfuncproto */
#include "xiterm.h"
/*}}} */

/*{{{ extern variables */
extern const char *rs_title;	/* title name for window */
extern const char *rs_iconName;	/* icon name for window */
extern const char *rs_geometry;	/* window geometry */
extern const char *rs_saveLines;	/* scrollback buffer [lines] */

#ifdef KEYSYM_RESOURCE
extern const unsigned char *KeySym_map[256];
#endif

#if defined (HOTKEY_CTRL) || defined (HOTKEY_META)
extern KeySym ks_bigfont;
extern KeySym ks_smallfont;
#endif

#ifdef XPM_BACKGROUND
extern const char *rs_path;
extern const char *rs_backgroundPixmap;
#endif				/* XPM_BACKGROUND */
/*}}} */

/*{{{ prototypes */
_XFUNCPROTOBEGIN

extern void
 extract_resources(Display * /* display */ ,
		   const char * /* name */ );

extern void
 get_options(int /* argc */ ,
	     char * /* argv */ []);

_XFUNCPROTOEND
/*}}} */

#endif				/* whole file */
/*----------------------- end-of-file (C header) -----------------------*/
