/*
 *  WindowMaker miscelaneous function library
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "wwmlib.h"
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

#ifdef WMAKER
extern void wAbort();
#else
# define wAbort() exit(1)
#endif

static int Aborting=0; /* if we're in the middle of an emergency exit */


void *xmalloc(size_t size)
{
    void *tmp;
    
    tmp = malloc(size);
    if (tmp == NULL) {
	wWarning("malloc() failed. Retrying after 2s.");
	sleep(2);
	tmp = malloc(size);
	if (tmp == NULL) {
	    if (Aborting) {
		puts("Real Bad Error: recursive malloc() failure.");
		exit(-1);
	    } else {
		wFatal("virtual memory exhausted");
		Aborting=1;
		wAbort();
	    }
	}
    }
    return tmp;
}


void *xrealloc(void *ptr, size_t newsize)
{
    void *nptr;

    if (!ptr) {
	nptr = malloc(newsize);
    } else {
	nptr=realloc(ptr, newsize);
    }
    if (nptr==NULL) {
	printf("Could not do realloc");
	return NULL;
    }
    return nptr;
}
