/*
 *      A simple sample test program; see the Using.tex document for details.
 *
 *      Copyright 1991 by Burdett, Buckeridge & Young Ltd.
 *
 *      klin, Sat Aug 15 13:39:50 1992, <At/..> changed to <X11/At/...>
 */

/* First, the various headers required */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>

#include <X11/At/Plotter.h>
#include <X11/At/LinePlot.h>
#include <X11/At/BarPlot.h>
#include <X11/At/Axis.h>

/*
 * The application data - weekly sales data for Widgets.
 */
struct profits {
     /* From database */
     long volume;
     float buy_price;
     float sell_price;
     /* calculated values */
     double sales;
     double cost;
     double profit;
};

#define NUM_WEEKS 52

struct profits profits[NUM_WEEKS];

/*
 * Read from the database - a dummy routine, we'll use random numbers
 */
void ReadFromDatabase()
{
     int i;
     extern int rand();

     for (i = 0; i < NUM_WEEKS; i++) {
	  /* Volume between 1000 and 5095 */
	  profits[i].volume = (rand() & 0xfff) + 1000;
	  /* Sell price between $15 and $25 */
	  profits[i].sell_price = (double)(rand() & 0xffffff) /
	       0xffffff * 10.0 + 15.0;
	  /* Buy price between $5 and $15 */
	  profits[i].buy_price = (double)(rand() & 0xffffff) /
	       0xffffff * 10.0 + 5.0;
     }
}

/*
 * Calculate the profit from the above data
 */

void CalculateProfit()
{
     int i;

     for (i = 0; i < NUM_WEEKS; i++) {
	  profits[i].sales = profits[i].volume *
	       profits[i].sell_price;
	  profits[i].cost = profits[i].volume * profits[i].buy_price;
	  profits[i].profit = profits[i].sales - profits[i].cost;
     }
}


/*****************************************************************
 *
 * This is the interesting bit.  Make a simple graph, profits on left,
 * volume on right, weeknumber on bottom, profit a line graph, volume
 * a bar graph.
 */

Widget plotter, xaxis, yaxis, y2axis, line, bar;

void MakePlotter(parent)
Widget parent;
{
     double thousandth = 1.0e-3;

     plotter = XtVaCreateManagedWidget("plotter", atPlotterWidgetClass, parent,
				       XtNtitle, "@diamonds  Widget Sales & Profits  @diamonds",
				       XtNwidth, 600, XtNheight, 450,
				       NULL);
     /* Note axis objects are unmanaged */
     xaxis = XtVaCreateWidget("xaxis", atAxisWidgetClass, plotter,
			      XtNlabel, "Week Number",
			      XtNticFormat, "%.0f",
			      NULL);

     /* Note Y axis is vertical */
     yaxis = XtVaCreateWidget("yaxis", atAxisWidgetClass, plotter,
			      XtNvertical, True,
			      XtNlabel, "Profit ($1,000's)",
			      XtNticMultiplier, &thousandth,
			      NULL);
     /* Note Y2 axis is vertical and mirrored */
     y2axis = XtVaCreateWidget("y2axis", atAxisWidgetClass, plotter,
			       XtNvertical, True,
			       XtNmirror, True,
			       XtNlabel, "Volume Shipped (1,000s)",
			       XtNdrawGrid, False, /* Two grids is confusing */
			       XtNticMultiplier, &thousandth,
			       XtNticFormat, "%4.1f",
			       NULL);
     /* Now attach axes to the parent */
     XtVaSetValues(plotter, XtNxAxis, xaxis,
		   XtNyAxis, yaxis,
		   XtNy2Axis, y2axis,
		   NULL);

     /* Now create the plots */
     /* The volume is scaled against y2 axis */
     bar = XtVaCreateWidget("vol", atBarPlotWidgetClass, plotter,
			    XtNlegendName, "Volume",
			    XtNuseY2Axis, True,
			    XtNshading, AtGRAY3, /* For better PS */
			    NULL);
     /* But profit against Y axis */
     line = XtVaCreateWidget("profit", atLinePlotWidgetClass, plotter,
			     XtNlegendName, "Profit",
			     XtNlineWidth, 2,
			     NULL);
}

/*****************************************************************
 *
 * Attach the application data to the plot children
 */

void AttachData()
{
     AtLinePlotAttachData(line, (XtPointer)&profits[0].profit,
			  AtDouble, sizeof (struct profits),
			  1, NUM_WEEKS);
     AtBarPlotAttachData(bar, (XtPointer)&profits[0].volume,
			 AtInt, sizeof (struct profits),
			 1, NUM_WEEKS);
}

/*****************************************************************
 *
 * This is the boring bit: a form with two buttons and the plotter as
 * children
 */

Widget form, quitbutton, printbutton, dragbutton;

#ifndef __STDC__
extern int exit();
#endif

void quit_callback()
{
     exit(0);
}

void print_callback()
{
     AtPlotterGeneratePostscript("ps.out", (AtPlotterWidget)plotter,
				 "Widget Profits", 0, 0, 400, 250, False);
     fprintf(stderr, "Plot dumped in ps.out\n");
}

static double oldxmin, oldxmax, oldymin, oldymax;

void get_drag_callback(widget, client_data, call_data)
  Widget widget;
  XtPointer client_data;
  AtRectangleCallbackData *call_data;
{
  Arg args[4];
  static double x1, y1, x2, y2;
  AtTransform tx, ty;

  tx = AtAxisGetTransform(xaxis);
  ty = AtAxisGetTransform(yaxis);
  x1 = call_data->x11;
  x2 = call_data->x12;
  y1 = call_data->y11;
  y2 = call_data->y12;
  XtSetArg(args[0], XtNmin, &x1);
  XtSetArg(args[1], XtNmax, &x2);
  XtSetArg(args[2], XtNautoScale, False);
  XtSetValues(xaxis, args, 3);
  XtSetArg(args[0], XtNmin, &y1);
  XtSetArg(args[1], XtNmax, &y2);
  XtSetArg(args[2], XtNautoScale, False);
  XtSetValues(yaxis, args, 3);
  printf("Get drag callback: tx=%d x1=%lf x2=%lf ty=%d y1=%lf y2=%lf\n",
	  tx, x1, x2, ty, y1, y2);
}

void drag_callback()
{
  Arg args[4];
  int n;
  static int t = 0;

  if(t) {
    XtSetArg(args[0], XtNmin, &oldxmin);
    XtSetArg(args[1], XtNmax, &oldxmax);
    XtSetArg(args[2], XtNautoScale, True);
    XtSetValues(xaxis, args, 3);
    XtSetArg(args[0], XtNmin, &oldymin);
    XtSetArg(args[1], XtNmax, &oldymax);
    XtSetArg(args[2], XtNautoScale, True);
    XtSetValues(yaxis, args, 3);
    XtRemoveAllCallbacks(plotter, XtNdragCallback);
    printf("Drag callback: get drag 1 -> 0\n");
    t = 0;
  }
  else {
    XtVaGetValues(xaxis, XtNmin, &oldxmin, XtNmax, &oldxmax, NULL);
    XtVaGetValues(yaxis, XtNmin, &oldymin, XtNmax, &oldymax, NULL);
    XtAddCallback(plotter, XtNdragCallback, get_drag_callback, NULL);
    printf("Drag callback: get drag 0 -> 1\n");
    t = 1;
  }
}

void MakeForm(parent)
Widget parent;
{
     form = XtVaCreateManagedWidget("form", formWidgetClass, parent, NULL);
     quitbutton = XtVaCreateManagedWidget("quit", commandWidgetClass, form,
					  XtNlabel, "Quit",
					  XtNleft, XtChainLeft,
					  NULL);
     XtAddCallback(quitbutton, XtNcallback, quit_callback, NULL);
     printbutton = XtVaCreateManagedWidget("print", commandWidgetClass, form,
					   XtNlabel, "Print",
					   XtNfromHoriz, quitbutton,
					   NULL);
     XtAddCallback(printbutton, XtNcallback, print_callback, NULL);

     dragbutton = XtVaCreateManagedWidget("drag", commandWidgetClass, form,
					  XtNlabel, "Drag",
					  XtNfromHoriz, printbutton,
					  NULL);
     XtAddCallback(dragbutton, XtNcallback, drag_callback, NULL);
}


int main(ac, av)
Cardinal ac;
char **av;
{
     Widget appShell;
     XtAppContext app;

     appShell = XtAppInitialize(&app, "Test", NULL, 0, &ac, av,
				NULL, NULL, 0);

     MakeForm(appShell);
     MakePlotter(form);
     /* Make the plotter below the buttons! */
     XtVaSetValues(plotter, XtNleft, XtChainLeft,
		   XtNfromVert, quitbutton,
		   NULL);

     /* Now read the data and calculate it */
     ReadFromDatabase();
     CalculateProfit();

     /* Now attach the data to the plot widget */
     AttachData();

     XtRealizeWidget(appShell);

     XtAppMainLoop(app);
     /*NOTREACHED*/
     return 0;
}
