;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Read/include.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:44:03 1994                          */
;*    Last change :  Thu Aug  8 12:06:00 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We read an include file                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_include
   (import  engine_param
	    engine_engine
	    tools_speek
	    tools_file
	    tools_error
	    init_main)
   (export  (read-include ::bstring)))

;*---------------------------------------------------------------------*/
;*    read-include ...                                                 */
;*---------------------------------------------------------------------*/
(define (read-include file)
   (let ((cell (include-already-read file)))
      (if (not (pair? cell))
	  (begin
	     (verbose 2 "      [reading include file " file "]" #\Newline)
	     (let ((fname (find-file/path file *load-path*)))
		(if (not (string? fname))
		    (user-error "read-include" "Can't find include file" file)
		    (let ((port (open-input-file fname)))
		       (if (not (input-port? port))
			   (user-error "read-include"
				       "Can't open such file"
				       file)
			   (let ((handler (lambda (escape proc mes obj)
					     (notify-error proc mes obj)
					     (close-input-port port)
					     (exit-bigloo -3))))
			      (try (let* ((first (read port #t))
					  (direc (if (and (pair? first)
							  (eq? (car first)
							       'directives))
						     first
						     '())))
				      (let loop ((aux  (if (pair? direc)
							   (read port #t)
							   first))
						 (sexp '()))
					 (if (eof-object? aux)
					     (let ((r (cons direc
							    (reverse! sexp))))
						(close-input-port port)
						(mark-include-read! file r)
						r)
					     (loop (read port #t)
						   (cons aux sexp)))))
				   handler)))))))
	  (cdr cell))))

;*---------------------------------------------------------------------*/
;*    include-already-read ...                                         */
;*---------------------------------------------------------------------*/
(define (include-already-read file)
   (assoc file *include-read*))

;*---------------------------------------------------------------------*/
;*    mark-include-read! ...                                           */
;*---------------------------------------------------------------------*/
(define (mark-include-read! file what)
   (set! *include-read* (cons (cons file what) *include-read*)))

;*---------------------------------------------------------------------*/
;*    *include-read* ...                                               */
;*---------------------------------------------------------------------*/
(define *include-read* '())
