;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Write/expanded.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:03:54 1994                          */
;*    Last change :  Wed Dec 17 17:33:31 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pretty-print of expanded module.                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module write_expanded
   (include "Ast/unit.sch")
   (import  engine_param
	    write_scheme
	    tools_args
	    tools_file
	    ast_unit
	    module_module)
   (export  (write-expanded expanded)))

;*---------------------------------------------------------------------*/
;*    write-expanded ...                                               */
;*---------------------------------------------------------------------*/
(define (write-expanded units)
   (let* ((output-name (if (string? *dest*)
			   *dest*
			   (if (and (pair? *src-files*)
				    (string? (car *src-files*)))
			       (string-append (prefix (car *src-files*))
					      ".escm")
			       #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-expanded" "Can't open output file" output-name)
	  (unwind-protect
	     (begin
		(set! *pp-case* 'lower)
		(write-scheme-file-header port "The expanded module")
		(write-scheme-comment port "The module clause")
		(pp *module-clause* port)
		(newline port)
		(for-each
		 (lambda (u)
		    (if (unit-printable? u)
			(begin
			   (if (pair? (unit-sexp* u))
			       (write-scheme-comment port
						     (string-append
						      "unit: "
						      (symbol->string
						       (unit-id u)))))
			   ;; we loop on all units
			   (for-each
			    (lambda (code)
			       ;; we loop on all expression in a unit
			       (match-case code
				  ((define (?name . ?args) ?value)
				   (write-scheme-comment port name)
				   (pp code port))
				  ((define ?name ?value)
				   (write-scheme-comment port name)
				   (pp code port))
				  ((define-inline (?name . ?args) ?value)
				   (write-scheme-comment port name)
				   (pp code port))
				  (else
				   (pp code port))))
			    (let ((code (unit-sexp* u)))
			       (if (procedure? code)
				   (force code)
				   code)))
			   (newline port))))
		 units))
	     (if (and (output-port? port)
		      (not (eq? port (current-output-port))))
		 (close-output-port port))))))
