/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cdsssl.c                */
/*    -------------------------------------------------------------    */
/*    Author      :  SERRANO Manuel                                    */
/*    Creation    :  Thu Apr  3 11:37:14 1997                          */
/*    Last change :  Thu Feb 12 06:36:07 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    C Dsssl support.                                                 */
/*=====================================================================*/
#include <string.h>
#include <bigloo1.9c.h>

/*---------------------------------------------------------------------*/
/*    Some prototypes                                                  */
/*---------------------------------------------------------------------*/
extern obj_t string_to_keyword();
static obj_t make_keyword();
extern obj_t make_vector();

/*---------------------------------------------------------------------*/
/*    Global Keyword table                                             */
/*---------------------------------------------------------------------*/
static obj_t c_keytab;

/*---------------------------------------------------------------------*/
/*    init_keyword_table ...                                           */
/*---------------------------------------------------------------------*/
init_keyword_table()
{
   c_keytab = make_vector( KEYWORD_HASH_TABLE_SIZE, BNIL );
}
           
/*---------------------------------------------------------------------*/
/*    make_keyword ...                                                 */
/*---------------------------------------------------------------------*/
static obj_t
make_keyword( char *name )
{
   obj_t keyword;

   keyword = GC_MALLOC( KEYWORD_SIZE );
   
   keyword->keyword_t.header = MAKE_HEADER( KEYWORD_TYPE, KEYWORD_SIZE );
   keyword->keyword_t.name   = (char *)GC_MALLOC_ATOMIC( strlen( name ) + 1 );
   
   strcpy( keyword->keyword_t.name, name );

   return BREF( keyword );
}
   
/*---------------------------------------------------------------------*/
/*    string_to_keyword ...                                            */
/*    char * --> obj_t                                                 */
/*---------------------------------------------------------------------*/
obj_t
string_to_keyword( char *name )
{
   long hash_number;
   obj_t bucket;

   hash_number = get_hash_power_number( name, KEYWORD_HASH_TABLE_SIZE_SHIFT );
   bucket = VECTOR_REF( c_keytab, hash_number );
   
   if( NULLP( bucket ) )
   {
      obj_t keyword = make_keyword( name );
      obj_t pair    = MAKE_PAIR( keyword, BNIL );
      
      VECTOR_SET( c_keytab, hash_number, pair );
      
      return keyword;
   }
   else
   {
      obj_t run = bucket, back = bucket;
      
      while( !NULLP( run ) && strcmp( KEYWORD( CAR( run ) ).name, name ) )
         back = run, run = CDR( run );
      
      if( !NULLP( run ) )
         return CAR( run );
      else
      {
         obj_t keyword = make_keyword( name );
	 obj_t pair    = MAKE_PAIR( keyword, BNIL );
	 
         SET_CDR( back, pair );

         return keyword;
      }
   }
}


