/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.9/Clib/struct.c             */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Jun 16 09:28:53 1992                          */
/*    Last change :  Sat Jul 13 12:05:14 1996 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Structures constructions.                                        */
/*=====================================================================*/
#include <bigloo1.9c.h>

/*---------------------------------------------------------------------*/
/*    inline                                                           */
/*---------------------------------------------------------------------*/
#if( !defined( __GNUC__ ) )
#   define inline
#endif

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    set_struct ...                                                   */
/*---------------------------------------------------------------------*/
inline obj_t
set_struct( obj_t heap, obj_t key, long len )
{
   obj_t structure = (obj_t)heap;
   
#if( !defined( TAG_STRUCTURE ) )
   structure->struct_t.header = MAKE_HEADER( STRUCT_TYPE, byte_size );
#endif	

   structure->struct_t.key    = key;
   structure->struct_t.length = len;
   
   return BSTRUCTURE( structure );
}
   
/*---------------------------------------------------------------------*/
/*    create_struct ...                                                */
/*---------------------------------------------------------------------*/
obj_t
create_struct( key, len )
obj_t key;
long  len;
{
   long  byte_size = STRUCT_SIZE + ( (len-1) * OBJ_SIZE );
   
   return set_struct( (obj_t)GC_MALLOC( byte_size ), key, len );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    fill_struct ...                                                  */
/*---------------------------------------------------------------------*/
inline obj_t
fill_struct( obj_t structure, long len, obj_t init )
{
   long i;
   
   for( i = 0; i < len; i++ )
      STRUCT_SET( structure, i, init );

   return structure;
}

/*---------------------------------------------------------------------*/
/*    make_struct ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_struct( key, len, init )
obj_t key;
long  len;
obj_t init;
{
   obj_t structure;

   structure = create_struct( key, len );
   fill_struct( structure, len, init );
   
   return structure;
}

