;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/equiv.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 09:57:55 1995                          */
;*    Last change :  Mon Mar  2 07:10:18 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.2. Equivalence predicates (page 13, r4)                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_equivalence_6_2
   
   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__object                  "Llib/object.scm")
	    (__ucs2                    "Llib/ucs2.scm")
	    (__unicode                 "Llib/unicode.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    
	    (__evenv                   "Eval/evenv.scm"))
   
   (foreign (infix macro bool c-eq? (obj obj) "=="))
   
   (export  (eqv?::bool ::obj ::obj)
	    (inline eq?::bool  ::obj ::obj) 
	    (equal?::bool      ::obj ::obj))

   (pragma  (eqv? side-effect-free)
	    (eq? side-effect-free)
	    (c-eq? side-effect-free no-cfa-top)
	    (equal? side-effect-free no-cfa-top)))

;*---------------------------------------------------------------------*/
;*    eq? ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (eq? obj1 obj2)
   (c-eq? obj1 obj2))

;*---------------------------------------------------------------------*/
;*    eqv? ...                                                         */
;*---------------------------------------------------------------------*/
(define (eqv? obj1 obj2)
   (cond
      ((exact? obj1)
       (and (exact? obj2)
	    (= obj1 obj2)))
      ((inexact? obj1)
       (and (inexact? obj2)
	    (= obj1 obj2)))
      ((symbol? obj1)
       (and (symbol? obj2)
	    (string=? (symbol->string obj1)
		      (symbol->string obj2))))
      (else
       (eq? obj1 obj2))))

;*---------------------------------------------------------------------*/
;*    equal? ...                                                       */
;*---------------------------------------------------------------------*/
(define (equal? obj1 obj2)
   (cond
      ((c-eq? obj1 obj2)
       #t)
      ((fixnum? obj1)
       #f)
      ((symbol? obj1)
       #f)
      ((ucs2? obj1)
       #f)
      ((pair? obj1)
       (and (pair? obj2) (equal? (car obj1) (car obj2))
	    (equal? (cdr obj1) (cdr obj2))))
      ((vector? obj1)
       (let ((lobj1 (vector-length obj1)))
	  (and (vector? obj2)
	       (=fx (vector-length obj2) lobj1)
	       (=fx (vector-tag obj1) (vector-tag obj2))
	       (let test ((i (-fx lobj1 1)))
		  (or (=fx i -1)
		      (and (equal? (vector-ref-ur obj1 i)
				   (vector-ref-ur obj2 i))
			   (test (-fx i 1))))))))
      ((string? obj1)
       (and (string? obj2) (string=? obj1 obj2)))
      ((c-flonum? obj1)
       (and (c-flonum? obj2)
	    (=fl obj1 obj2)))
      ((c-struct? obj1)
       (let ((lobj1 (struct-length obj1)))
	  (and (struct? obj2)
	       (=fx (struct-length obj2) lobj1)
	       (let test ((i (-fx lobj1 1)))
		  (or (=fx i -1)
		      (and (equal? (struct-ref obj1 i) (struct-ref obj2 i))
			   (test (-fx i 1))))))))
      ((cell? obj1)
       (and (cell? obj2)
	    (equal? (cell-ref obj1) (cell-ref obj2))))
      ((number? obj1)
       (and (number? obj2)
	    (= obj1 obj2)))
      ((object? obj1)
       (and (object? obj2)
	    (object-equal? obj1 obj2)))
      ((ucs2-string? obj1)
       (and (ucs2-string? obj2) (ucs2-string=? obj1 obj2)))
      (else
       #f)))

