package biss.awt;

import biss.CommandQueue;
import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * replaces java.awt.Choice
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Choice
  extends Compound
  implements FocusSetInterface, HotKeyProcessor, Observer, ChoicePeer
{
	protected ChoiceWindow Cw = null;
	protected Vector Data = null;
	protected TextField Entry = new TextField();
	protected int Type = 1;
/**
 * triggered on selection of a choice item
 * parameter: selection
 */
	public ObserverSocket OsSelection = new ObserverSocket( this);
	protected Object Selection = null;
	final public static int READ_ONLY = 0;
	final public static int READ_WRITE = 1;
/**
 * triggered by a choice item paint request , just in case
 * of at least one registered observer.
 * This observer is responsible for all item painting
 * ( overrides the standard string representation)
 * parameter: choice item
 */
	public ObserverSocket OsDrawObject = new ObserverSocket( this);

public Choice(){
	Entry.setBorder( Border.BS_NONE);
	FBorder.setBorder( TextField.DefaultBorderStyle);

	int bw = FBorder.Ext;
	Lo.add( Entry, 0, 0, 1000, 1000, false, bw, bw, -Awt.ScrollBarWidth-2-bw, -bw, 0);

	registerObserver();
}

public Choice( String items){
	this();
	Data = new Vector();
	StringTokenizer tok = new StringTokenizer( items, ",:;");
	while( tok.hasMoreTokens() )
		Data.addElement( tok.nextToken() );
}

public Choice( Vector data){
	this();
	Data = data;
}

public Choice( int type, Vector data) {
	this();
	Type = type;
	Data = data;
	Entry.setReadOnly( Type == READ_ONLY);
}

public Choice( java.awt.Choice choice){
	this();

	setPeerTarget( choice);
	Data = new Vector( choice.countItems() );

	for ( int i=0; i<choice.countItems(); i++)
		Data.addElement( choice.getItem( i));

	addNotify();

	setSelection( 0);
}

public void addItem (String item, int index){
	//java.awt.peer.ChoicePeer interface
	if ( Data == null){
		Data = new Vector();
		Data.addElement( item);
	}
	else if ( Data.size() == 0)
		Data.addElement( item);
	else if ( Data.elementAt( 0) instanceof String)
		Data.insertElementAt( item, index);
}

public void append (Object obj){
	if ( Data == null)
		Data = new Vector();
	Data.addElement( obj);
}

public boolean appendUnique (Object obj){
	if ( Data == null)
		Data = new Vector();
	if ( ! Data.contains( obj)){
		Data.addElement( obj);
		return true;
	}
	return false;
}

void buildChoice(){
	Cw = new ChoiceWindow( this);
	Cw.DataPane.OsDrawObject.addObserver( this);
}

public boolean canGetFocus(){
	return Entry.canGetFocus();
}

void closeChoice(){

	//  Cw.hide();
	if ( Cw != null ) {
		Cw.dispose();
		Cw = null;
	}

	Entry.requestFocus();
	redraw();
}

public Vector getContents(){
	return Data;
}

public List getList(){
	if ( Cw != null)
		return Cw.DataPane;
	return null;
}

public Container getParent(){
	//peer creation forwarding
	if ( Entry.PeerTarget != null)
		return Entry.PeerTarget.getParent();
	return super.getParent();
}

void getProcessed ( Object sel){
	Selection = sel;
	if ( setSelection( sel) ){
		OsSelection.notifyObservers( Selection);
		peerEvent( Event.ACTION_EVENT, Entry.getContents() );
	}
	closeChoice();
}

public Object getSelection (){
	return Selection;
}

public int getSelectionIdx (){
	if ( Data == null)
		return 0;
	return Data.indexOf( Selection);
}

public boolean hasFocus(){
	return Entry.hasFocus();
}

boolean isChoiceOpen() {
	return ( (Cw != null) && (Cw.isShowing()));
}

public boolean mouseDown( Event evt, int x, int y) {
	if ( ! Enabled)
		return true;
	if ( Awt.AwtToolkit == Awt.TK_WIN){
		if ( evt.clickCount > 1)
			return true;
	}
	if ( isChoiceOpen() ) closeChoice();
	else                  openChoice();

	return true;
}

public boolean mouseMove( Event evt, int x, int y) {
	if ( Enabled && (x > Entry.Width) )
		Entry.setCursor( Awt.ActionCursor);
	return true;
}

void openChoice() {
	Point pt = Awt.getDesktopLocation( Entry, 0, Entry.Height);

	GUIHandler.disposeSingleInstWnd( this);
	if ( Cw == null)
		buildChoice();

	//perform List default drawing when Drawsocket is empty
	Cw.DataPane.overrideDrawSocket( OsDrawObject.isEmpty() );  

	Cw.popUpAt( pt.x - FBorder.Ext, pt.y + FBorder.Ext, Width);
	Cw.initLabel( Entry.getContents());

	redraw();
	GUIHandler.SingleInstWnd = Cw;

	CommandQueue.append( new ToFrontCmd( Cw));
}

public Dimension preferredSize(){
	return new Dimension( 10*Awt.SysFontWidth, 3*Awt.SysFontHeight/2);
}

public void processKey(Object sel){
	if ( sel.equals( "popDown"))
		openChoice();
}

public void redraw( Graphics g){

	int x = Entry.Width + FBorder.Ext;
	int y = FBorder.Ext - 1;
	int w = Awt.ScrollBarWidth + 2;
	int h = Entry.Height + 1;

	GraphicsLib.paintChoiceButton( g, x, y, w, h, Cw != null);
}

public void registerObserver (){
	Entry.OsFocusGot.addObserver( this);
	Entry.OsFocusLost.addObserver( this);
	Entry.OsEnter.addObserver( this);

	Entry.addHotKey( 'd', HotKey.Control, this, "popDown");
}

public void remove (Object obj){
	if ( Data != null)
		Data.removeElement( obj);
}

public void select (int index){
	//java.awt.peer.ChoicePeer interface
	setSelection( index);
}

public synchronized void setBackground( Color c){
	Entry.setBackground( c);

	Entry.redraw(); // Windows bug
}

public void setContents( Vector v){
	Data = v;
	setSelection( 0);
}

public boolean setFocus(){
	return Entry.setFocus();
}

public boolean setFocusIfActive () {
	TopWindow tw = (TopWindow) getFrame();

	if ( tw != null && tw.isActive() )
		return setFocus();
	else
		return false;
}

public synchronized void setFont( Font f){
	Entry.setFont( f);

	Entry.redraw(); // Windows bug
}

public synchronized void setForeground( Color c){
	Entry.setForeground( c);

	Entry.redraw(); // Windows bug
}

public void setReadOnly( boolean state){
	Entry.setReadOnly( state);
}

public boolean setSelection ( Object sel){
	String s;

	if ( (Data == null) || (sel == null) ){
		Selection = null;
		return false;
	}

	if ( Type == READ_ONLY){
		if ( ! Data.contains( sel))
			return false;
	}

	if ( sel instanceof SelfDrawingObject)
		s = ((SelfDrawingObject)sel).label();
	else
		s = sel.toString();

	Selection = sel;
	Entry.setContents( s);
	return true;
}

public boolean setSelection ( int idx){
	String s;

	try {
		Selection = Data.elementAt( idx);

		if ( Selection instanceof SelfDrawingObject)
			s = ((SelfDrawingObject)Selection).label();
		else
			s = Selection.toString();

		Entry.setContents( s);
		return true;
	}
	catch( Throwable t) {
		Entry.setContents( "");
		return false;
	}
}

public String stringSelection (){
	Selection = Entry.getContents();
	return (String)Selection;
}

/**
 *
 */
public void update (Observable obs, Object arg){
	if ( obs == Entry.OsFocusGot)
		OsFocusGot.notifyObservers();
	else if ( obs == Entry.OsFocusLost)
		OsFocusLost.notifyObservers();
	else if ( obs == Entry.OsEnter){
		Selection = Entry.getContents();
		OsSelection.notifyObservers( Selection);
	}
	else if ( (Cw != null) && (obs == Cw.DataPane.OsDrawObject) )
		OsDrawObject.notifyObservers( arg);
}
}

class ChoiceWindow
  extends Window
  implements Observer, SingleInstInterface
{
	Choice CP = null;
	List DataPane = new List( List.SPS_NOHSCROLL);
	Layouter Lo = new Layouter( this);

public ChoiceWindow ( Choice cp) {
	super( cp.Entry.getFrame());
	CP = cp;

	if ( Awt.AwtToolkit == Awt.TK_WIN || Awt.AwtToolkit == Awt.TK_OS2 ) {
		reshape( 0, 0, 10, 10);
		Lo.add( DataPane, 0, 0, 1000, 1000, false, 2, 2, -2, -2, 0);
		pack();
	}
	else
		Lo.add( DataPane, 0, 0, 1000, 1000, false, 2, 2, -2, -2, 0);

	registerObserver();
}

public boolean disposeRequest( Component nextFocus){
	if ( (nextFocus != DataPane.Cv) && (nextFocus != DataPane.Vert)) {
		CP.closeChoice();
		return true;
	}
	return false;
}

public boolean initLabel( String label){
	return ((ListCanvas)DataPane.BaseCv).selectLabel( label);
}

public void paint ( Graphics g){
	Rectangle r = bounds();
	g.setColor( Color.black);
	g.drawRect( 0, 0, r.width-1, r.height-1);
}

public void popUpAt( int x, int y, int width){
	DataPane.setForeground( CP.Entry.getForeground() );
	DataPane.setBackground( CP.Entry.getBackground() );

	reshape( x, y, width, 4*Awt.SysFontHeight );
	show();
	DataPane.setContents( CP.Data);
	DataPane.setFocus();
}

public void registerObserver (){
	DataPane.OsProcess.addObserver( this);
	DataPane.OsSelection.addObserver( this);
}

public void update ( Observable o, Object arg){
	if ( DataPane.OsProcess.equals( o))
		CP.getProcessed( DataPane.getSelection() );
	else if ( DataPane.OsSelection.equals( o)) {
		if ( DataPane.mouseSelection() )
			CP.getProcessed( DataPane.getSelection() );
	}
}
}
