/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
# ifndef DECLARATORINVNODELIST_H
# define DECLARATORINVNODELIST_H

typedef /*@only@*/ declaratorInvNode o_declaratorInvNode;

abst_typedef struct _declaratorInvNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_declaratorInvNode  *elements;
} *declaratorInvNodeList ;

/*@iter declaratorInvNodeList_elements (sef declaratorInvNodeList x, yield exposed declaratorInvNode el); @*/
# define declaratorInvNodeList_elements(x, m_el) \
   { int m_ind; declaratorInvNode *m_elements = &((x)->elements[0]); \
       for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
	 { declaratorInvNode m_el = *(m_elements++); 

# define end_declaratorInvNodeList_elements }}

extern int declaratorInvNodeList_size (declaratorInvNodeList);
# define declaratorInvNodeList_size(d) ((d)->nelements)

extern /*@only@*/ declaratorInvNodeList declaratorInvNodeList_new(void);

extern declaratorInvNodeList 
  declaratorInvNodeList_add (/*@returned@*/ declaratorInvNodeList p_s,
			      /*@only@*/ declaratorInvNode p_el);

extern /*@only@*/ cstring declaratorInvNodeList_unparse (declaratorInvNodeList p_s) ;
extern void declaratorInvNodeList_free (/*@only@*/ declaratorInvNodeList p_s) ;

/*@constant int declaratorInvNodeListBASESIZE;@*/
# define declaratorInvNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




