/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/

# ifndef GENERAL_H
# define GENERAL_H

/* sgi's don't let you undef NULL */
# ifndef IRIX 
# ifdef NULL
# undef NULL
# endif
# endif

# include "forwardTypes.h"
# include "cstring.h"
# include "bool.h"

extern /*@out@*/ /*@only@*/ void *dimalloc  (size_t p_size, char *p_name, int p_line);
extern /*@only@*/ void *dicalloc  (size_t p_num, size_t p_size, char *p_name, int p_line);
extern /*@notnull@*/ /*@out@*/ /*@only@*/ void *
  direalloc (/*@returned@*/ /*@only@*/ /*@out@*/ /*@null@*/ void *p_x, 
	     size_t p_size, char *p_name, int p_line);

extern /*@out@*/ /*@only@*/ void *
  drealloc (/*@only@*/ /*@out@*/ /*@null@*/ /*@sef@*/ void *p_x,
	    /*@sef@*/ size_t p_size)
  /*@modifies *p_x@*/ ;

extern /*@out@*/ /*@only@*/ void *dmalloc  (/*@sef@*/ size_t p_size) /*@*/ ;

# ifdef USEDMALLOC
# define dmalloc(s)    (malloc(s))
# define drealloc(s,l) (realloc(s,l))
# else
# define dmalloc(s)    (dimalloc(s, __FILE__, __LINE__))
# define drealloc(s,l) (direalloc(s, l, __FILE__, __LINE__))
# endif

# include "system_constants.h"

# ifdef USEGC
# include <gc.h>
# define NOFREE
# define free(s) ; /* nothing */ 
# else
# endif

# ifdef USEDMALLOC
# include "dmalloc.h"
# endif

/*
** no file except general.c should use primitive
** memory operations:
*/

/*@-exportlocal@*/
# ifndef USEDMALLOC
# undef malloc
# undef realloc
# undef calloc
# define malloc(s)     (dimalloc(s, __FILE__, __LINE__))
# define calloc(n, s)  (dicalloc(n, s, __FILE__, __LINE__))
# define realloc(v, s) (direalloc(v, s, __FILE__, __LINE__))
# endif
/*@=exportlocal@*/

# ifndef NULL
# define NULL 0
# endif 

# ifdef USEDMALLOC
# define sfree(x) do { if (x != NULL) free(x); } while (FALSE)
# else
extern void sfree (/*@out@*/ /*@only@*/ /*@null@*/ void *p_x) /*@modifies *p_x@*/; 
# endif

extern void sfreeEventually (/*@owned@*/ /*@null@*/ void *p_x) 
   /*@modifies internalState@*/; 

typedef /*@dependent@*/ char *d_char;

/*@constant int NOT_FOUND;@*/
# define NOT_FOUND (-23)

# else
# error "Multiple include"
# endif






