/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
# ifndef LLMAIN_H
# define LLMAIN_H

extern int main (int p_argc, char *p_argv[])
  /*@globals killed undef g_currentloc,
             killed       g_localIncludePath,
             killed       g_includePath, 
	     killed       g_localSpecPath,  
	     killed undef g_currentSpec,
	     killed undef g_currentSpecName,
	     killed undef g_currentloc,
	     killed undef yyin,
                    undef g_msgstream,
	     yydebug;
   @*/
  /*@modifies g_currentloc, g_localIncludePath, g_includePath,
              g_localSpecPath, g_currentSpec, g_currentSpecName,
	      yyin, yydebug, internalState, fileSystem; 
  @*/ ;

extern /*@exits@*/ void llexit (int p_status);      
extern void showHerald (void);

/*@-redecl@*/
extern int yyparse (void);
extern int ylparse (void);
extern void yyrestart (FILE *p_f);
extern int lslparse (void);
/*@=redecl@*/

# ifndef unlink
extern /*@external@*/ int unlink (char *p_path) /*@modifies fileSystem@*/ ;
# endif

/*@-incondefs@*/ /*@-redecl@*/
extern /*@dependent@*/ FILE *yyin;
/*@=incondefs@*/ /*@=redecl@*/

/* from <unistd.h> (cannot include because <stddef.h> is broken on many machines */
extern /*@external@*/ int getpid (void);

# ifndef system
extern /*@external@*/ int system (const char *) /*@modifies fileSystem@*/ ;
# endif

# endif


